/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.settings;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.IOException;

public class ProjectSettingStore
extends BundleSettingStore {
    public ProjectSettingStore(String projectDir) {
        super(projectDir, "com.kms.katalon.composer.project", false);
    }

    public static ProjectSettingStore getStore() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        if (projectEntity == null) {
            return null;
        }
        return new ProjectSettingStore(projectEntity.getFolderLocation());
    }

    public static ProjectSettingStore getStore(String projectLocation) {
        return new ProjectSettingStore(projectLocation);
    }

    public boolean isProjectDifferentVersionsAndEdtionsWarningShown() {
        try {
            return this.getBoolean("project.differentVersionsAndEditionsWarningShown", false);
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    public void setProjectDifferentVersionsAndEdtionsWarningShown(boolean isShown) throws IOException {
        this.setProperty("project.differentVersionsAndEditionsWarningShown", isShown);
    }
}

