/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.core.presentation.part;

import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.onboarding.core.application.controller.IKnowledgeHubNavigationController;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTour;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTourProgress;
import com.kms.katalon.webserver.WebViewController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class KnowledgeHubPart {
    @Inject
    private IKnowledgeHubNavigationController controller;
    private volatile String currentUrl;
    private Browser browser;

    @PostConstruct
    public void createControls(Composite parent) {
        this.browser = (Browser)ComponentBuilder.browser((Composite)parent).defaultBrowserConfig().fill().build();
        this.browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                Display.getCurrent().timerExec(100, () -> KnowledgeHubPart.this.registerBrowserFunctions());
            }

            public void changed(ProgressEvent event) {
            }
        });
        this.registerBrowserFunctions();
        this.controller.setPart(this);
        this.controller.openOverviewPage();
    }

    private void registerBrowserFunctions() {
        new BrowserFunction(this.browser, "onTourClicked"){

            public Object function(Object[] arguments) {
                if (arguments.length > 0) {
                    KnowledgeHubPart.this.controller.onTourItemClicked((String)arguments[0]);
                }
                return true;
            }
        };
        new BrowserFunction(this.browser, "onKnowledgeItemClicked"){

            public Object function(Object[] arguments) {
                if (arguments.length > 0) {
                    KnowledgeHubPart.this.controller.onKnowledgeItemClicked((String)arguments[0]);
                }
                return true;
            }
        };
        new BrowserFunction(this.browser, "onReplayClicked"){

            public Object function(Object[] arguments) {
                if (arguments.length > 0) {
                    KnowledgeHubPart.this.controller.onReplayClicked((String)arguments[0]);
                }
                return true;
            }
        };
        new BrowserFunction(this.browser, "onRated"){

            public Object function(Object[] arguments) {
                if (arguments.length > 1) {
                    int intValue;
                    Object arg = arguments[0];
                    if (arg instanceof Double) {
                        intValue = ((Double)arg).intValue();
                    } else if (arg instanceof Integer) {
                        intValue = (Integer)arg;
                    } else if (arg instanceof String) {
                        intValue = Integer.parseInt((String)arg);
                    } else {
                        throw new IllegalArgumentException(MessageFormat.format(OnboardingMessageConstants.ERROR_UNEXPECTED_TYPE, arg.getClass()));
                    }
                    KnowledgeHubPart.this.controller.onRated((String)arguments[1], intValue);
                }
                return true;
            }
        };
        new BrowserFunction(this.browser, "onBackClicked"){

            public Object function(Object[] arguments) {
                KnowledgeHubPart.this.controller.navigateBack();
                return true;
            }
        };
        new BrowserFunction(this.browser, "onReferenceItemClicked"){

            public Object function(Object[] arguments) {
                if (arguments.length > 0) {
                    KnowledgeHubPart.this.controller.onKnowledgeItemClicked((String)arguments[0]);
                }
                return true;
            }
        };
        new BrowserFunction(this.browser, "onSwitchTab"){

            public Object function(Object[] arguments) {
                if (arguments.length > 0) {
                    KnowledgeHubPart.this.controller.switchTab((String)arguments[0]);
                }
                return true;
            }
        };
    }

    public void updateBrowser(String url) {
        this.currentUrl = url;
        this.browser.setUrl(url);
        Display.getCurrent().timerExec(500, () -> this.registerBrowserFunctions());
    }

    public void openOverview(String knowledgeHubJson, String progressJson) throws UnsupportedEncodingException {
        String encodedKnowledge = this.encodeJson(knowledgeHubJson);
        String encodedProgress = this.encodeJson(progressJson);
        String url = this.getOnboardingBaseUrl() + "/KnowledgeHub?knowledgehub=" + encodedKnowledge + "&progress=" + encodedProgress + "&tab=for_you";
        this.updateBrowser(url);
    }

    public void updateProgress(OnboardingTour tour, OnboardingTourProgress progress, boolean isRunning) throws UnsupportedEncodingException {
        String progressJson = progress.toJson();
        String tourJson = tour.toJson();
        String encodedKnowledgeItem = this.encodeJson(tourJson);
        String encodedProgress = this.encodeJson(progressJson);
        String url = this.getOnboardingBaseUrl() + "/KnowledgeHub/item?item=" + encodedKnowledgeItem + "&tourProgress=" + encodedProgress + "&isRunning=" + isRunning;
        this.updateBrowser(url);
    }

    public String getCurrentUrl() {
        if (this.browser != null && !this.browser.isDisposed()) {
            return this.browser.getUrl();
        }
        return this.currentUrl;
    }

    private String encodeJson(String json) throws UnsupportedEncodingException {
        return URLEncoder.encode(json, StandardCharsets.UTF_8.toString());
    }

    private String getOnboardingBaseUrl() {
        return MessageFormat.format("http://{0}", WebViewController.getInstance().getHost());
    }
}

