/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.UserFileTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.dialogs.NewTextFileDialog;
import com.kms.katalon.composer.explorer.handlers.OpenUserFileHandler;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.UserFileController;
import com.kms.katalon.entity.file.UserFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;

public class NewTextFileHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ESelectionService selectionService;

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell parentShell) {
        try {
            boolean isRoot;
            FolderTreeEntity parentTreeFolder = this.getParentTreeFolder();
            boolean bl = isRoot = parentTreeFolder == null;
            if (isRoot) {
                this.newFileAtRoot(parentShell, ProjectController.getInstance().getCurrentProject());
            } else {
                this.newFileInFolder(parentShell, parentTreeFolder);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Unable to create file", (String)e.getMessage());
        }
    }

    private void newFileAtRoot(Shell parentShell, ProjectEntity project) throws Exception {
        List siblingFileNames = FolderController.getInstance().getRootFileOrFolderNames(project);
        NewTextFileDialog dialog = new NewTextFileDialog(parentShell, siblingFileNames);
        if (dialog.open() == 0) {
            String newFileName = dialog.getNewFileName();
            UserFileEntity newFile = UserFileController.getInstance().newRootFile(newFileName, project);
            this.openFile(newFile);
            this.eventBroker.post("EXPLORER/ADD_AND_SELECT_ITEM", (Object)new UserFileTreeEntity(newFile, null));
        }
    }

    private void newFileInFolder(Shell parentShell, FolderTreeEntity parentTreeFolder) throws Exception {
        FolderEntity parentFolder = parentTreeFolder.getObject();
        List<String> siblingFileNames = UserFileController.getInstance().getChildren(parentFolder).stream().map(f -> f.toFile().getName()).collect(Collectors.toList());
        NewTextFileDialog dialog = new NewTextFileDialog(parentShell, siblingFileNames);
        if (dialog.open() == 0) {
            String newFileName = dialog.getNewFileName();
            UserFileEntity newFile = UserFileController.getInstance().newFile(newFileName, parentFolder);
            this.openFile(newFile);
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeFolder);
            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)new UserFileTreeEntity(newFile, (ITreeEntity)parentTreeFolder));
        }
    }

    private FolderTreeEntity getParentTreeFolder() {
        ITreeEntity parent;
        block6: {
            Object[] selectedObjects;
            block5: {
                try {
                    selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
                    if (selectedObjects != null && selectedObjects.length == 1 && selectedObjects[0] instanceof ITreeEntity) break block5;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (selectedObjects[0] instanceof FolderTreeEntity) {
                FolderTreeEntity parentFolder = (FolderTreeEntity)selectedObjects[0];
                return parentFolder.getObject().getFolderType() == FolderEntity.FolderType.USER ? parentFolder : null;
            }
            ITreeEntity treeEntity = (ITreeEntity)selectedObjects[0];
            parent = treeEntity.getParent();
            if (parent instanceof FolderTreeEntity) break block6;
            return null;
        }
        FolderTreeEntity parentFolder = (FolderTreeEntity)parent;
        return parentFolder.getObject().getFolderType() == FolderEntity.FolderType.USER ? parentFolder : null;
    }

    private void openFile(UserFileEntity file) throws PartInitException, CoreException {
        OpenUserFileHandler.openEditor(file);
    }
}

