/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.handler.CommonExplorerHandler;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.constants.ComposerExplorerMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.entity.file.FileEntity;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class OpenContainingFolderHandler
extends CommonExplorerHandler {
    private static final String VARIABLE_RESOURCE = "${selected_resource_loc}";
    private static final String VARIABLE_RESOURCE_URI = "${selected_resource_uri}";
    private static final String VARIABLE_FOLDER = "${selected_resource_parent_loc}";

    @CanExecute
    public boolean canExecute() {
        return this.isExplorerPartActive();
    }

    @Execute
    public void execute() {
        try {
            List treeEntities = this.getElementSelection(ITreeEntity.class);
            if (treeEntities.isEmpty()) {
                return;
            }
            ITreeEntity treeEntity = (ITreeEntity)treeEntities.get(0);
            String parent = this.getParentFolderLocation(treeEntity);
            File fileLocation = null;
            if (treeEntity instanceof PackageTreeEntity) {
                String packageName = ((PackageTreeEntity)treeEntity).getPackageName();
                String packagePath = "";
                if (!packageName.equals(PackageTreeEntity.DEFAULT_PACKAGE_LABEL)) {
                    packagePath = packageName.replace(".", "/");
                }
                fileLocation = new File(((FileEntity)treeEntity.getParent().getObject()).getLocation(), packagePath);
            } else if (treeEntity instanceof KeywordTreeEntity) {
                ICompilationUnit unit = (ICompilationUnit)((KeywordTreeEntity)treeEntity).getObject();
                fileLocation = unit.getResource().getRawLocation().toFile();
            } else {
                FileEntity fileEntity = (FileEntity)treeEntity.getObject();
                fileLocation = new File(fileEntity.getLocation());
            }
            String launchCmd = this.formShowInSytemExplorerCommand(fileLocation);
            File dir = new File(parent);
            Process p = Util.isLinux() || Util.isMac() ? Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", launchCmd}, null, dir) : Runtime.getRuntime().exec(launchCmd, null, dir);
            int retCode = p.waitFor();
            if (retCode != 0 && !Util.isWindows()) {
                LoggerSingleton.logError((String)("Failed with return code in process" + retCode));
            }
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)GlobalMessageConstants.ERROR, (String)ComposerExplorerMessageConstants.ERROR_CANNOT_FIND_CONTAINING_FOLDER);
        }
    }

    private String formShowInSytemExplorerCommand(File path) throws IOException {
        String command = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SYSTEM_EXPLORER");
        command = Util.replaceAll((String)command, (String)VARIABLE_RESOURCE, (String)this.quotePath(path.getCanonicalPath()));
        command = Util.replaceAll((String)command, (String)VARIABLE_RESOURCE_URI, (String)path.getCanonicalFile().toURI().toString());
        File parent = path.getParentFile();
        if (parent != null) {
            command = Util.replaceAll((String)command, (String)VARIABLE_FOLDER, (String)this.quotePath(parent.getCanonicalPath()));
        }
        return command;
    }

    private String quotePath(String path) {
        if (Util.isLinux() || Util.isMac()) {
            path = path.replaceAll("[\"$`]", "\\\\$0");
        }
        return path;
    }

    private String getParentFolderLocation(ITreeEntity treeEntity) throws Exception {
        ITreeEntity treeParent = treeEntity.getParent();
        if (treeEntity instanceof KeywordTreeEntity) {
            FileEntity keywordFolder = (FileEntity)treeParent.getParent().getObject();
            String packageName = ((PackageTreeEntity)treeParent).getPackageName();
            if (packageName.equals(PackageTreeEntity.DEFAULT_PACKAGE_LABEL)) {
                return keywordFolder.getLocation();
            }
            return keywordFolder.getLocation() + File.separator + this.getPathToPackage(packageName, true);
        }
        if (treeEntity instanceof PackageTreeEntity) {
            String packageName = ((PackageTreeEntity)treeEntity).getPackageName();
            if (packageName.equals(PackageTreeEntity.DEFAULT_PACKAGE_LABEL)) {
                return ((FileEntity)treeParent.getObject()).getLocation();
            }
            return ((FileEntity)treeParent.getObject()).getLocation() + this.getPathToPackage(packageName, false);
        }
        FileEntity fileEntity = (FileEntity)treeEntity.getObject();
        return fileEntity.getParentFolder() != null ? fileEntity.getParentFolder().getLocation() : fileEntity.getLocationProjectFolder();
    }

    private String getPathToPackage(String packageName, boolean insidePackage) {
        StringBuilder builder = new StringBuilder();
        String[] packages = packageName.split("\\.");
        int chainLength = packages.length;
        if (!insidePackage) {
            --chainLength;
        }
        int i = 0;
        while (i < chainLength) {
            builder.append(File.separator + packages[i]);
            ++i;
        }
        return builder.toString();
    }
}

