/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.handlers;

import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import jakarta.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ReskinTextAreaHandler
extends EventServiceAdapter {
    private static final String ACTIVE_TAG = "active";
    private static final String REMOVE_ITEM_TOPIC = "org/eclipse/e4/ui/model/application/ApplicationElement/*".replace("*", "") + "tags/REMOVE";
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;

    @Inject
    public void registerEventHandler() {
        this.eventBroker.subscribe(REMOVE_ITEM_TOPIC, (EventHandler)this);
    }

    public void handleEvent(Event event) {
        if (REMOVE_ITEM_TOPIC.equals(event.getTopic()) && this.isCTabFolderActiveTagRemoved(event) && this.isNotEditorTabItemRemoved(event)) {
            MPlaceholder textArea = (MPlaceholder)this.modelService.find("org.eclipse.ui.editorss", (MUIElement)this.application);
            if (textArea == null || !textArea.isVisible()) {
                return;
            }
            this.reskinTextArea(textArea);
        }
    }

    private boolean isCTabFolderActiveTagRemoved(Event event) {
        return ACTIVE_TAG.equals(event.getProperty("OldValue")) && event.getProperty("Widget") instanceof CTabFolder;
    }

    private boolean isNotEditorTabItemRemoved(Event event) {
        Object changedElement = event.getProperty("ChangedElement");
        return !(changedElement instanceof MPartStack) || !((MPartStack)changedElement).getElementId().startsWith("com.kms.katalon.composer.content");
    }

    private void reskinTextArea(MPlaceholder textArea) {
        Composite editorTabFolder = (Composite)textArea.getRef().getWidget();
        if (editorTabFolder == null || editorTabFolder.isDisposed()) {
            return;
        }
        if (!(editorTabFolder.getChildren()[0] instanceof CTabFolder)) {
            return;
        }
        CTabFolder tabFolder = (CTabFolder)editorTabFolder.getChildren()[0];
        if (tabFolder.getItemCount() > 0) {
            tabFolder.reskin(1);
        }
    }
}

