/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.syntax.Token;

public class CompareIdentityExpression
extends BinaryExpression
implements Opcodes {
    public CompareIdentityExpression(Expression leftExpression, Expression rightExpression) {
        this(leftExpression, true, rightExpression);
    }

    public CompareIdentityExpression(Expression leftExpression, boolean eq, Expression rightExpression) {
        super(leftExpression, Token.newSymbol((String)(eq ? "===" : "!=="), (int)-1, (int)-1), rightExpression);
        super.setType(ClassHelper.boolean_TYPE);
    }

    public boolean isEq() {
        return this.getOperation().getText().charAt(0) == '=';
    }

    public void setType(ClassNode type) {
        throw new UnsupportedOperationException();
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        CompareIdentityExpression ret = new CompareIdentityExpression(transformer.transform(this.getLeftExpression()), this.isEq(), transformer.transform(this.getRightExpression()));
        ret.setSourcePosition((ASTNode)((Object)this));
        ret.copyNodeMetaData((ASTNode)((Object)this));
        return ret;
    }

    public void visit(GroovyCodeVisitor visitor) {
        if (visitor instanceof AsmClassGenerator) {
            WriterController controller = ((AsmClassGenerator)((Object)visitor)).getController();
            MethodVisitor mv = controller.getMethodVisitor();
            this.getLeftExpression().visit(visitor);
            controller.getOperandStack().box();
            this.getRightExpression().visit(visitor);
            controller.getOperandStack().box();
            Label l1 = new Label();
            if (!this.isEq()) {
                mv.visitJumpInsn(165, l1);
            } else {
                mv.visitJumpInsn(166, l1);
            }
            mv.visitInsn(4);
            Label l2 = new Label();
            mv.visitJumpInsn(167, l2);
            mv.visitLabel(l1);
            mv.visitInsn(3);
            mv.visitLabel(l2);
            controller.getOperandStack().replace(ClassHelper.boolean_TYPE, 2);
        } else {
            super.visit(visitor);
        }
    }
}

