/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.trait;

import groovy.transform.CompilationUnitAware;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.groovy.ast.tools.AnnotatedNodeUtils;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.MethodNodeUtils;
import org.apache.groovy.util.BeanUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.classgen.VariableScopeVisitor;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ASTTransformationVisitor;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.trait.NAryOperationRewriter;
import org.codehaus.groovy.transform.trait.SuperCallTraitTransformer;
import org.codehaus.groovy.transform.trait.TraitReceiverTransformer;
import org.codehaus.groovy.transform.trait.Traits;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class TraitASTTransformation
extends AbstractASTTransformation
implements CompilationUnitAware {
    public static final String DO_DYNAMIC = TraitReceiverTransformer.class + ".doDynamic";
    public static final String POST_TYPECHECKING_REPLACEMENT = TraitReceiverTransformer.class + ".replacement";
    private static final ClassNode INVOKERHELPER_CLASSNODE = ClassHelper.make(InvokerHelper.class);
    private static final ClassNode OVERRIDE_CLASSNODE = ClassHelper.make(Override.class);
    private SourceUnit sourceUnit;
    private CompilationUnit compilationUnit;

    public void setCompilationUnit(CompilationUnit unit) {
        this.compilationUnit = unit;
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!Traits.TRAIT_CLASSNODE.equals(anno.getClassNode())) {
            return;
        }
        this.sourceUnit = source;
        this.init(nodes, source);
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            if (!this.checkNotInterface(cNode, Traits.TRAIT_TYPE_NAME)) {
                return;
            }
            this.checkNoConstructor(cNode);
            this.checkExtendsClause(cNode);
            TraitASTTransformation.generateMethodsWithDefaultArgs(cNode);
            this.replaceExtendsByImplements(cNode);
            ClassNode helperClassNode = this.createHelperClass(cNode);
            this.resolveHelperClassIfNecessary(helperClassNode);
        }
    }

    private void resolveHelperClassIfNecessary(ClassNode helperClassNode) {
        if (helperClassNode == null) {
            return;
        }
        for (ClassNode cNode : this.sourceUnit.getAST().getClasses()) {
            ClassNode unresolvedHelperNode = (ClassNode)cNode.getNodeMetaData("UNRESOLVED_HELPER_CLASS");
            if (unresolvedHelperNode == null || !unresolvedHelperNode.getName().equals(helperClassNode.getName())) continue;
            unresolvedHelperNode.setRedirect(helperClassNode);
        }
    }

    private static void generateMethodsWithDefaultArgs(ClassNode cNode) {
        DefaultArgsMethodsAdder adder = new DefaultArgsMethodsAdder();
        adder.addDefaultParameterMethods(cNode);
    }

    private void checkExtendsClause(ClassNode cNode) {
        ClassNode superClass = cNode.getSuperClass();
        if (superClass.isInterface() && !Traits.isTrait(superClass)) {
            this.addError("Trait cannot extend an interface. Use 'implements' instead", cNode);
        }
    }

    private void replaceExtendsByImplements(ClassNode cNode) {
        ClassNode superClass = cNode.getUnresolvedSuperClass();
        if (Traits.isTrait(superClass)) {
            cNode.setSuperClass(ClassHelper.OBJECT_TYPE);
            cNode.setUnresolvedSuperClass(ClassHelper.OBJECT_TYPE);
            cNode.addInterface(superClass);
            this.resolveScope(cNode);
        }
    }

    private void resolveScope(ClassNode cNode) {
        VariableScopeVisitor scopeVisitor = new VariableScopeVisitor(this.sourceUnit);
        scopeVisitor.visitClass(cNode);
    }

    private void checkNoConstructor(ClassNode cNode) {
        if (!cNode.getDeclaredConstructors().isEmpty()) {
            this.addError("Error processing trait '" + cNode.getName() + "'. " + " Constructors are not allowed.", cNode);
        }
    }

    private ClassNode createHelperClass(ClassNode cNode) {
        InnerClassNode helper = new InnerClassNode(cNode, Traits.helperClassName(cNode), 5129, ClassHelper.OBJECT_TYPE, ClassNode.EMPTY_ARRAY, null);
        cNode.setModifiers(1537);
        this.checkInnerClasses(cNode);
        MethodNode initializer = TraitASTTransformation.createInitMethod(false, cNode, (ClassNode)helper);
        MethodNode staticInitializer = TraitASTTransformation.createInitMethod(true, cNode, (ClassNode)helper);
        TraitASTTransformation.generatePropertyMethods(cNode);
        ArrayList<Object> fields = new ArrayList<FieldNode>();
        HashSet<String> fieldNames = new HashSet<String>();
        boolean hasStatic = false;
        for (FieldNode field : cNode.getFields()) {
            if ("metaClass".equals(field.getName()) || field.isSynthetic() && field.getName().indexOf(36) >= 0) continue;
            fields.add(field);
            fieldNames.add(field.getName());
            if (!field.isStatic()) continue;
            hasStatic = true;
        }
        InnerClassNode fieldHelper = null;
        InnerClassNode staticFieldHelper = null;
        if (!fields.isEmpty()) {
            fieldHelper = new InnerClassNode(cNode, Traits.fieldHelperClassName(cNode), 5641, ClassHelper.OBJECT_TYPE);
            if (hasStatic) {
                staticFieldHelper = new InnerClassNode(cNode, Traits.staticFieldHelperClassName(cNode), 5641, ClassHelper.OBJECT_TYPE);
            }
        }
        for (FieldNode fieldNode : fields) {
            this.processField(fieldNode, initializer, staticInitializer, (ClassNode)fieldHelper, (ClassNode)helper, (ClassNode)staticFieldHelper, cNode, fieldNames);
        }
        ArrayList<MethodNode> arrayList = new ArrayList<MethodNode>(cNode.getMethods());
        LinkedList<MethodNode> nonPublicAPIMethods = new LinkedList<MethodNode>();
        List staticInitStatements = null;
        for (MethodNode methodNode : arrayList) {
            boolean declared;
            boolean bl = declared = methodNode.getDeclaringClass() == cNode;
            if (!declared) continue;
            if (!methodNode.isSynthetic() && (methodNode.isProtected() || !methodNode.isPrivate() && !methodNode.isPublic())) {
                this.sourceUnit.addError(new SyntaxException("Cannot have protected/package-private method in a trait (" + cNode.getName() + "#" + methodNode.getTypeDescriptor() + ")", methodNode.getLineNumber(), methodNode.getColumnNumber()));
                return null;
            }
            if (!methodNode.isAbstract()) {
                MethodNode methodNode2 = this.processMethod(cNode, (ClassNode)helper, methodNode, (ClassNode)fieldHelper, fieldNames);
                if (methodNode.getName().equals("<clinit>")) {
                    staticInitStatements = MethodNodeUtils.getCodeAsBlock((MethodNode)methodNode2).getStatements();
                } else {
                    helper.addMethod(methodNode2);
                    methodNode2.setOriginal(methodNode);
                }
            }
            if (!methodNode.isPrivate() && !methodNode.isStatic()) continue;
            nonPublicAPIMethods.add(methodNode);
        }
        for (MethodNode privateMethod : nonPublicAPIMethods) {
            cNode.removeMethod(privateMethod);
        }
        cNode.putNodeMetaData("trait.methods", nonPublicAPIMethods);
        if (staticInitStatements != null) {
            BlockStatement toBlock = this.getBlockStatement(staticInitializer, staticInitializer.getCode());
            for (Statement next : staticInitStatements) {
                toBlock.addStatement(next);
            }
        }
        List<Statement> initStatements = cNode.getObjectInitializerStatements();
        Statement toCode = initializer.getCode();
        BlockStatement toBlock = this.getBlockStatement(initializer, toCode);
        for (Statement statement : initStatements) {
            Parameter selfParam = TraitASTTransformation.createSelfParameter(cNode, false);
            toBlock.addStatement(this.processBody(GeneralUtils.varX((Variable)selfParam), statement, cNode, (ClassNode)helper, (ClassNode)fieldHelper, fieldNames));
        }
        initStatements.clear();
        cNode.putNodeMetaData("trait.properties", new ArrayList<PropertyNode>(cNode.getProperties()));
        cNode.getProperties().clear();
        TraitASTTransformation.copyClassAnnotations(cNode, (ClassNode)helper);
        AnnotatedNodeUtils.markAsGenerated((ClassNode)cNode, (AnnotatedNode)helper);
        fields = new ArrayList<FieldNode>(cNode.getFields());
        for (FieldNode fieldNode : fields) {
            cNode.removeField(fieldNode.getName());
        }
        cNode.putNodeMetaData("trait.fields", fields);
        this.registerASTTransformations((ClassNode)helper);
        this.sourceUnit.getAST().addClass((ClassNode)helper);
        if (fieldHelper != null) {
            this.sourceUnit.getAST().addClass((ClassNode)fieldHelper);
            if (staticFieldHelper != null) {
                this.sourceUnit.getAST().addClass((ClassNode)staticFieldHelper);
            }
        }
        this.resolveScope((ClassNode)helper);
        if (fieldHelper != null) {
            this.resolveScope((ClassNode)fieldHelper);
            if (staticFieldHelper != null) {
                this.resolveScope((ClassNode)staticFieldHelper);
            }
        }
        return helper;
    }

    private BlockStatement getBlockStatement(MethodNode targetMethod, Statement code) {
        BlockStatement blockStmt;
        if (code instanceof BlockStatement) {
            blockStmt = (BlockStatement)code;
        } else {
            blockStmt = GeneralUtils.block((Statement[])new Statement[]{code});
            targetMethod.setCode((Statement)blockStmt);
        }
        return blockStmt;
    }

    private static MethodNode createInitMethod(boolean isStatic, ClassNode cNode, ClassNode helper) {
        MethodNode initializer = new MethodNode(isStatic ? "$static$init$" : "$init$", 4105, ClassHelper.VOID_TYPE, new Parameter[]{TraitASTTransformation.createSelfParameter(cNode, isStatic)}, ClassNode.EMPTY_ARRAY, (Statement)new BlockStatement());
        helper.addMethod(initializer);
        return initializer;
    }

    private void registerASTTransformations(ClassNode helper) {
        ASTTransformationVisitor.addNewPhaseOperation(this.compilationUnit, this.sourceUnit, helper);
        this.compilationUnit.addPhaseOperation((source, context, classNode2) -> {
            if (classNode2 != helper) {
                return;
            }
            PostTypeCheckingExpressionReplacer visitor = new PostTypeCheckingExpressionReplacer(source);
            visitor.visitClass(helper);
        }, CompilePhase.INSTRUCTION_SELECTION.getPhaseNumber());
    }

    private static void copyClassAnnotations(ClassNode cNode, ClassNode helper) {
        List<AnnotationNode> annotations = cNode.getAnnotations();
        for (AnnotationNode annotation : annotations) {
            if (annotation.getClassNode().equals(Traits.TRAIT_CLASSNODE)) continue;
            helper.addAnnotation(annotation);
        }
    }

    private void checkInnerClasses(ClassNode cNode) {
        Iterator<InnerClassNode> it = cNode.getInnerClasses();
        while (it.hasNext()) {
            InnerClassNode origin = it.next();
            if ((origin.getModifiers() & 8) != 0) continue;
            this.sourceUnit.addError(new SyntaxException("Cannot have non-static inner class inside a trait (" + origin.getName() + ")", origin.getLineNumber(), origin.getColumnNumber()));
        }
    }

    private static void generatePropertyMethods(ClassNode cNode) {
        for (PropertyNode node : cNode.getProperties()) {
            TraitASTTransformation.processProperty(cNode, node);
        }
    }

    private static void processProperty(ClassNode cNode, PropertyNode node) {
        Statement setterBlock;
        String name = node.getName();
        FieldNode field = node.getField();
        int propNodeModifiers = node.getModifiers() & 0x1F;
        String getterName = GeneralUtils.getGetterName((PropertyNode)node);
        String setterName = GeneralUtils.getSetterName((String)name);
        Statement getterBlock = node.getGetterBlock();
        if (getterBlock == null) {
            MethodNode getter = cNode.getGetterMethod(getterName);
            if (getter == null && node.getType().equals(ClassHelper.boolean_TYPE)) {
                getter = cNode.getGetterMethod("is" + BeanUtils.capitalize((String)name));
            }
            if (!node.isPrivate() && TraitASTTransformation.methodNeedsReplacement(cNode, getter)) {
                getterBlock = GeneralUtils.stmt((Expression)GeneralUtils.fieldX((FieldNode)field));
            }
        }
        if ((setterBlock = node.getSetterBlock()) == null) {
            MethodNode setter = cNode.getSetterMethod(setterName, false);
            if (!node.isPrivate() && (propNodeModifiers & 0x10) == 0 && TraitASTTransformation.methodNeedsReplacement(cNode, setter)) {
                setterBlock = GeneralUtils.assignS((Expression)GeneralUtils.fieldX((FieldNode)field), (Expression)GeneralUtils.varX((String)name));
            }
        }
        if (getterBlock != null) {
            MethodNode getter = new MethodNode(getterName, propNodeModifiers, node.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, getterBlock);
            getter.setNameStart(field.getNameStart());
            getter.setNameEnd(field.getNameEnd());
            getter.setSynthetic(true);
            ClassNodeUtils.addGeneratedMethod((ClassNode)cNode, (MethodNode)getter);
            if (node.getType().equals(ClassHelper.boolean_TYPE) || node.getType().equals(ClassHelper.Boolean_TYPE)) {
                MethodNode secondGetter = new MethodNode("is" + BeanUtils.capitalize((String)name), propNodeModifiers, node.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, getterBlock);
                secondGetter.setNameStart(field.getNameStart());
                secondGetter.setNameEnd(field.getNameEnd());
                secondGetter.setSynthetic(true);
                ClassNodeUtils.addGeneratedMethod((ClassNode)cNode, (MethodNode)secondGetter);
            }
        }
        if (setterBlock != null) {
            VariableExpression var = (VariableExpression)((BinaryExpression)((ExpressionStatement)setterBlock).getExpression()).getRightExpression();
            Parameter setterParameter = new Parameter(node.getType(), name);
            var.setAccessedVariable((Variable)setterParameter);
            MethodNode setter = new MethodNode(setterName, propNodeModifiers, ClassHelper.VOID_TYPE, GeneralUtils.params((Parameter[])new Parameter[]{setterParameter}), ClassNode.EMPTY_ARRAY, setterBlock);
            setter.setNameStart(field.getNameStart());
            setter.setNameEnd(field.getNameEnd());
            setter.setSynthetic(true);
            ClassNodeUtils.addGeneratedMethod((ClassNode)cNode, (MethodNode)setter);
        }
    }

    private static boolean methodNeedsReplacement(ClassNode cNode, MethodNode mNode) {
        if (mNode == null) {
            return true;
        }
        if (mNode.getDeclaringClass() == cNode) {
            return false;
        }
        return (mNode.getModifiers() & 0x10) == 0;
    }

    private void processField(FieldNode field, MethodNode initializer, MethodNode staticInitializer, ClassNode fieldHelper, ClassNode helper, ClassNode staticFieldHelper, ClassNode trait, Set<String> knownFields) {
        ClassNode target;
        if (field.isProtected()) {
            this.sourceUnit.addError(new SyntaxException("Cannot have protected field in a trait (" + trait.getName() + "#" + field.getName() + ")", field.getLineNumber(), field.getColumnNumber()));
            return;
        }
        Expression initialExpression = field.getInitialExpression();
        MethodNode selectedMethod = field.isStatic() ? staticInitializer : initializer;
        ClassNode classNode = target = field.isStatic() && staticFieldHelper != null ? staticFieldHelper : fieldHelper;
        if (initialExpression != null) {
            VariableExpression thisObject = GeneralUtils.varX((Variable)selectedMethod.getParameters()[0]);
            ExpressionStatement initCode = new ExpressionStatement(initialExpression);
            this.processBody(thisObject, (Statement)initCode, trait, helper, fieldHelper, knownFields);
            if (field.isFinal()) {
                String baseName = field.isStatic() ? "$static$init$" : "$init$";
                MethodNode fieldInitializer = new MethodNode(String.valueOf(baseName) + Traits.remappedFieldName(trait, field.getName()), 4105, field.getOriginType(), new Parameter[]{TraitASTTransformation.createSelfParameter(trait, field.isStatic())}, ClassNode.EMPTY_ARRAY, GeneralUtils.returnS((Expression)initCode.getExpression()));
                helper.addMethod(fieldInitializer);
            } else {
                MethodCallExpression mce;
                BlockStatement code = (BlockStatement)selectedMethod.getCode();
                if (field.isStatic()) {
                    if (staticFieldHelper != null) {
                        target = staticFieldHelper;
                    }
                    mce = GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)INVOKERHELPER_CLASSNODE), (String)"invokeStaticMethod", (Expression)GeneralUtils.args((Expression[])new Expression[]{thisObject, GeneralUtils.constX((Object)Traits.helperSetterName(field)), initCode.getExpression()}));
                } else {
                    mce = GeneralUtils.callX((Expression)GeneralUtils.castX((ClassNode)TraitASTTransformation.createReceiverType(field.isStatic(), fieldHelper), (Expression)thisObject), (String)Traits.helperSetterName(field), (Expression)GeneralUtils.castX((ClassNode)field.getOriginType(), (Expression)initCode.getExpression()));
                }
                mce.setImplicitThis(false);
                mce.setSourcePosition((ASTNode)initialExpression);
                code.addStatement(GeneralUtils.stmt((Expression)mce));
            }
        }
        ClassNodeUtils.addGeneratedMethod((ClassNode)target, (String)Traits.helperSetterName(field), (int)1025, (ClassNode)field.getOriginType(), (Parameter[])new Parameter[]{new Parameter(field.getOriginType(), "val")}, (ClassNode[])ClassNode.EMPTY_ARRAY, null);
        ClassNodeUtils.addGeneratedMethod((ClassNode)target, (String)Traits.helperGetterName(field), (int)1025, (ClassNode)field.getOriginType(), (Parameter[])Parameter.EMPTY_ARRAY, (ClassNode[])ClassNode.EMPTY_ARRAY, null);
        int mods = field.getModifiers() & 0x9B;
        String dummyFieldName = String.valueOf(String.format("$0x%04x", mods)) + Traits.remappedFieldName(field.getOwner(), field.getName());
        FieldNode dummyField = new FieldNode(dummyFieldName, 4121, field.getOriginType(), fieldHelper, null);
        LinkedList copied = new LinkedList();
        LinkedList notCopied = new LinkedList();
        GeneralUtils.copyAnnotatedNodeAnnotations((AnnotatedNode)field, copied, notCopied);
        dummyField.addAnnotations(copied);
        fieldHelper.addField(dummyField);
        dummyFieldName = String.valueOf(field.isStatic() ? "$static" : "$ins") + (field.isPublic() ? "$0" : "$1") + Traits.remappedFieldName(field.getOwner(), field.getName());
        dummyField = new FieldNode(dummyFieldName, 4121, field.getOriginType().getPlainNodeReference(), fieldHelper, null);
        copied = new LinkedList();
        notCopied = new LinkedList();
        GeneralUtils.copyAnnotatedNodeAnnotations((AnnotatedNode)field, copied, notCopied);
        dummyField.addAnnotations(copied);
        fieldHelper.addField(dummyField);
    }

    private MethodNode processMethod(ClassNode traitClass, ClassNode traitHelperClass, MethodNode methodNode, ClassNode fieldHelper, Collection<String> knownFields) {
        Parameter[] initialParams = methodNode.getParameters();
        Parameter[] newParams = new Parameter[initialParams.length + 1];
        newParams[0] = TraitASTTransformation.createSelfParameter(traitClass, methodNode.isStatic());
        System.arraycopy(initialParams, 0, newParams, 1, initialParams.length);
        int mod = methodNode.isPrivate() ? 2 : 1 | (methodNode.isFinal() ? 16 : 0);
        MethodNode mNode = new MethodNode(methodNode.getName(), mod | 8, methodNode.getReturnType(), newParams, methodNode.getExceptions(), this.processBody(GeneralUtils.varX((Variable)newParams[0]), methodNode.getCode(), traitClass, traitHelperClass, fieldHelper, knownFields));
        mNode.setSourcePosition(methodNode);
        mNode.addAnnotations(TraitASTTransformation.filterAnnotations(methodNode.getAnnotations()));
        mNode.setGenericsTypes(methodNode.getGenericsTypes());
        if (methodNode.isAbstract()) {
            mNode.setModifiers(1025);
        } else {
            methodNode.addAnnotation(new AnnotationNode(Traits.IMPLEMENTED_CLASSNODE));
        }
        if (!methodNode.isPrivate() && !methodNode.isStatic()) {
            methodNode.setModifiers(1025);
        }
        return mNode;
    }

    private static List<AnnotationNode> filterAnnotations(List<AnnotationNode> annotations) {
        ArrayList<AnnotationNode> result = new ArrayList<AnnotationNode>(annotations.size());
        for (AnnotationNode annotation : annotations) {
            if (OVERRIDE_CLASSNODE.equals(annotation.getClassNode())) continue;
            result.add(annotation);
        }
        return result;
    }

    private static Parameter createSelfParameter(ClassNode traitClass, boolean isStatic) {
        ClassNode rawType = traitClass.getPlainNodeReference();
        ClassNode type = TraitASTTransformation.createReceiverType(isStatic, rawType);
        return new Parameter(type, isStatic ? "$static$self" : "$self");
    }

    private static ClassNode createReceiverType(boolean isStatic, ClassNode rawType) {
        ClassNode type = isStatic ? GenericsUtils.makeClassSafe0(ClassHelper.CLASS_Type, new GenericsType(rawType)) : rawType;
        return type;
    }

    private Statement processBody(VariableExpression thisObject, Statement code, ClassNode trait, ClassNode traitHelper, ClassNode fieldHelper, Collection<String> knownFields) {
        if (code == null) {
            return null;
        }
        NAryOperationRewriter operationRewriter = new NAryOperationRewriter(this.sourceUnit, knownFields);
        code.visit((GroovyCodeVisitor)operationRewriter);
        SuperCallTraitTransformer superTrn = new SuperCallTraitTransformer(this.sourceUnit);
        code.visit((GroovyCodeVisitor)((Object)superTrn));
        TraitReceiverTransformer trn = new TraitReceiverTransformer(thisObject, this.sourceUnit, trait, traitHelper, fieldHelper, knownFields);
        code.visit((GroovyCodeVisitor)((Object)trn));
        return code;
    }

    private static class DefaultArgsMethodsAdder
    extends Verifier {
        private DefaultArgsMethodsAdder() {
        }

        @Override
        public void addDefaultParameterMethods(ClassNode node) {
            this.setClassNode(node);
            super.addDefaultParameterMethods(node);
        }
    }

    private static class PostTypeCheckingExpressionReplacer
    extends ClassCodeExpressionTransformer {
        private final SourceUnit sourceUnit;

        PostTypeCheckingExpressionReplacer(SourceUnit sourceUnit) {
            this.sourceUnit = sourceUnit;
        }

        protected SourceUnit getSourceUnit() {
            return this.sourceUnit;
        }

        public Expression transform(Expression exp) {
            Expression replacement;
            if (exp != null && (replacement = (Expression)exp.getNodeMetaData((Object)POST_TYPECHECKING_REPLACEMENT)) != null) {
                return replacement;
            }
            return super.transform(exp);
        }
    }
}

