/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import com.kms.katalon.logging.SystemStreams;
import java.io.PrintStream;
import org.eclipse.e4.core.services.log.Logger;

public class EclipseE4LogAppender
extends AppenderBase<ILoggingEvent> {
    private Logger eclipseLogger;
    private PatternLayout patternLayout;
    private String pattern = "%logger{36} - %msg";

    public void setEclipseLogger(Logger eclipseLogger) {
        this.eclipseLogger = eclipseLogger;
    }

    public void start() {
        LoggerContext context = (LoggerContext)this.getContext();
        this.patternLayout = new PatternLayout();
        this.patternLayout.setPattern(this.pattern);
        this.patternLayout.setContext((Context)context);
        this.patternLayout.start();
        super.start();
    }

    protected void append(ILoggingEvent event) {
        if (this.eclipseLogger == null) {
            return;
        }
        Object message = this.patternLayout.doLayout(event);
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy != null) {
            message = (String)message + System.lineSeparator() + ThrowableProxyUtil.asString((IThrowableProxy)throwableProxy);
        }
        switch (event.getLevel().levelInt) {
            case 40000: {
                PrintStream previousStderr = System.err;
                SystemStreams.getInstance().setSystemErrToOriginal();
                this.eclipseLogger.error((String)message);
                SystemStreams.getInstance().setSystemErrTo(previousStderr);
                break;
            }
            case 30000: {
                this.eclipseLogger.warn((String)message);
                break;
            }
            case 20000: {
                this.eclipseLogger.info((String)message);
                break;
            }
            default: {
                this.eclipseLogger.debug((String)message);
            }
        }
    }
}

