/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.logging;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class SystemStreams {
    private static final SystemStreams singleton = new SystemStreams();
    private PrintStream originalErr;
    private PrintStream nullErr;

    public static SystemStreams getInstance() {
        return singleton;
    }

    private SystemStreams() {
        this.recaptureOriginals();
        this.nullErr = new PrintStream(OutputStream.nullOutputStream());
    }

    public synchronized void recaptureOriginals() {
        PrintStream utf8WrappedErr;
        try {
            utf8WrappedErr = new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            utf8WrappedErr = new PrintStream(System.err, true);
        }
        this.originalErr = utf8WrappedErr;
    }

    public void setSystemErrToNull() {
        System.setErr(this.nullErr);
    }

    public void setSystemErrToOriginal() {
        System.setErr(this.originalErr);
    }

    public void setSystemErrTo(PrintStream err) {
        System.setErr(err);
    }

    private static class DebuggablePrintStream
    extends PrintStream {
        private final PrintStream original;

        public DebuggablePrintStream(PrintStream original) {
            super(new ByteArrayOutputStream());
            this.original = original;
        }

        @Override
        public void println(String msg) {
            this.printCaller(msg);
            this.original.println(msg);
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            String s = new String(buf, off, len);
            this.printCaller(s);
            this.original.write(buf, off, len);
        }

        private void printCaller(String msg) {
            if (msg.contains("SWT")) {
                Exception callLocation = new Exception("Debug who called this write(...): ");
                StackTraceElement[] stackTraceElementArray = callLocation.getStackTrace();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement ste = stackTraceElementArray[n2];
                    if (!ste.getClassName().contains("DebuggablePrintStream")) {
                        this.original.println("\tat " + String.valueOf(ste));
                    }
                    ++n2;
                }
            }
        }
    }
}

