/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.proposals.AbstractGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyFieldProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyMethodProposal;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class LocalVariableCompletionProcessor
extends AbstractGroovyCompletionProcessor {
    private final int offset;
    private final int replaceLength;

    public LocalVariableCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
        this.offset = context.completionLocation;
        this.replaceLength = context.completionExpression.length();
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        if (this.replaceLength < 1 && this.getContext().location == ContentAssistLocation.METHOD_CONTEXT) {
            return Collections.emptyList();
        }
        Map<String, ClassNode> localNames = this.findLocalNames(this.extractVariableNameStart());
        List<ICompletionProposal> proposals = this.createProposals(localNames);
        proposals.addAll(this.createClosureProposals());
        return proposals;
    }

    private List<ICompletionProposal> createClosureProposals() {
        ContentAssistContext context = this.getContext();
        if (context.currentScope != null && context.currentScope.getEnclosingClosure() != null) {
            ClassNode thisType = context.currentScope.getThis();
            ClassNode ownerType = context.currentScope.getOwner();
            ClassNode delegateType = context.currentScope.getDelegate();
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            this.maybeAddClosureProperty(proposals, "owner", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS_NODE, ownerType, false);
            this.maybeAddClosureProperty(proposals, "getOwner", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS_NODE, ownerType, true);
            this.maybeAddClosureProperty(proposals, "thisObject", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS_NODE, thisType, false);
            this.maybeAddClosureProperty(proposals, "getThisObject", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS_NODE, thisType, true);
            this.maybeAddClosureProperty(proposals, "delegate", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS_NODE, delegateType, false);
            this.maybeAddClosureProperty(proposals, "getDelegate", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS_NODE, delegateType, true);
            this.maybeAddClosureProperty(proposals, "directive", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS_NODE, ClassHelper.int_TYPE, false);
            this.maybeAddClosureProperty(proposals, "getDirective", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS_NODE, ClassHelper.int_TYPE, true);
            this.maybeAddClosureProperty(proposals, "resolveStrategy", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS_NODE, ClassHelper.int_TYPE, false);
            this.maybeAddClosureProperty(proposals, "getResolveStrategy", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS_NODE, ClassHelper.int_TYPE, true);
            this.maybeAddClosureProperty(proposals, "parameterTypes", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS_NODE, org.eclipse.jdt.groovy.search.VariableScope.CLASS_CLASS_NODE.makeArray(), false);
            this.maybeAddClosureProperty(proposals, "getParameterTypes", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS_NODE, org.eclipse.jdt.groovy.search.VariableScope.CLASS_CLASS_NODE.makeArray(), true);
            this.maybeAddClosureProperty(proposals, "maximumNumberOfParameters", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS_NODE, ClassHelper.int_TYPE, false);
            this.maybeAddClosureProperty(proposals, "getMaximumNumberOfParameters", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS_NODE, ClassHelper.int_TYPE, true);
            return proposals;
        }
        return Collections.emptyList();
    }

    private void maybeAddClosureProperty(List<ICompletionProposal> proposals, String name, ClassNode declaringType, ClassNode type, boolean isMethod) {
        if (ProposalUtils.looselyMatches(this.getContext().completionExpression, name)) {
            AbstractGroovyProposal proposal = isMethod ? this.createMethodProposal(name, declaringType, type) : this.createFieldProposal(name, declaringType, type);
            proposals.add((ICompletionProposal)proposal.createJavaProposal(this.getContext(), this.getJavaContext()));
        }
    }

    private GroovyFieldProposal createFieldProposal(String name, ClassNode declaring, ClassNode type) {
        FieldNode field = new FieldNode(name, 1, type, declaring, null);
        field.setDeclaringClass(declaring);
        return new GroovyFieldProposal(field);
    }

    private GroovyMethodProposal createMethodProposal(String name, ClassNode declaring, ClassNode returnType) {
        MethodNode method = new MethodNode(name, 1, returnType, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, null);
        method.setDeclaringClass(declaring);
        return new GroovyMethodProposal(method);
    }

    private String extractVariableNameStart() {
        String fullExpression = this.getContext().completionExpression;
        if (fullExpression.length() == 0) {
            return "";
        }
        int end = fullExpression.length() - 1;
        while (end >= 0 && Character.isJavaIdentifierPart(fullExpression.charAt(end))) {
            --end;
        }
        if (end >= 0) {
            return fullExpression.substring(++end);
        }
        return fullExpression;
    }

    private Map<String, ClassNode> findLocalNames(String prefix) {
        BlockStatement block = this.getContainingBlock(this.getContext().containingCodeBlock);
        if (block == null) {
            return Collections.emptyMap();
        }
        final HashMap<String, ClassNode> nameTypeMap = new HashMap<String, ClassNode>();
        VariableScope scope = block.getVariableScope();
        while (scope != null) {
            Iterator it = scope.getDeclaredVariablesIterator();
            while (it.hasNext()) {
                Variable var = (Variable)it.next();
                int end = Integer.MIN_VALUE;
                if (var instanceof Parameter) {
                    end = ((Parameter)var).getEnd();
                } else if (var instanceof VariableExpression) {
                    end = ((VariableExpression)var).getEnd();
                }
                if (end < 1 && var.getName().charAt(0) == '$' || end >= this.offset || !ProposalUtils.looselyMatches(prefix, var.getName())) continue;
                nameTypeMap.put(var.getName(), var.getOriginType() != null ? var.getOriginType() : var.getType());
            }
            scope = scope.getParent();
        }
        block.visit((GroovyCodeVisitor)new CodeVisitorSupport(){

            public void visitDeclarationExpression(DeclarationExpression expression) {
                if (expression.getStart() <= LocalVariableCompletionProcessor.this.offset && LocalVariableCompletionProcessor.this.offset <= expression.getEnd()) {
                    nameTypeMap.remove(expression.getVariableExpression().getName());
                }
                super.visitDeclarationExpression(expression);
            }
        });
        return nameTypeMap;
    }

    private BlockStatement getContainingBlock(ASTNode node) {
        if (node instanceof BlockStatement) {
            return (BlockStatement)node;
        }
        if (node instanceof ReturnStatement && this.getContext().containingDeclaration instanceof MethodNode) {
            return new BlockStatement(Collections.singletonList((ReturnStatement)node), ((MethodNode)this.getContext().containingDeclaration).getVariableScope());
        }
        if (node instanceof ClassNode && GroovyUtils.isScript((ClassNode)((ClassNode)node))) {
            for (MethodNode method : ((ClassNode)node).redirect().getMethods()) {
                if (!method.isScriptBody()) continue;
                return (BlockStatement)method.getCode();
            }
        }
        return null;
    }

    private List<ICompletionProposal> createProposals(Map<String, ClassNode> nameTypes) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (Map.Entry<String, ClassNode> nameType : nameTypes.entrySet()) {
            proposals.add(this.createProposal(nameType.getKey(), nameType.getValue()));
        }
        return proposals;
    }

    private ICompletionProposal createProposal(String replaceName, ClassNode type) {
        CompletionProposal proposal = CompletionProposal.create((int)5, (int)this.offset);
        proposal.setCompletion(replaceName.toCharArray());
        proposal.setReplaceRange(this.offset - this.replaceLength, this.getContext().completionEnd);
        proposal.setSignature(ProposalUtils.createTypeSignature(type));
        proposal.setRelevance(Relevance.HIGH.getRelevance());
        LazyJavaCompletionProposal javaProposal = new LazyJavaCompletionProposal(proposal, this.getJavaContext());
        javaProposal.setTriggerCharacters(ProposalUtils.VAR_TRIGGER);
        javaProposal.setRelevance(proposal.getRelevance());
        return javaProposal;
    }
}

