/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.common;

import com.ibm.wsdl.BindingOperationImpl;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.webservice.common.BasicRequestor;
import com.kms.katalon.core.webservice.definition.WebServiceDefinitionLoaderProvider;
import com.kms.katalon.core.webservice.definition.WebServiceDefinitionLoaderSupplier;
import com.kms.katalon.core.webservice.exception.WebServiceException;
import com.kms.katalon.core.webservice.helper.WsdlLocatorProvider;
import com.kms.katalon.core.webservice.wsdl.support.wsdl.WsdlDefinitionLocator;
import com.kms.katalon.core.webservice.wsdl.support.wsdl.WsdlParser;
import com.kms.katalon.util.UrlUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.stream.Collectors;
import javax.wsdl.WSDLException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;

public class SoapClient
extends BasicRequestor {
    private static final String SOAP_ACTION = "SOAPAction";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TEXT_XML_CHARSET_UTF_8 = "text/xml; charset=utf-8";
    private static final String APPLICATION_XML = "application/xml";
    private String serviceName;
    private String endpoint;
    private String actionUri;

    public SoapClient(String projectDir, ProxyInformation proxyInformation) {
        super(projectDir, proxyInformation);
    }

    @Override
    protected HttpUriRequest buildHttpRequest(RequestObject requestObject) throws Exception {
        this.populateCommonData(requestObject);
        HttpPost post = new HttpPost(this.endpoint);
        if (requestObject.useServiceInfoFromWsdl()) {
            post.addHeader(CONTENT_TYPE, TEXT_XML_CHARSET_UTF_8);
            if (StringUtils.isNotBlank((String)this.actionUri)) {
                post.addHeader(SOAP_ACTION, this.actionUri);
            }
        }
        this.setHttpConnectionHeaders((HttpRequest)post, requestObject);
        ByteArrayEntity entity = new ByteArrayEntity(requestObject.getSoapBody().getBytes(StandardCharsets.UTF_8));
        entity.setChunked(false);
        post.setEntity((HttpEntity)entity);
        return post;
    }

    private void populateCommonData(RequestObject requestObject) throws WebServiceException {
        if (requestObject.useServiceInfoFromWsdl()) {
            this.populateDataFromWsdl(requestObject);
        } else {
            this.endpoint = requestObject.getSoapServiceEndpoint();
        }
        if (StringUtils.isBlank((String)this.endpoint)) {
            throw new WebServiceException("Service endpoint is undefined.");
        }
    }

    private void populateDataFromWsdl(RequestObject requestObject) throws WebServiceException {
        try {
            WsdlParser parser = this.getWsdlParser(requestObject);
            String requestMethod = requestObject.getSoapRequestMethod();
            this.endpoint = parser.getPortAddressLocation(requestMethod);
            BindingOperationImpl bindingOperation = parser.getBindingOperationByRequestMethodAndName(requestMethod, requestObject.getSoapServiceFunction());
            this.actionUri = parser.getOperationURI(bindingOperation, requestMethod);
        }
        catch (IOException | GeneralSecurityException | WSDLException e) {
            throw new WebServiceException((Exception)e);
        }
    }

    private WsdlParser getWsdlParser(RequestObject requestObject) throws IOException, GeneralSecurityException {
        String wsdlLocation = requestObject.getWsdlAddress();
        WebServiceDefinitionLoaderSupplier loaderSupplier = UrlUtil.isWebUrl((String)wsdlLocation) ? location -> WebServiceDefinitionLoaderProvider.getLoaderForWebLocation(location, this.getHttpHeaderMap(requestObject), this.proxyInformation, this.getSslCertificateOption(), this.getSSLSettings()) : location -> WebServiceDefinitionLoaderProvider.getLoader(wsdlLocation);
        WsdlDefinitionLocator wsdlLocator = WsdlLocatorProvider.getLocator(wsdlLocation, loaderSupplier);
        return new WsdlParser(wsdlLocator);
    }

    private Map<String, String> getHttpHeaderMap(RequestObject requestObject) throws GeneralSecurityException, IOException {
        Map<String, String> headers = this.getRequestHeaders(requestObject).stream().collect(Collectors.toMap(h -> h.getName(), h -> h.getValue()));
        return headers;
    }

    @Override
    protected String getResponseContentType(HttpResponse httpResponse) {
        return APPLICATION_XML;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

