/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.setting;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.core.model.SSLClientCertificateSettings;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webservice.common.WebServiceMethod;
import com.kms.katalon.core.webservice.helper.RestRequestMethodHelper;
import com.kms.katalon.core.webservice.setting.SSLCertificateOption;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class WebServiceSettingStore
extends BundleSettingStore {
    private static final String SETTINGS_WEBSERVICE_METHODS = "webServiceMethods";

    private WebServiceSettingStore(String projectDir) {
        super(projectDir, "com.kms.katalon.core.webservice", false);
    }

    public static WebServiceSettingStore create(String projectDir) {
        return new WebServiceSettingStore(projectDir);
    }

    public SSLCertificateOption getSSLCertificateOption() throws IOException {
        return SSLCertificateOption.valueOf(this.getString("network.sslCert", SSLCertificateOption.BYPASS.name()));
    }

    public void saveSSLCertificateOption(SSLCertificateOption option) throws IOException {
        this.setProperty("network.sslCert", option.name());
    }

    public SSLClientCertificateSettings getClientCertificateSettings() throws IOException {
        String storedValue = this.getString("network.sslClientCert", "");
        if (!StringUtils.isBlank((CharSequence)storedValue)) {
            return (SSLClientCertificateSettings)JsonUtil.fromJson((String)storedValue, SSLClientCertificateSettings.class);
        }
        SSLClientCertificateSettings defaultSettings = new SSLClientCertificateSettings();
        defaultSettings.setKeyStoreFile("");
        defaultSettings.setKeyStorePassword("");
        return defaultSettings;
    }

    public void saveClientCerfiticateSettings(SSLClientCertificateSettings settings) throws IOException {
        String storedValue = JsonUtil.toJson((Object)settings);
        this.setProperty("network.sslClientCert", storedValue);
    }

    public List<WebServiceMethod> getWebServiceMethods() throws IOException {
        String storedValue = this.getString(SETTINGS_WEBSERVICE_METHODS, "");
        List<WebServiceMethod> methods = !StringUtils.isBlank((CharSequence)storedValue) ? this.parseWebServiceMethods(storedValue) : this.getDefaultWebServiceMethods();
        return methods;
    }

    public List<WebServiceMethod> getDefaultWebServiceMethods() {
        String[] builtInMethods = RestRequestMethodHelper.getBuiltInMethods();
        ArrayList<WebServiceMethod> defaultMethods = new ArrayList<WebServiceMethod>();
        String[] stringArray = builtInMethods;
        int n = builtInMethods.length;
        int n2 = 0;
        while (n2 < n) {
            String builtInMethod = stringArray[n2];
            WebServiceMethod method = new WebServiceMethod();
            method.setName(builtInMethod);
            method.setType("Standard");
            method.setDescription("");
            defaultMethods.add(method);
            ++n2;
        }
        return defaultMethods;
    }

    public void saveWebServiceMethods(List<WebServiceMethod> methods) throws IOException {
        String methodListJson = this.toMethodListJson(methods);
        this.setProperty(SETTINGS_WEBSERVICE_METHODS, methodListJson);
    }

    private List<WebServiceMethod> parseWebServiceMethods(String methodListJson) {
        Type listType = new TypeToken<List<WebServiceMethod>>(){}.getType();
        List methods = (List)JsonUtil.fromJson((String)methodListJson, (Type)listType);
        return methods;
    }

    private String toMethodListJson(List<WebServiceMethod> methods) {
        return JsonUtil.toJson(methods);
    }
}

