/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.PointerPointer;
import com.googlecode.javacv.FrameGrabber;
import com.googlecode.javacv.cpp.avcodec;
import com.googlecode.javacv.cpp.avdevice;
import com.googlecode.javacv.cpp.avformat;
import com.googlecode.javacv.cpp.avutil;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.swscale;
import java.io.File;

public class FFmpegFrameGrabber
extends FrameGrabber {
    private static FrameGrabber.Exception loadingException = null;
    private String filename;
    private avformat.AVFormatContext pFormatCtx;
    private int videoStream;
    private avformat.AVStream pStream;
    private avcodec.AVCodecContext pCodecCtx;
    private avcodec.AVCodec pCodec;
    private avcodec.AVFrame pFrame;
    private avcodec.AVFrame pFrameRGB;
    private int numBytes;
    private BytePointer buffer;
    private swscale.SwsContext img_convert_ctx;
    private avcodec.AVPacket packet;
    private int[] frameFinished;
    private opencv_core.IplImage return_image;
    private boolean frameGrabbed;
    private long faulty_pts;
    private long faulty_dts;
    private long last_dts_for_fault_detection;
    private long last_pts_for_fault_detection;

    public static void tryLoad() throws FrameGrabber.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(avutil.class);
            Loader.load(avcodec.class);
            Loader.load(avformat.class);
            Loader.load(avdevice.class);
            Loader.load(swscale.class);
        }
        catch (Throwable t) {
            if (t instanceof FrameGrabber.Exception) {
                loadingException = (FrameGrabber.Exception)t;
                throw loadingException;
            }
            loadingException = new FrameGrabber.Exception("Failed to load " + FFmpegFrameGrabber.class, t);
            throw loadingException;
        }
    }

    public FFmpegFrameGrabber(File file) {
        this(file.getAbsolutePath());
    }

    public FFmpegFrameGrabber(String filename) {
        avcodec.avcodec_init();
        avcodec.avcodec_register_all();
        avdevice.avdevice_register_all();
        avformat.av_register_all();
        this.filename = filename;
    }

    public void release() throws FrameGrabber.Exception {
        this.stop();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    public double getGamma() {
        if (this.gamma == 0.0) {
            return 2.2;
        }
        return this.gamma;
    }

    public String getFormat() {
        if (this.pFormatCtx == null) {
            return super.getFormat();
        }
        return this.pFormatCtx.iformat().name().getString();
    }

    public int getImageWidth() {
        return this.return_image == null ? super.getImageWidth() : this.return_image.width();
    }

    public int getImageHeight() {
        return this.return_image == null ? super.getImageHeight() : this.return_image.height();
    }

    public int getPixelFormat() {
        if (this.imageMode == FrameGrabber.ImageMode.COLOR || this.imageMode == FrameGrabber.ImageMode.GRAY) {
            if (this.pixelFormat == -1) {
                return this.imageMode == FrameGrabber.ImageMode.COLOR ? 3 : 8;
            }
            return this.pixelFormat;
        }
        if (this.pCodecCtx != null) {
            return this.pCodecCtx.pix_fmt();
        }
        return super.getPixelFormat();
    }

    public double getFrameRate() {
        if (this.pStream == null) {
            return super.getFrameRate();
        }
        avutil.AVRational r = this.pStream.r_frame_rate();
        return (double)r.num() / (double)r.den();
    }

    public void setFrameNumber(int frameNumber) throws FrameGrabber.Exception {
        this.setTimestamp((long)((double)(1000000 * frameNumber) / this.getFrameRate()));
    }

    public void setTimestamp(long timestamp) throws FrameGrabber.Exception {
        if (this.pFormatCtx == null || this.pCodecCtx == null) {
            super.setTimestamp(timestamp);
        } else {
            timestamp = timestamp * 1000000L / 1000000L;
            if (this.pFormatCtx.start_time() != Long.MIN_VALUE) {
                timestamp += this.pFormatCtx.start_time();
            }
            if (avformat.avformat_seek_file(this.pFormatCtx, -1, Long.MIN_VALUE, timestamp, Long.MAX_VALUE, 1) < 0) {
                throw new FrameGrabber.Exception("Could not seek file to timestamp " + timestamp + ".");
            }
            avcodec.avcodec_flush_buffers(this.pCodecCtx);
            while (this.timestamp > timestamp && this.grab(false) != null) {
                this.last_pts_for_fault_detection = 0L;
                this.last_dts_for_fault_detection = 0L;
            }
            while (this.timestamp < timestamp && this.grab(false) != null) {
                this.last_pts_for_fault_detection = 0L;
                this.last_dts_for_fault_detection = 0L;
            }
            this.frameGrabbed = true;
        }
    }

    public int getLengthInFrames() {
        return (int)(1000000.0 * this.getFrameRate() / (double)this.getLengthInTime());
    }

    public long getLengthInTime() {
        return this.pFormatCtx.duration() * 1000000L / 1000000L;
    }

    public void start() throws FrameGrabber.Exception {
        this.pFormatCtx = new avformat.AVFormatContext(null);
        this.packet = new avcodec.AVPacket();
        this.frameFinished = new int[1];
        this.return_image = null;
        this.frameGrabbed = false;
        avformat.AVInputFormat f2 = null;
        if (this.format != null && this.format.length() > 0 && (f2 = avformat.av_find_input_format(this.format)) == null) {
            throw new FrameGrabber.Exception("Could not find input format \"" + this.format + "\".");
        }
        avformat.AVFormatParameters fp = null;
        if (this.frameRate > 0.0 || this.bpp > 0 || this.imageWidth > 0 || this.imageHeight > 0) {
            fp = new avformat.AVFormatParameters();
            fp.time_base(avutil.av_d2q(1.0 / this.frameRate, 1001000));
            fp.sample_rate(this.bpp);
            fp.channels(this.imageMode == FrameGrabber.ImageMode.COLOR ? 3 : 1);
            fp.width(this.imageWidth);
            fp.height(this.imageHeight);
        }
        if (avformat.av_open_input_file(this.pFormatCtx, this.filename, f2, 0, fp) != 0) {
            throw new FrameGrabber.Exception("Could not open file \"" + this.filename + "\".");
        }
        if (avformat.av_find_stream_info(this.pFormatCtx) < 0) {
            throw new FrameGrabber.Exception("Could not find stream information.");
        }
        avformat.dump_format(this.pFormatCtx, 0, this.filename, 0);
        this.videoStream = -1;
        int nb_streams = this.pFormatCtx.nb_streams();
        for (int i2 = 0; i2 < nb_streams; ++i2) {
            this.pStream = this.pFormatCtx.streams(i2);
            this.pCodecCtx = this.pStream.codec();
            if (this.pCodecCtx.codec_type() != 0) continue;
            this.videoStream = i2;
            break;
        }
        if (this.videoStream == -1) {
            throw new FrameGrabber.Exception("Did not find a video stream.");
        }
        this.pCodec = avcodec.avcodec_find_decoder(this.pCodecCtx.codec_id());
        if (this.pCodec == null) {
            throw new FrameGrabber.Exception("Unsupported codec or codec not found: " + this.pCodecCtx.codec_id() + ".");
        }
        if (avcodec.avcodec_open(this.pCodecCtx, this.pCodec) < 0) {
            throw new FrameGrabber.Exception("Could not open codec.");
        }
        this.pFrame = avcodec.avcodec_alloc_frame();
        this.pFrameRGB = avcodec.avcodec_alloc_frame();
        if (this.pFrame == null || this.pFrameRGB == null) {
            throw new FrameGrabber.Exception("Could not allocate frame.");
        }
        int width = this.getImageWidth() > 0 ? this.getImageWidth() : this.pCodecCtx.width();
        int height = this.getImageHeight() > 0 ? this.getImageHeight() : this.pCodecCtx.height();
        switch (this.imageMode) {
            case COLOR: 
            case GRAY: {
                int fmt = this.pixelFormat;
                if (fmt == -1) {
                    fmt = this.imageMode == FrameGrabber.ImageMode.COLOR ? 3 : 8;
                }
                this.numBytes = avcodec.avpicture_get_size(fmt, width, height);
                this.buffer = new BytePointer(avutil.av_malloc(this.numBytes));
                avcodec.avpicture_fill(this.pFrameRGB, this.buffer, fmt, width, height);
                this.img_convert_ctx = swscale.sws_getContext(this.pCodecCtx.width(), this.pCodecCtx.height(), this.pCodecCtx.pix_fmt(), width, height, fmt, 2, null, null, null);
                if (this.img_convert_ctx == null) {
                    throw new FrameGrabber.Exception("Cannot initialize the conversion context.");
                }
                this.return_image = opencv_core.IplImage.createHeader(width, height, 8, 1);
                break;
            }
            case RAW: {
                this.numBytes = 0;
                this.buffer = null;
                this.img_convert_ctx = null;
                this.return_image = opencv_core.IplImage.createHeader(this.pCodecCtx.width(), this.pCodecCtx.height(), 8, 1);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.last_pts_for_fault_detection = 0L;
        this.last_dts_for_fault_detection = 0L;
        this.faulty_dts = 0L;
        this.faulty_pts = 0L;
    }

    public void stop() throws FrameGrabber.Exception {
        if (this.buffer != null) {
            avutil.av_free(this.buffer);
            this.buffer = null;
        }
        if (this.pFrameRGB != null) {
            avutil.av_free(this.pFrameRGB);
            this.pFrameRGB = null;
        }
        if (this.pFrame != null) {
            avutil.av_free(this.pFrame);
            this.pFrame = null;
        }
        if (this.pCodecCtx != null) {
            avcodec.avcodec_close(this.pCodecCtx);
            this.pCodecCtx = null;
        }
        if (this.pFormatCtx != null && !this.pFormatCtx.isNull()) {
            avformat.av_close_input_file(this.pFormatCtx);
            this.pFormatCtx = null;
        }
        if (this.img_convert_ctx != null && !this.img_convert_ctx.isNull()) {
            swscale.sws_freeContext(this.img_convert_ctx);
            this.img_convert_ctx = null;
        }
        this.packet = null;
        this.frameFinished = null;
        this.return_image = null;
        this.frameGrabbed = false;
        this.timestamp = 0L;
        this.frameNumber = 0;
    }

    public void trigger() throws FrameGrabber.Exception {
        if (this.pFormatCtx == null || this.pFormatCtx.isNull()) {
            throw new FrameGrabber.Exception("Could not trigger: No AVFormatContext. (Has start() been called?)");
        }
        for (int i2 = 0; i2 < this.numBuffers + 1; ++i2) {
            if (avformat.av_read_frame(this.pFormatCtx, this.packet) < 0) {
                return;
            }
            avcodec.av_free_packet(this.packet);
        }
    }

    private void process() {
        switch (this.imageMode) {
            case COLOR: 
            case GRAY: {
                if (this.deinterlace) {
                    avcodec.avpicture_deinterlace(this.pFrame, this.pFrame, this.pCodecCtx.pix_fmt(), this.pCodecCtx.width(), this.pCodecCtx.height());
                }
                swscale.sws_scale(this.img_convert_ctx, new PointerPointer((Pointer)this.pFrame), this.pFrame.linesize(), 0, this.pCodecCtx.height(), new PointerPointer((Pointer)this.pFrameRGB), this.pFrameRGB.linesize());
                this.return_image.imageData(this.buffer);
                this.return_image.widthStep(this.pFrameRGB.linesize(0));
                break;
            }
            case RAW: {
                assert (this.pCodecCtx.width() == this.return_image.width() && this.pCodecCtx.height() == this.return_image.height());
                this.return_image.imageData(this.pFrame.data(0));
                this.return_image.widthStep(this.pFrame.linesize(0));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.return_image.imageSize(this.return_image.height() * this.return_image.widthStep());
        this.return_image.nChannels(this.return_image.widthStep() / this.return_image.width());
    }

    public opencv_core.IplImage grab() throws FrameGrabber.Exception {
        return this.grab(true);
    }

    public opencv_core.IplImage grab(boolean process) throws FrameGrabber.Exception {
        if (this.frameGrabbed) {
            this.frameGrabbed = false;
            if (process) {
                this.process();
            }
            return this.return_image;
        }
        if (this.pFormatCtx == null || this.pFormatCtx.isNull()) {
            throw new FrameGrabber.Exception("Could not grab: No AVFormatContext. (Has start() been called?)");
        }
        boolean done = false;
        long pts = 0L;
        while (!done) {
            if (avformat.av_read_frame(this.pFormatCtx, this.packet) < 0) {
                return null;
            }
            if (this.packet.stream_index() == this.videoStream) {
                this.pCodecCtx.reordered_opaque(this.packet.pts());
                int len = avcodec.avcodec_decode_video2(this.pCodecCtx, this.pFrame, this.frameFinished, this.packet);
                long reordered_opaque = this.pFrame.reordered_opaque();
                long dts = this.packet.dts();
                if (this.frameFinished[0] != 0) {
                    if (dts != Long.MIN_VALUE) {
                        this.faulty_dts += dts <= this.last_dts_for_fault_detection ? 1L : 0L;
                        this.last_dts_for_fault_detection = dts;
                    }
                    if (reordered_opaque != Long.MIN_VALUE) {
                        this.faulty_pts += reordered_opaque <= this.last_pts_for_fault_detection ? 1L : 0L;
                        this.last_pts_for_fault_detection = reordered_opaque;
                    }
                    if (len > 0 && process) {
                        this.process();
                    }
                    done = true;
                }
                pts = (this.faulty_pts < this.faulty_dts || dts == Long.MIN_VALUE) && reordered_opaque != Long.MIN_VALUE ? reordered_opaque : (dts != Long.MIN_VALUE ? dts : 0L);
            }
            avcodec.av_free_packet(this.packet);
        }
        avutil.AVRational time_base = this.pStream.time_base();
        this.timestamp = 1000000L * pts * (long)time_base.num() / (long)time_base.den();
        this.frameNumber = (int)(1000000.0 * this.getFrameRate() / (double)this.timestamp);
        return this.return_image;
    }
}

