/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacv.FrameGrabber;
import com.googlecode.javacv.cpp.PGRFlyCapture;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class FlyCaptureFrameGrabber
extends FrameGrabber {
    private static FrameGrabber.Exception loadingException = null;
    public static final int INITIALIZE = 0;
    public static final int TRIGGER_INQ = 1328;
    public static final int IS_CAMERA_POWER = 1024;
    public static final int CAMERA_POWER = 1552;
    public static final int SOFTWARE_TRIGGER = 1580;
    public static final int SOFT_ASYNC_TRIGGER = 4140;
    public static final int IMAGE_DATA_FORMAT = 4168;
    private PGRFlyCapture.FlyCaptureContext context = new PGRFlyCapture.FlyCaptureContext(null);
    private PGRFlyCapture.FlyCaptureImage raw_image = new PGRFlyCapture.FlyCaptureImage();
    private PGRFlyCapture.FlyCaptureImage conv_image = new PGRFlyCapture.FlyCaptureImage();
    private opencv_core.IplImage temp_image;
    private opencv_core.IplImage return_image = null;
    private int[] regOut = new int[1];
    private float[] outFloat = new float[1];
    private float[] gammaOut = new float[1];

    public static String[] getDeviceDescriptions() throws FrameGrabber.Exception {
        FlyCaptureFrameGrabber.tryLoad();
        int[] count = new int[1];
        int error = PGRFlyCapture.flycaptureBusCameraCount(count);
        if (error != 0) {
            throw new FrameGrabber.Exception("flycaptureBusCameraCount() Error " + error);
        }
        int c2 = count[0];
        String[] descriptions = new String[c2];
        if (c2 > 0) {
            PGRFlyCapture.FlyCaptureInfoEx info = new PGRFlyCapture.FlyCaptureInfoEx(c2);
            error = PGRFlyCapture.flycaptureBusEnumerateCamerasEx(info, count);
            if (error != 0) {
                throw new FrameGrabber.Exception("flycaptureBusEnumerateCamerasEx() Error " + error);
            }
            for (int i2 = 0; i2 < descriptions.length; ++i2) {
                info.position(i2);
                descriptions[i2] = info.pszVendorName() + " " + info.pszModelName() + " " + info.SerialNumber();
            }
        }
        return descriptions;
    }

    public static void tryLoad() throws FrameGrabber.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(PGRFlyCapture.class);
        }
        catch (Throwable t) {
            loadingException = new FrameGrabber.Exception("Failed to load " + FlyCaptureFrameGrabber.class, t);
            throw loadingException;
        }
    }

    public FlyCaptureFrameGrabber(int deviceNumber) throws FrameGrabber.Exception {
        int error = PGRFlyCapture.flycaptureCreateContext(this.context);
        if (error != 0) {
            throw new FrameGrabber.Exception("flycaptureCreateContext() Error " + error);
        }
        error = PGRFlyCapture.flycaptureInitializePlus(this.context, deviceNumber, this.numBuffers, null);
        if (error != 0) {
            throw new FrameGrabber.Exception("flycaptureInitialize() Error " + error);
        }
    }

    public void release() throws FrameGrabber.Exception {
        if (this.context != null) {
            this.stop();
            int error = PGRFlyCapture.flycaptureDestroyContext(this.context);
            this.context = null;
            if (error != 0) {
                throw new FrameGrabber.Exception("flycaptureDestroyContext() Error " + error);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    public double getGamma() {
        return this.gammaOut[0];
    }

    public int getImageWidth() {
        return this.return_image == null ? super.getImageWidth() : this.return_image.width();
    }

    public int getImageHeight() {
        return this.return_image == null ? super.getImageHeight() : this.return_image.height();
    }

    public double getFrameRate() {
        if (this.context == null || this.context.isNull()) {
            return super.getFrameRate();
        }
        PGRFlyCapture.flycaptureGetCameraAbsProperty(this.context, 15, this.outFloat);
        return this.outFloat[0];
    }

    public void setImageMode(FrameGrabber.ImageMode imageMode) {
        if (imageMode != this.imageMode) {
            this.temp_image = null;
            this.return_image = null;
        }
        super.setImageMode(imageMode);
    }

    public void start() throws FrameGrabber.Exception {
        int f2 = 11;
        if (this.frameRate <= 0.0) {
            f2 = 11;
        } else if (this.frameRate <= 1.876) {
            f2 = 0;
        } else if (this.frameRate <= 3.76) {
            f2 = 1;
        } else if (this.frameRate <= 7.51) {
            f2 = 2;
        } else if (this.frameRate <= 15.01) {
            f2 = 3;
        } else if (this.frameRate <= 30.01) {
            f2 = 4;
        } else if (this.frameRate <= 60.01) {
            f2 = 6;
        } else if (this.frameRate <= 120.01) {
            f2 = 7;
        } else if (this.frameRate <= 240.01) {
            f2 = 8;
        }
        int c2 = 16;
        if (this.imageMode == FrameGrabber.ImageMode.COLOR || this.imageMode == FrameGrabber.ImageMode.RAW) {
            if (this.imageWidth <= 0 || this.imageHeight <= 0) {
                c2 = 16;
            } else if (this.imageWidth <= 640 && this.imageHeight <= 480) {
                c2 = 4;
            } else if (this.imageWidth <= 800 && this.imageHeight <= 600) {
                c2 = 18;
            } else if (this.imageWidth <= 1024 && this.imageHeight <= 768) {
                c2 = 21;
            } else if (this.imageWidth <= 1280 && this.imageHeight <= 960) {
                c2 = 23;
            } else if (this.imageWidth <= 1600 && this.imageHeight <= 1200) {
                c2 = 51;
            }
        } else if (this.imageMode == FrameGrabber.ImageMode.GRAY) {
            if (this.imageWidth <= 0 || this.imageHeight <= 0) {
                c2 = 16;
            } else if (this.imageWidth <= 640 && this.imageHeight <= 480) {
                c2 = this.bpp > 8 ? 6 : 5;
            } else if (this.imageWidth <= 800 && this.imageHeight <= 600) {
                c2 = this.bpp > 8 ? 19 : 7;
            } else if (this.imageWidth <= 1024 && this.imageHeight <= 768) {
                c2 = this.bpp > 8 ? 9 : 8;
            } else if (this.imageWidth <= 1280 && this.imageHeight <= 960) {
                c2 = this.bpp > 8 ? 24 : 10;
            } else if (this.imageWidth <= 1600 && this.imageHeight <= 1200) {
                c2 = this.bpp > 8 ? 52 : 11;
            }
        }
        int[] iPolarity = new int[1];
        int[] iSource = new int[1];
        int[] iRawValue = new int[1];
        int[] iMode = new int[1];
        int error = PGRFlyCapture.flycaptureGetTrigger(this.context, null, iPolarity, iSource, iRawValue, iMode, null);
        if (error != 0) {
            throw new FrameGrabber.Exception("flycaptureGetTrigger() Error " + error);
        }
        error = PGRFlyCapture.flycaptureSetTrigger(this.context, this.triggerMode, iPolarity[0], 7, 14, 0);
        if (error != 0) {
            error = PGRFlyCapture.flycaptureSetTrigger(this.context, true, iPolarity[0], 7, 0, 0);
        }
        if (error != 0) {
            throw new FrameGrabber.Exception("flycaptureSetTrigger() Error " + error);
        }
        if (this.triggerMode) {
            this.waitForTriggerReady();
        }
        if ((error = PGRFlyCapture.flycaptureGetCameraRegister(this.context, 4168, this.regOut)) != 0) {
            throw new FrameGrabber.Exception("flycaptureGetCameraRegister() Error " + error);
        }
        int reg = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? this.regOut[0] | 1 : this.regOut[0] & 0xFFFFFFFE;
        error = PGRFlyCapture.flycaptureSetCameraRegister(this.context, 4168, reg);
        if (error != 0) {
            throw new FrameGrabber.Exception("flycaptureSetCameraRegister() Error " + error);
        }
        error = PGRFlyCapture.flycaptureSetBusSpeed(this.context, 7, 7);
        if (error != 0 && (error = PGRFlyCapture.flycaptureSetBusSpeed(this.context, 8, 8)) != 0) {
            throw new FrameGrabber.Exception("flycaptureSetBusSpeed() Error " + error);
        }
        if (this.gamma != 0.0 && (error = PGRFlyCapture.flycaptureSetCameraAbsProperty(this.context, 6, (float)this.gamma)) != 0) {
            throw new FrameGrabber.Exception("flycaptureSetCameraAbsProperty() Error " + error + ": Could not set gamma.");
        }
        error = PGRFlyCapture.flycaptureGetCameraAbsProperty(this.context, 6, this.gammaOut);
        if (error != 0) {
            this.gammaOut[0] = 2.2f;
        }
        if ((error = PGRFlyCapture.flycaptureStart(this.context, c2, f2)) != 0) {
            throw new FrameGrabber.Exception("flycaptureStart() Error " + error);
        }
        error = PGRFlyCapture.flycaptureSetGrabTimeoutEx(this.context, this.timeout);
        if (error != 0) {
            throw new FrameGrabber.Exception("flycaptureSetGrabTimeoutEx() Error " + error);
        }
    }

    private void waitForTriggerReady() throws FrameGrabber.Exception {
        long time = System.currentTimeMillis();
        do {
            int error;
            if ((error = PGRFlyCapture.flycaptureGetCameraRegister(this.context, 1580, this.regOut)) == 0) continue;
            throw new FrameGrabber.Exception("flycaptureGetCameraRegister() Error " + error);
        } while (System.currentTimeMillis() - time <= (long)this.timeout && this.regOut[0] >>> 31 != 0);
    }

    public void stop() throws FrameGrabber.Exception {
        int error = PGRFlyCapture.flycaptureStop(this.context);
        if (error != 0 && error != 1) {
            throw new FrameGrabber.Exception("flycaptureStop() Error " + error);
        }
        this.temp_image = null;
        this.return_image = null;
        this.timestamp = 0L;
        this.frameNumber = 0;
    }

    public void trigger() throws FrameGrabber.Exception {
        this.waitForTriggerReady();
        int error = PGRFlyCapture.flycaptureSetCameraRegister(this.context, 4140, Integer.MIN_VALUE);
        if (error != 0) {
            throw new FrameGrabber.Exception("flycaptureSetCameraRegister() Error " + error);
        }
    }

    private int getNumChannels(int pixelFormat) {
        switch (pixelFormat) {
            case 16: 
            case 64: 
            case 256: 
            case 0x10000001: {
                return 3;
            }
            case 1: 
            case 32: 
            case 128: 
            case 512: 
            case 1024: {
                return 1;
            }
            case 0x10000002: {
                return 4;
            }
        }
        return -1;
    }

    private int getDepth(int pixelFormat) {
        switch (pixelFormat) {
            case 1: 
            case 16: 
            case 512: 
            case 0x10000001: 
            case 0x10000002: {
                return 8;
            }
            case 32: 
            case 64: 
            case 1024: {
                return 16;
            }
            case 128: 
            case 256: {
                return -2147483632;
            }
        }
        return 8;
    }

    public opencv_core.IplImage grab() throws FrameGrabber.Exception {
        int error = PGRFlyCapture.flycaptureGrabImage2(this.context, this.raw_image);
        if (error != 0) {
            throw new FrameGrabber.Exception("flycaptureGrabImage2() Error " + error + " (Has start() been called?)");
        }
        int w = this.raw_image.iCols();
        int h2 = this.raw_image.iRows();
        int format = this.raw_image.pixelFormat();
        int depth = this.getDepth(format);
        int stride = this.raw_image.iRowInc();
        int size = h2 * stride;
        int numChannels = this.getNumChannels(format);
        error = PGRFlyCapture.flycaptureGetCameraRegister(this.context, 4168, this.regOut);
        if (error != 0) {
            throw new FrameGrabber.Exception("flycaptureGetCameraRegister() Error " + error);
        }
        ByteOrder frameEndian = (this.regOut[0] & 1) != 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        boolean alreadySwapped = false;
        boolean colorbayer = this.raw_image.bStippled();
        boolean colorrgb = format == 16 || format == 64 || format == 0x10000001 || format == 0x10000002;
        boolean coloryuv = format == 2 || format == 4 || format == 8;
        BytePointer imageData = this.raw_image.pData();
        if ((depth == 8 || frameEndian.equals(ByteOrder.nativeOrder())) && (this.imageMode == FrameGrabber.ImageMode.RAW || this.imageMode == FrameGrabber.ImageMode.COLOR && numChannels == 3 || this.imageMode == FrameGrabber.ImageMode.GRAY && numChannels == 1 && !colorbayer)) {
            if (this.return_image == null) {
                this.return_image = opencv_core.IplImage.createHeader(w, h2, depth, numChannels);
            }
            this.return_image.widthStep(stride);
            this.return_image.imageSize(size);
            this.return_image.imageData(imageData);
        } else {
            if (this.return_image == null) {
                this.return_image = opencv_core.IplImage.create(w, h2, depth, this.imageMode == FrameGrabber.ImageMode.COLOR ? 3 : 1);
            }
            if (this.temp_image == null) {
                this.temp_image = this.imageMode == FrameGrabber.ImageMode.COLOR && (numChannels > 1 || depth > 8) && !coloryuv && !colorbayer ? opencv_core.IplImage.create(w, h2, depth, numChannels) : (this.imageMode == FrameGrabber.ImageMode.GRAY && colorbayer ? opencv_core.IplImage.create(w, h2, depth, 3) : (this.imageMode == FrameGrabber.ImageMode.GRAY && colorrgb ? opencv_core.IplImage.createHeader(w, h2, depth, 3) : (this.imageMode == FrameGrabber.ImageMode.COLOR && numChannels == 1 && !coloryuv && !colorbayer ? opencv_core.IplImage.createHeader(w, h2, depth, 1) : this.return_image)));
            }
            this.conv_image.iRowInc(this.temp_image.widthStep());
            this.conv_image.pData(this.temp_image.imageData());
            if (depth == 8) {
                this.conv_image.pixelFormat(this.imageMode == FrameGrabber.ImageMode.RAW ? 512 : (this.temp_image.nChannels() == 1 ? 1 : 0x10000001));
            } else {
                this.conv_image.pixelFormat(this.imageMode == FrameGrabber.ImageMode.RAW ? 1024 : (this.temp_image.nChannels() == 1 ? 32 : 64));
            }
            if (depth != 8 && this.conv_image.pixelFormat() == format && this.conv_image.iRowInc() == stride) {
                ShortBuffer in = this.raw_image.getByteBuffer().order(frameEndian).asShortBuffer();
                ShortBuffer out = this.temp_image.getByteBuffer().order(ByteOrder.nativeOrder()).asShortBuffer();
                out.put(in);
                alreadySwapped = true;
            } else if (this.imageMode == FrameGrabber.ImageMode.GRAY && colorrgb || this.imageMode == FrameGrabber.ImageMode.COLOR && numChannels == 1 && !coloryuv && !colorbayer) {
                this.temp_image.widthStep(stride);
                this.temp_image.imageSize(size);
                this.temp_image.imageData(imageData);
            } else if (!colorrgb && (colorbayer || coloryuv || numChannels > 1) && (error = PGRFlyCapture.flycaptureConvertImage(this.context, this.raw_image, this.conv_image)) != 0) {
                throw new FrameGrabber.Exception("flycaptureConvertImage() Error " + error);
            }
            if (!alreadySwapped && depth != 8 && !frameEndian.equals(ByteOrder.nativeOrder())) {
                ByteBuffer bb = this.temp_image.getByteBuffer();
                ShortBuffer in = bb.order(frameEndian).asShortBuffer();
                ShortBuffer out = bb.order(ByteOrder.nativeOrder()).asShortBuffer();
                out.put(in);
            }
            if (this.imageMode == FrameGrabber.ImageMode.COLOR && numChannels == 1 && !coloryuv && !colorbayer) {
                opencv_imgproc.cvCvtColor(this.temp_image, this.return_image, 8);
            } else if (this.imageMode == FrameGrabber.ImageMode.GRAY && (colorbayer || colorrgb)) {
                opencv_imgproc.cvCvtColor(this.temp_image, this.return_image, 6);
            }
        }
        error = PGRFlyCapture.flycaptureGetColorTileFormat(this.context, this.regOut);
        if (error != 0) {
            this.sensorPattern = -1L;
        } else {
            switch (this.regOut[0]) {
                case 0: {
                    this.sensorPattern = 0x100000001L;
                    break;
                }
                case 1: {
                    this.sensorPattern = 0x100000000L;
                    break;
                }
                case 2: {
                    this.sensorPattern = 1L;
                    break;
                }
                case 3: {
                    this.sensorPattern = 0L;
                    break;
                }
                default: {
                    this.sensorPattern = -1L;
                }
            }
        }
        PGRFlyCapture.FlyCaptureTimestamp timeStamp = this.raw_image.timeStamp();
        this.timestamp = timeStamp.ulSeconds() * 1000000 + timeStamp.ulMicroSeconds();
        return this.return_image;
    }
}

