/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.ImageTransformer;
import com.googlecode.javacv.ProjectiveTransformer;
import com.googlecode.javacv.cpp.cvkernels;
import com.googlecode.javacv.cpp.opencv_core;
import java.util.Arrays;

public class ProjectiveColorTransformer
extends ProjectiveTransformer {
    protected static ThreadLocal<opencv_core.CvMat> X24x4 = opencv_core.CvMat.createThreadLocal(4, 4);
    protected static ThreadLocal<opencv_core.CvMat> temp3x1 = opencv_core.CvMat.createThreadLocal(3, 1);
    protected opencv_core.CvMat X = null;
    protected int numGains = 0;
    protected int numBiases = 0;
    protected opencv_core.CvMat[] X2 = null;

    public ProjectiveColorTransformer(opencv_core.CvMat K1, opencv_core.CvMat K2, opencv_core.CvMat R, opencv_core.CvMat t, opencv_core.CvMat n2, double[] referencePoints1, double[] referencePoints2, opencv_core.CvMat X, int numGains, int numBiases) {
        super(K1, K2, R, t, n2, referencePoints1, referencePoints2);
        this.X = X == null ? null : X.clone();
        this.numGains = numGains;
        this.numBiases = numBiases;
    }

    public opencv_core.CvMat getX() {
        return this.X;
    }

    public int getNumGains() {
        return this.numGains;
    }

    public int getNumBiases() {
        return this.numBiases;
    }

    public void transformColor(opencv_core.IplImage srcImage, opencv_core.IplImage dstImage, opencv_core.CvRect roi, int pyramidLevel, ImageTransformer.Parameters parameters, boolean inverse) {
        Parameters p = (Parameters)parameters;
        if (Arrays.equals(p.getColorParameters(), p.getIdentityColorParameters()) && (this.X == null || p.fakeIdentity) || this.X == null && this.numGains == 0 && this.numBiases == 0) {
            if (srcImage != dstImage) {
                opencv_core.cvCopy(srcImage, dstImage);
            }
            return;
        }
        opencv_core.CvMat X2 = X24x4.get();
        this.prepareColorTransform(X2, pyramidLevel, p, inverse);
        X2.rows(3);
        if (roi == null) {
            opencv_core.cvResetImageROI(dstImage);
        } else {
            opencv_core.cvSetImageROI(dstImage, roi);
        }
        X2.put(0, 3, X2.get(0, 3) * dstImage.highValue());
        X2.put(1, 3, X2.get(1, 3) * dstImage.highValue());
        X2.put(2, 3, X2.get(2, 3) * dstImage.highValue());
        opencv_core.cvTransform(srcImage, dstImage, X2, null);
        X2.rows(4);
    }

    protected void prepareColorTransform(opencv_core.CvMat X2, int pyramidLevel, Parameters p, boolean inverse) {
        opencv_core.CvMat A2 = p.getA();
        opencv_core.CvMat b2 = p.getB();
        opencv_core.cvSetIdentity(X2);
        X2.rows(3);
        X2.cols(3);
        if (p.fakeIdentity && !inverse) {
            X2.put(A2);
        } else if (A2 != null && this.X != null) {
            opencv_core.cvMatMul(this.X, A2, X2);
        } else if (this.X == null) {
            X2.put(A2);
        } else if (A2 == null) {
            X2.put(this.X);
        }
        X2.rows(4);
        X2.cols(4);
        if (b2 != null) {
            X2.put(0, 3, b2.get(0));
            X2.put(1, 3, b2.get(1));
            X2.put(2, 3, b2.get(2));
        }
        if (inverse) {
            opencv_core.cvInvert(X2, X2, 1);
        }
    }

    public void transform(ImageTransformer.Data[] data, opencv_core.CvRect roi, ImageTransformer.Parameters[] parameters, boolean[] inverses) {
        int i2;
        assert (data.length == parameters.length);
        if (this.kernelData == null || this.kernelData.capacity() < data.length) {
            this.kernelData = new cvkernels.KernelData(data.length);
        }
        if (this.H == null || this.H.length < data.length) {
            this.H = new opencv_core.CvMat[data.length];
            for (i2 = 0; i2 < this.H.length; ++i2) {
                this.H[i2] = opencv_core.CvMat.create(3, 3);
            }
        }
        if (this.X2 == null || this.X2.length < data.length) {
            this.X2 = new opencv_core.CvMat[data.length];
            for (i2 = 0; i2 < this.X2.length; ++i2) {
                this.X2[i2] = opencv_core.CvMat.create(4, 4);
            }
        }
        for (i2 = 0; i2 < data.length; ++i2) {
            this.kernelData.position(i2);
            this.kernelData.srcImg(data[i2].srcImg);
            this.kernelData.srcImg2(null);
            this.kernelData.subImg(data[i2].subImg);
            this.kernelData.srcDotImg(data[i2].srcDotImg);
            this.kernelData.mask(data[i2].mask);
            this.kernelData.zeroThreshold(data[i2].zeroThreshold);
            this.kernelData.outlierThreshold(data[i2].outlierThreshold);
            boolean inverse = inverses == null ? false : inverses[i2];
            this.prepareHomography(this.H[i2], data[i2].pyramidLevel, (Parameters)parameters[i2], inverse);
            this.prepareColorTransform(this.X2[i2], data[i2].pyramidLevel, (Parameters)parameters[i2], inverse);
            this.kernelData.H1(this.H[i2]);
            this.kernelData.H2(null);
            this.kernelData.X(this.X2[i2]);
            this.kernelData.transImg(data[i2].transImg);
            this.kernelData.dstImg(data[i2].dstImg);
            this.kernelData.dstDstDot(data[i2].dstDstDot);
        }
        int fullCapacity = this.kernelData.capacity();
        this.kernelData.capacity(data.length);
        cvkernels.multiWarpColorTransform(this.kernelData, roi, this.getFillColor());
        this.kernelData.capacity(fullCapacity);
        for (int i3 = 0; i3 < data.length; ++i3) {
            this.kernelData.position(i3);
            data[i3].dstCount = this.kernelData.dstCount();
            data[i3].dstCountZero = this.kernelData.dstCountZero();
            data[i3].dstCountOutlier = this.kernelData.dstCountOutlier();
            data[i3].srcDstDot = this.kernelData.srcDstDot();
        }
    }

    public Parameters createParameters() {
        return new Parameters();
    }

    public class Parameters
    extends ProjectiveTransformer.Parameters {
        protected double[] colorParameters;
        protected double[] identityColorParameters;
        private opencv_core.CvMat A;
        private opencv_core.CvMat b;

        protected Parameters() {
            super(ProjectiveColorTransformer.this);
            this.colorParameters = null;
            this.identityColorParameters = null;
            this.A = null;
            this.b = null;
            this.identityColorParameters = new double[ProjectiveColorTransformer.this.numGains + ProjectiveColorTransformer.this.numBiases];
            if (ProjectiveColorTransformer.this.numGains > 0) {
                this.A = opencv_core.CvMat.create(3, 3);
                opencv_core.cvSetIdentity(this.A);
            }
            if (ProjectiveColorTransformer.this.numBiases > 0) {
                this.b = opencv_core.CvMat.create(3, 1);
                opencv_core.cvSetZero(this.b);
            }
            switch (ProjectiveColorTransformer.this.numGains) {
                case 0: {
                    assert (this.A == null);
                    break;
                }
                case 1: {
                    this.identityColorParameters[0] = (this.A.get(0) + this.A.get(4) + this.A.get(8)) / 3.0;
                    break;
                }
                case 3: {
                    this.identityColorParameters[0] = this.A.get(0);
                    this.identityColorParameters[1] = this.A.get(4);
                    this.identityColorParameters[2] = this.A.get(8);
                    break;
                }
                case 9: {
                    this.A.get(0, this.identityColorParameters, 0, 9);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            switch (ProjectiveColorTransformer.this.numBiases) {
                case 0: {
                    assert (this.b == null);
                    break;
                }
                case 1: {
                    this.identityColorParameters[ProjectiveColorTransformer.this.numGains] = (this.b.get(0) + this.b.get(1) + this.b.get(2)) / 3.0;
                    break;
                }
                case 3: {
                    this.b.get(0, this.identityColorParameters, ProjectiveColorTransformer.this.numGains, 3);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.reset(false);
        }

        public double[] getColorParameters() {
            return this.colorParameters;
        }

        public double[] getIdentityColorParameters() {
            return this.identityColorParameters;
        }

        public int size() {
            return super.size() + ProjectiveColorTransformer.this.numGains + ProjectiveColorTransformer.this.numBiases;
        }

        public double get(int i2) {
            int s2 = super.size();
            if (i2 < s2) {
                return super.get(i2);
            }
            return this.colorParameters[i2 - s2];
        }

        public void set(int i2, double p) {
            int s2 = super.size();
            if (i2 < s2) {
                super.set(i2, p);
            } else if (this.colorParameters[i2 - s2] != p) {
                this.colorParameters[i2 - s2] = p;
                this.setUpdateNeeded(true);
            }
        }

        public void reset(boolean asIdentity) {
            super.reset(asIdentity);
            this.resetColor(asIdentity);
        }

        public void resetColor(boolean asIdentity) {
            if (!(this.identityColorParameters == null || Arrays.equals(this.colorParameters, this.identityColorParameters) && this.fakeIdentity == asIdentity)) {
                this.fakeIdentity = asIdentity;
                this.colorParameters = (double[])this.identityColorParameters.clone();
                this.setUpdateNeeded(true);
            }
        }

        public void compose(ImageTransformer.Parameters p1, boolean inverse1, ImageTransformer.Parameters p2, boolean inverse2) {
            super.compose(p1, inverse1, p2, inverse2);
            this.composeColor(p1, inverse1, p2, inverse2);
        }

        public void composeColor(ImageTransformer.Parameters p1, boolean inverse1, ImageTransformer.Parameters p2, boolean inverse2) {
            assert (!inverse1 && !inverse2);
            Parameters pp1 = (Parameters)p1;
            Parameters pp2 = (Parameters)p2;
            opencv_core.CvMat A1 = pp1.getA();
            opencv_core.CvMat b1 = pp1.getB();
            opencv_core.CvMat A2 = pp2.getA();
            opencv_core.CvMat b2 = pp2.getB();
            if (this.b != null) {
                if (pp1.fakeIdentity && ProjectiveColorTransformer.this.X != null) {
                    opencv_core.CvMat temp = temp3x1.get();
                    opencv_core.cvMatMul(ProjectiveColorTransformer.this.X, b1, temp);
                    b1 = temp;
                }
                if (A2 == null && b2 == null) {
                    opencv_core.cvCopy(b1, this.b);
                } else if (b1 == null) {
                    opencv_core.cvCopy(b2, this.b);
                } else if (b2 == null) {
                    opencv_core.cvMatMul(A2, b1, this.b);
                } else {
                    opencv_core.cvGEMM(A2, b1, 1.0, b2, 1.0, this.b, 0);
                }
            }
            if (this.A != null) {
                if (A1 == null) {
                    opencv_core.cvCopy(A2, this.A);
                } else if (A2 == null) {
                    opencv_core.cvCopy(A1, this.A);
                } else {
                    opencv_core.cvMatMul(A2, A1, this.A);
                }
            }
            switch (ProjectiveColorTransformer.this.numGains) {
                case 0: {
                    assert (this.A == null);
                    break;
                }
                case 1: {
                    this.colorParameters[0] = (this.A.get(0) + this.A.get(4) + this.A.get(8)) / 3.0;
                    break;
                }
                case 3: {
                    this.colorParameters[0] = this.A.get(0);
                    this.colorParameters[1] = this.A.get(4);
                    this.colorParameters[2] = this.A.get(8);
                    break;
                }
                case 9: {
                    this.A.get(0, this.colorParameters, 0, 9);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            switch (ProjectiveColorTransformer.this.numBiases) {
                case 0: {
                    assert (this.b == null);
                    break;
                }
                case 1: {
                    this.colorParameters[ProjectiveColorTransformer.this.numGains] = (this.b.get(0) + this.b.get(1) + this.b.get(2)) / 3.0;
                    break;
                }
                case 3: {
                    this.b.get(0, this.colorParameters, ProjectiveColorTransformer.this.numGains, 3);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public opencv_core.CvMat getA() {
            this.update();
            return this.A;
        }

        public opencv_core.CvMat getB() {
            this.update();
            return this.b;
        }

        protected void update() {
            if (!this.isUpdateNeeded()) {
                return;
            }
            switch (ProjectiveColorTransformer.this.numGains) {
                case 0: {
                    assert (this.A == null);
                    break;
                }
                case 1: {
                    this.A.put(0, this.colorParameters[0]);
                    this.A.put(4, this.colorParameters[0]);
                    this.A.put(8, this.colorParameters[0]);
                    break;
                }
                case 3: {
                    this.A.put(0, this.colorParameters[0]);
                    this.A.put(4, this.colorParameters[1]);
                    this.A.put(8, this.colorParameters[2]);
                    break;
                }
                case 9: {
                    this.A.put(0, this.colorParameters, 0, 9);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            switch (ProjectiveColorTransformer.this.numBiases) {
                case 0: {
                    assert (this.b == null);
                    break;
                }
                case 1: {
                    this.b.put(0, this.colorParameters[ProjectiveColorTransformer.this.numGains]);
                    this.b.put(1, this.colorParameters[ProjectiveColorTransformer.this.numGains]);
                    this.b.put(2, this.colorParameters[ProjectiveColorTransformer.this.numGains]);
                    break;
                }
                case 3: {
                    this.b.put(0, this.colorParameters, ProjectiveColorTransformer.this.numGains, 3);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            super.update();
            this.setUpdateNeeded(false);
        }

        public Parameters clone() {
            Parameters p = new Parameters();
            p.set(this);
            return p;
        }
    }
}

