/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.parser.video;

import com.ibm.media.parser.video.BadDataException;
import com.ibm.media.parser.video.MpegBufferThread;
import com.ibm.media.parser.video.jdk12CreateThreadAction;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.CircularBuffer;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.format.WavAudioFormat;
import com.sun.media.parser.BasicPullParser;
import com.sun.media.util.jdk12;
import java.awt.Dimension;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class MpegParser
extends BasicPullParser {
    boolean saveOutputFlag = false;
    String AoutName = "Audio.mpg";
    String VoutName = "Video.mpg";
    FileOutputStream aout;
    FileOutputStream vout;
    boolean throwOutputFlag = false;
    boolean hideAudioTracks = false;
    boolean hideVideoTracks = false;
    static final long NO_PTS_VAL = -3333333L;
    private static final float EPSILON_PTS = 45000.0f;
    private static final float EPSILON_NS = 5.0E8f;
    private static final long PRE_ROLLING_DELTA_NS = 500000000L;
    private static final byte UNKNOWN_TYPE = 0;
    private static final byte AUDIO_TYPE = 1;
    private static final byte VIDEO_TYPE = 2;
    private static final byte SYS11172_TYPE = 3;
    private static final int AUDIO_TRACK_BUF_SIZE = 100000;
    private static final int VIDEO_TRACK_BUF_SIZE = 200000;
    private static final int PACK_START_CODE = 442;
    private static final int SYSTEM_HEADER_START_CODE = 443;
    private static final int PACKET_START_CODE_24 = 1;
    private static final int END_CODE = 441;
    private static final int MIN_STREAM_CODE = 188;
    private static final int MAX_STREAM_CODE = 255;
    private static final int PRIVATE_STREAM2_CODE = 191;
    private static final int VIDEO_PICTURE_START_CODE = 256;
    private static final int VIDEO_SEQUENCE_HEADER_CODE = 435;
    private static final int VIDEO_GROUP_START_CODE = 440;
    private static final int MAX_AUDIO_STREAMS = 32;
    private static final int MAX_VIDEO_STREAMS = 16;
    private static final int MAX_NUM_STREAMS = 48;
    private static final int MIN_AUDIO_ID = 0;
    private static final int MAX_AUDIO_ID = 31;
    private static final int MIN_VIDEO_ID = 32;
    private static final int MAX_VIDEO_ID = 47;
    private static int MAX_TRACKS_SUPPORTED = 48;
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("audio.mpeg"), new ContentDescriptor("video.mpeg"), new ContentDescriptor("audio.mpeg")};
    private PullSourceStream stream = null;
    private TrackList[] trackList = new TrackList[MAX_TRACKS_SUPPORTED];
    private Track[] tracks = null;
    private Track[] videoTracks = null;
    private Track[] audioTracks = null;
    private int videoCount = 0;
    private int audioCount = 0;
    private int numSupportedTracks = 0;
    private int numTracks = 0;
    private int numPackets = 0;
    private int initTmpBufLen;
    private byte[] initTmpStreamBuf;
    private byte streamType = 0;
    private long streamContentLength = 0L;
    private SystemHeader sysHeader = new SystemHeader();
    private boolean sysHeaderSeen = false;
    boolean EOMflag = false;
    boolean parserErrorFlag = false;
    private boolean durationInitialized = false;
    private boolean sysPausedFlag = false;
    private boolean seekableStreamFlag = false;
    private boolean randomAccessStreamFlag = true;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] mSecurity = new Method[1];
    private Class[] clSecurity = new Class[1];
    private Object[][] argsSecurity = new Object[1][0];
    private long startLocation = 0L;
    private Time durationNs = Duration.DURATION_UNKNOWN;
    private Time lastSetPositionTime = new Time(0L);
    private long startPTS = -3333333L;
    long currentPTS = -3333333L;
    long endPTS = -3333333L;
    private long AVstartTimeNs = 0L;
    private long AVcurrentTimeNs = 0L;
    private long AVlastTimeNs = 0L;
    private long lastAudioNs = 0L;
    private MpegBufferThread mpThread = null;
    static int[][][] bitrates;
    static int[][] samplerates;
    static /* synthetic */ Class class$com$ibm$media$parser$video$MpegBufferThread;

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        super.setSource(source);
        this.stream = (PullSourceStream)this.streams[0];
        this.streamContentLength = this.stream.getContentLength();
        this.seekableStreamFlag = this.streams[0] instanceof Seekable;
        if (!this.seekableStreamFlag) {
            throw new IncompatibleSourceException("Mpeg Stream is not Seekable");
        }
        this.randomAccessStreamFlag = this.seekableStreamFlag && ((Seekable)((Object)this.streams[0])).isRandomAccess();
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public void start() throws IOException {
        super.start();
        this.sysPausedFlag = false;
        if (this.mpThread != null) {
            this.mpThread.start();
        }
    }

    public void stop() {
        super.stop();
        this.sysPausedFlag = true;
        if (this.mpThread != null) {
            this.mpThread.pause();
        }
        int i2 = 0;
        while (i2 < this.numTracks) {
            if (this.tracks[i2] != null && this.tracks[i2].isEnabled()) {
                TrackList info = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                info.releaseReadFrame();
            }
            ++i2;
        }
    }

    public void close() {
        this.stop();
        this.flushInnerBuffers();
        super.close();
        if (this.mpThread != null) {
            this.mpThread.kill();
        }
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.streamType == 3) {
            if (this.hideAudioTracks && this.videoTracks != null) {
                return this.videoTracks;
            }
            if (this.hideVideoTracks && this.audioTracks != null) {
                return this.audioTracks;
            }
        }
        if (this.tracks != null) {
            return this.tracks;
        }
        try {
            this.initTmpBufLen = 100000;
            this.initTmpStreamBuf = new byte[this.initTmpBufLen];
            this.initTmpBufLen = this.detectStreamType(this.initTmpStreamBuf);
            switch (this.streamType) {
                case 1: 
                case 2: {
                    this.initTrackAudioVideoOnly();
                    break;
                }
                case 3: {
                    this.initTrackSystemStream();
                    break;
                }
                default: {
                    throw new BadHeaderException("Couldn't detect stream type");
                }
            }
            this.initDuration();
            if (this.saveOutputFlag) {
                this.aout = new FileOutputStream(this.AoutName);
                this.vout = new FileOutputStream(this.VoutName);
            }
            if (this.streamType == 3) {
                if (jmfSecurity != null) {
                    String permission = null;
                    try {
                        if (jmfSecurity.getName().startsWith("jmf-security")) {
                            permission = "thread";
                            jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 16);
                            this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                            permission = "thread group";
                            jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 32);
                            this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                        } else if (jmfSecurity.getName().startsWith("internet")) {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                        }
                    }
                    catch (Throwable e2) {
                        securityPrivelege = false;
                    }
                }
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    try {
                        Constructor cons = jdk12CreateThreadAction.cons;
                        this.mpThread = (MpegBufferThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$ibm$media$parser$video$MpegBufferThread == null ? (class$com$ibm$media$parser$video$MpegBufferThread = MpegParser.class$("com.ibm.media.parser.video.MpegBufferThread")) : class$com$ibm$media$parser$video$MpegBufferThread));
                    }
                    catch (Exception e3) {
                        System.err.println("MpegParser: Caught Exception " + e3);
                    }
                } else {
                    this.mpThread = new MpegBufferThread();
                }
                if (this.mpThread != null) {
                    this.mpThread.setParser(this);
                    this.mpThread.start();
                }
                if (this.saveOutputFlag || this.throwOutputFlag) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e4) {
                        // empty catch block
                    }
                }
            }
            if (this.streamType == 3) {
                if (this.hideAudioTracks) {
                    return this.videoTracks;
                }
                if (this.hideVideoTracks) {
                    return this.audioTracks;
                }
            }
            return this.tracks;
        }
        catch (BadDataException e5) {
            this.parserErrorFlag = true;
            throw new BadHeaderException("Bad data");
        }
        catch (BadHeaderException e6) {
            this.parserErrorFlag = true;
            throw e6;
        }
        catch (IOException e7) {
            this.updateEOMState();
            this.EOMflag = true;
            throw e7;
        }
    }

    private boolean isValidMp3Header(int code) {
        return (code >>> 21 & 0x7FF) == 2047 && (code >>> 19 & 3) != 1 && (code >>> 17 & 3) != 0 && (code >>> 12 & 0xF) != 0 && (code >>> 12 & 0xF) != 15 && (code >>> 10 & 3) != 3 && (code & 3) != 2;
    }

    private int detectStreamType(byte[] streamBuf) throws IOException {
        int i2 = 0;
        int videoCount = 0;
        int audioCount = 0;
        boolean found = false;
        if (this.streamType != 0) {
            return 0;
        }
        try {
            this.readBytes(this.stream, streamBuf, 4);
            block7: while (!found && i2 < streamBuf.length - 5) {
                int code = (streamBuf[i2] & 0xFF) << 24 | (streamBuf[i2 + 1] & 0xFF) << 16 | (streamBuf[i2 + 2] & 0xFF) << 8 | streamBuf[i2 + 3] & 0xFF;
                switch (code) {
                    case 442: {
                        this.readBytes(this.stream, streamBuf, ++i2 + 3, 1);
                        if ((streamBuf[i2 + 3] & 0xFFFFFFF1) != 33) continue block7;
                        this.streamType = (byte)3;
                        found = true;
                        continue block7;
                    }
                    case 435: {
                        if (i2 == 0) {
                            this.streamType = (byte)2;
                            found = true;
                        }
                    }
                    case 256: 
                    case 440: {
                        ++videoCount;
                        break;
                    }
                    default: {
                        if ((code & 0xFFF00000) != -1048576 || (code & 0x60000) == 0 || !this.isValidMp3Header(code)) break;
                        ++audioCount;
                        this.streamType = 1;
                        found = true;
                        this.startLocation = i2;
                    }
                }
                this.readBytes(this.stream, streamBuf, ++i2 + 3, 1);
            }
        }
        catch (IOException e2) {
            if (this.streamType == 0) {
                if (videoCount > 0) {
                    this.streamType = (byte)2;
                } else if (audioCount > 0) {
                    this.streamType = 1;
                }
            }
            this.updateEOMState();
            this.EOMflag = true;
            throw e2;
        }
        if (this.streamType == 0) {
            if (videoCount > 4) {
                this.streamType = (byte)2;
            } else if (audioCount > 20) {
                this.streamType = 1;
            }
        }
        if (this.seekableStreamFlag && this.streamType == 1) {
            int duration = -1;
            Seekable s2 = (Seekable)((Object)this.stream);
            long currentPos = s2.tell();
            s2.seek(this.startLocation);
            int frameHeader = this.readInt(this.stream);
            int h_id = frameHeader >>> 19 & 3;
            int h_layer = frameHeader >>> 17 & 3;
            int h_bitrate = frameHeader >>> 12 & 0xF;
            int h_samplerate = frameHeader >>> 10 & 3;
            int h_padding = frameHeader >>> 9 & 1;
            int h_mode = frameHeader >>> 6 & 3;
            int bitrate = bitrates[h_id][h_layer][h_bitrate];
            int offset = (h_id & 1) == 1 ? (h_mode != 3 ? 36 : 21) : (h_mode != 3 ? 21 : 13);
            s2.seek(offset);
            String hdr = this.readString(this.stream);
            if (hdr.equals("Xing")) {
                int flags = this.readInt(this.stream);
                int frames = this.readInt(this.stream);
                int bytes = this.readInt(this.stream);
                int samplerate = samplerates[h_id][h_samplerate];
                int frameSize = 144000 * bitrate / samplerate + h_padding;
                duration = frameSize * frames / (bitrate * 125);
                if (duration > 0) {
                    this.durationInitialized = true;
                    this.durationNs = new Time((double)duration);
                }
            }
            s2.seek(currentPos);
        }
        return i2 + 4;
    }

    private void initTrackAudioVideoOnly() throws IOException, BadHeaderException, BadDataException {
        int possibleLen;
        int itmp = 0;
        this.numTracks = 1;
        this.tracks = new Track[1];
        this.trackList[0] = new TrackList();
        int n2 = possibleLen = this.streamType == 1 ? 100000 : 200000;
        if (this.initTmpBufLen < possibleLen) {
            if (possibleLen > this.initTmpStreamBuf.length) {
                byte[] tmpBuf2 = new byte[possibleLen];
                System.arraycopy(this.initTmpStreamBuf, 0, tmpBuf2, 0, this.initTmpBufLen);
                this.initTmpStreamBuf = tmpBuf2;
            }
            try {
                itmp = this.readBytes(this.stream, this.initTmpStreamBuf, this.initTmpBufLen, possibleLen - this.initTmpBufLen);
            }
            catch (IOException e2) {
                this.updateEOMState();
                this.EOMflag = true;
            }
            this.initTmpBufLen += itmp;
        }
        TrackList trackInfo = this.trackList[0];
        do {
            this.extractStreamInfo(this.initTmpStreamBuf, 0, this.initTmpBufLen, true);
            if (trackInfo.infoFlag) break;
            try {
                itmp = this.readBytes(this.stream, this.initTmpStreamBuf, possibleLen);
            }
            catch (IOException e3) {
                this.updateEOMState();
                this.EOMflag = true;
                break;
            }
            this.initTmpBufLen = itmp;
        } while (!trackInfo.infoFlag);
        if (!trackInfo.infoFlag) {
            this.numTracks = 0;
            this.tracks = null;
            throw new BadHeaderException("Sorry, No tracks found");
        }
        ((Seekable)((Object)this.stream)).seek(0L);
        this.initTmpBufLen = 0;
        this.EOMflag = false;
    }

    private void initTrackSystemStream() throws IOException, BadHeaderException, BadDataException {
        int v;
        TrackList trackInfo;
        this.tracks = new Track[MAX_TRACKS_SUPPORTED];
        int i2 = 0;
        while (i2 < this.tracks.length) {
            this.tracks[i2] = null;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.trackList.length) {
            this.trackList[i2] = null;
            ++i2;
        }
        this.mpegSystemParseBitstream(false, 0L, true, -3333333L);
        if (this.numTracks == 0) {
            throw new BadHeaderException("Sorry, No tracks found");
        }
        Track[] tmpTracks = new Track[this.numTracks];
        i2 = 0;
        while (i2 < this.numTracks) {
            tmpTracks[i2] = this.tracks[i2];
            ++i2;
        }
        this.tracks = tmpTracks;
        if (this.hideAudioTracks) {
            i2 = 0;
            while (i2 < this.numTracks) {
                if (this.tracks[i2] != null) {
                    trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                    if (trackInfo.trackType == 2) {
                        ++this.videoCount;
                    }
                }
                ++i2;
            }
            if (this.videoCount == 0) {
                throw new BadHeaderException("Sorry, No video tracks found");
            }
            this.videoTracks = new Track[this.videoCount];
            i2 = 0;
            v = 0;
            while (i2 < this.numTracks) {
                if (this.tracks[i2] != null) {
                    trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                    if (trackInfo.trackType == 2) {
                        this.videoTracks[v] = this.tracks[i2];
                    }
                }
                ++i2;
            }
        }
        if (this.hideVideoTracks) {
            i2 = 0;
            while (i2 < this.numTracks) {
                if (this.tracks[i2] != null) {
                    trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                    if (trackInfo.trackType == 1) {
                        ++this.audioCount;
                    }
                }
                ++i2;
            }
            if (this.audioCount == 0) {
                throw new BadHeaderException("Sorry, No video tracks found");
            }
            this.audioTracks = new Track[this.audioCount];
            i2 = 0;
            v = 0;
            while (i2 < this.numTracks) {
                if (this.tracks[i2] != null) {
                    trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                    if (trackInfo.trackType == 1) {
                        this.audioTracks[v] = this.tracks[i2];
                    }
                }
                ++i2;
            }
        }
    }

    public String getName() {
        return "Parser for MPEG-1 file format";
    }

    private long convPTStoNanoseconds(long val) {
        return val * 100000L / 9L;
    }

    private long convNanosecondsToPTS(long val) {
        return val * 9L / 100000L;
    }

    private long convBytesToTimeAV(long bytes) {
        long time;
        if (this.trackList[0] == null) {
            return 0L;
        }
        if (this.streamType == 1) {
            if (((Audio)this.trackList[0].media).bitRate == 0) {
                time = 0L;
            } else {
                time = (bytes << 3) / (long)((Audio)this.trackList[0].media).bitRate;
                time *= 1000000L;
            }
        } else if (((Video)this.trackList[0].media).bitRate == 0) {
            time = 0L;
        } else {
            time = (bytes << 3) / (long)((Video)this.trackList[0].media).bitRate;
            time *= 1000000000L;
        }
        return time;
    }

    private long convTimeToBytesAV(long time) {
        long bytes;
        if (this.streamType == 1) {
            bytes = (time >> 3) * (long)((Audio)this.trackList[0].media).bitRate;
            bytes /= 1000000L;
        } else {
            bytes = (time >> 3) * (long)((Video)this.trackList[0].media).bitRate;
            bytes /= 1000000000L;
        }
        return bytes;
    }

    public Time getDuration() {
        if (this.durationInitialized) {
            return this.durationNs;
        }
        if (this.EOMflag) {
            this.durationInitialized = true;
        }
        return this.durationNs;
    }

    private void initDuration() {
        if (this.streamContentLength != -1L) {
            if (this.streamType == 3) {
                if (this.randomAccessStreamFlag) {
                    this.initDurationSystemSeekableRA();
                }
            } else {
                this.updateDurationAudioVideoOnly();
            }
        }
    }

    private void updateDurationAudioVideoOnly() {
        if (this.durationInitialized) {
            return;
        }
        this.AVstartTimeNs = 0L;
        this.AVcurrentTimeNs = 0L;
        this.AVlastTimeNs = this.convBytesToTimeAV(this.streamContentLength);
        this.durationNs = new Time(this.AVlastTimeNs - this.AVstartTimeNs);
        this.durationInitialized = true;
    }

    private void initDurationSystemSeekableRA() {
        long ltmp;
        long baseLocation = 0L;
        int saveNumPackets = this.numPackets;
        boolean saveEOMflag = this.EOMflag;
        baseLocation = ((Seekable)((Object)this.stream)).tell();
        if (this.startPTS == -3333333L) {
            this.EOMflag = false;
            ((Seekable)((Object)this.stream)).seek(0L);
            try {
                this.mpegSystemParseBitstream(true, 65536L, false, -3333333L);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if (this.startPTS == -3333333L) {
            this.startPTS = 0L;
        }
        if (this.endPTS == -3333333L) {
            this.EOMflag = false;
            this.currentPTS = -3333333L;
            ltmp = this.streamContentLength - 131072L;
            if (ltmp < 0L) {
                ltmp = 0L;
            }
            ((Seekable)((Object)this.stream)).seek(ltmp);
            try {
                this.mpegSystemParseBitstream(true, 131072L, false, -3333333L);
            }
            catch (Exception e3) {
                // empty catch block
            }
            this.endPTS = this.currentPTS;
        }
        if (this.endPTS == -3333333L) {
            this.endPTS = this.startPTS;
        }
        if ((ltmp = this.endPTS - this.startPTS) < 0L) {
            ltmp = 0L;
            this.parserErrorFlag = true;
        }
        this.durationNs = new Time(this.convPTStoNanoseconds(ltmp));
        this.lastSetPositionTime = new Time(this.convPTStoNanoseconds(this.startPTS));
        ((Seekable)((Object)this.stream)).seek(baseLocation);
        this.EOMflag = saveEOMflag;
        this.numPackets = saveNumPackets;
        this.durationInitialized = true;
    }

    void updateTrackEOM() {
        int i2 = 0;
        while (i2 < this.trackList.length) {
            if (this.trackList[i2] != null) {
                this.trackList[i2].generateEOM();
            }
            ++i2;
        }
    }

    void updateEOMState() {
        if (!this.durationInitialized) {
            if (this.streamContentLength == -1L) {
                this.streamContentLength = this.getLocation(this.stream);
            }
            if (this.streamType == 3) {
                long ltmp;
                if (this.startPTS == -3333333L) {
                    this.startPTS = 0L;
                }
                if (this.endPTS == -3333333L) {
                    this.endPTS = this.currentPTS;
                }
                if (this.endPTS == -3333333L) {
                    this.endPTS = this.startPTS;
                }
                if ((ltmp = this.endPTS - this.startPTS) < 0L) {
                    ltmp = 0L;
                    this.parserErrorFlag = true;
                }
                this.durationNs = new Time(this.convPTStoNanoseconds(ltmp));
                this.durationInitialized = true;
            } else {
                this.updateDurationAudioVideoOnly();
            }
        }
    }

    public Time getMediaTime() {
        Time mtime;
        if (this.streamType == 3) {
            mtime = this.currentPTS == -3333333L ? new Time(0L) : new Time(this.convPTStoNanoseconds(this.currentPTS - this.startPTS));
        } else {
            this.AVcurrentTimeNs = this.convBytesToTimeAV(this.getLocation(this.stream));
            mtime = new Time(this.AVcurrentTimeNs);
        }
        return mtime;
    }

    public Time setPosition(Time where, int rounding) {
        long newTimeNs;
        Time newTime = null;
        if (!this.durationInitialized || this.durationNs == Duration.DURATION_UNKNOWN) {
            return new Time(0L);
        }
        Time preWhere = new Time(where.getNanoseconds() - 500000000L);
        if (this.streamType == 3) {
            this.flushInnerBuffers();
            long preWherePTS = this.convNanosecondsToPTS(preWhere.getNanoseconds());
            long wherePTS = this.convNanosecondsToPTS(where.getNanoseconds());
            long newPTS = this.setPositionSystemSeekableRA(preWherePTS += this.startPTS, wherePTS += this.startPTS);
            this.lastAudioNs = newTimeNs = this.convPTStoNanoseconds(newPTS);
        } else {
            this.lastAudioNs = newTimeNs = this.setPositionAudioVideoOnly(preWhere.getNanoseconds(), where.getNanoseconds());
        }
        newTime = new Time(newTimeNs);
        if (this.lastSetPositionTime.getNanoseconds() == newTimeNs) {
            ++newTimeNs;
        }
        this.lastSetPositionTime = new Time(newTimeNs);
        this.EOMflag = false;
        this.parserErrorFlag = false;
        return newTime;
    }

    private long setPositionAudioVideoOnly(long where, long origWhere) {
        long newTime;
        if ((float)origWhere <= (float)this.AVstartTimeNs + 5.0E8f) {
            newTime = this.AVstartTimeNs;
            ((Seekable)((Object)this.stream)).seek(0L);
        } else if ((float)origWhere >= (float)this.AVlastTimeNs - 5.0E8f) {
            newTime = this.AVlastTimeNs - this.AVstartTimeNs;
            ((Seekable)((Object)this.stream)).seek(this.streamContentLength);
        } else {
            newTime = where;
            long pos = this.convTimeToBytesAV(where);
            ((Seekable)((Object)this.stream)).seek(pos);
        }
        return newTime;
    }

    private long setPositionSystemSeekableRA(long wherePTS, long origWherePTS) {
        long newTime = -3333333L;
        long lres = -1L;
        long saveStartPTS = this.startPTS;
        boolean saveEOMflag = this.EOMflag;
        boolean zeroPosFlag = false;
        if (this.endPTS == -3333333L || this.startPTS == -3333333L) {
            newTime = 0L;
            ((Seekable)((Object)this.stream)).seek(0L);
        } else if ((float)origWherePTS <= (float)this.startPTS + 45000.0f) {
            newTime = 0L;
            ((Seekable)((Object)this.stream)).seek(0L);
        } else if ((float)origWherePTS >= (float)this.endPTS - 45000.0f) {
            newTime = this.endPTS - this.startPTS;
            ((Seekable)((Object)this.stream)).seek(this.streamContentLength);
        } else if ((float)(this.endPTS - this.startPTS) < 45000.0f) {
            newTime = 0L;
            ((Seekable)((Object)this.stream)).seek(0L);
        } else {
            long pos = (long)((float)this.streamContentLength * ((float)(wherePTS - this.startPTS) / (float)(this.endPTS - this.startPTS)));
            long step = 20480L;
            if ((pos -= step) < 0L) {
                pos = 0L;
            }
            long range = this.streamContentLength - pos;
            while (true) {
                ((Seekable)((Object)this.stream)).seek(pos);
                this.currentPTS = -3333333L;
                this.startPTS = -3333333L;
                this.EOMflag = false;
                try {
                    lres = this.mpegSystemParseBitstream(true, range, false, wherePTS);
                }
                catch (IOException e2) {
                    lres = -2L;
                    saveEOMflag = true;
                }
                catch (Exception e3) {
                    lres = -1L;
                }
                if (lres >= 0L) {
                    newTime = this.currentPTS - saveStartPTS;
                    ((Seekable)((Object)this.stream)).seek(lres);
                    break;
                }
                if (lres == -2L) {
                    newTime = this.endPTS - saveStartPTS;
                    ((Seekable)((Object)this.stream)).seek(this.streamContentLength);
                    break;
                }
                if ((pos -= step) <= 0L) {
                    if (zeroPosFlag) {
                        newTime = 0L;
                        ((Seekable)((Object)this.stream)).seek(0L);
                        break;
                    }
                    pos = 0L;
                    zeroPosFlag = true;
                }
                range = 3L * step;
            }
            this.startPTS = saveStartPTS;
            this.EOMflag = saveEOMflag;
        }
        return newTime;
    }

    long mpegSystemParseBitstream(boolean justLooking, long range, boolean justEnough, long newPTS) throws IOException, BadHeaderException, BadDataException {
        long baseLocation;
        byte[] buf1 = new byte[1];
        int code = 0;
        boolean read4 = true;
        boolean packFound = false;
        long lastPacketLocation = baseLocation = this.getLocation(this.stream);
        long lastLastPacketLocation = baseLocation;
        long loc = baseLocation + 4L;
        long lastCurrentPTS = -3333333L;
        long savePTS = -3333333L;
        block5: while (!this.sysPausedFlag && !this.EOMflag || justLooking || justEnough) {
            if (justEnough && !this.needingMore()) break;
            if (justLooking) {
                if (this.getLocation(this.stream) - baseLocation > range) break;
                if (newPTS != -3333333L) {
                    if (newPTS < this.startPTS) {
                        return -1L;
                    }
                    if (newPTS <= this.currentPTS) {
                        if (newPTS == this.currentPTS) {
                            return lastPacketLocation;
                        }
                        this.currentPTS = lastCurrentPTS;
                        return lastLastPacketLocation;
                    }
                }
            }
            if (read4) {
                code = this.readInt(this.stream, true);
            } else {
                this.readBytes(this.stream, buf1, 1);
                code = code << 8 & 0xFFFFFF00 | buf1[0] & 0xFF;
            }
            switch (code) {
                case 442: {
                    this.parsePackHeader();
                    read4 = true;
                    packFound = true;
                    break;
                }
                case 443: {
                    this.parseSystemHeader();
                    read4 = true;
                    break;
                }
                case 441: {
                    this.EOMflag = true;
                    if (this.endPTS == -3333333L) {
                        this.endPTS = this.currentPTS;
                    }
                    if (justLooking && newPTS == -3333333L) continue block5;
                    this.updateEOMState();
                    break;
                }
                default: {
                    if (code >> 8 == 1 && (!justLooking || packFound & justLooking)) {
                        if (justLooking && newPTS != -3333333L) {
                            loc = this.getLocation(this.stream);
                            savePTS = this.currentPTS;
                        }
                        byte bval = (byte)(code & 0xFF);
                        this.parsePacket(bval, justLooking);
                        read4 = true;
                        if (!justLooking || newPTS == -3333333L || savePTS == this.currentPTS) continue block5;
                        lastCurrentPTS = savePTS;
                        lastLastPacketLocation = lastPacketLocation;
                        lastPacketLocation = loc - 4L;
                        break;
                    }
                    read4 = false;
                }
            }
        }
        return this.EOMflag ? -2L : -1L;
    }

    private void parsePackHeader() throws IOException, BadDataException {
        byte[] buf1 = new byte[1];
        this.readBytes(this.stream, buf1, 1);
        if ((buf1[0] & 0xFFFFFFF0) != 32) {
            throw new BadDataException("invalid pack header");
        }
        if ((buf1[0] & 1) != 1) {
            throw new BadDataException("illegal marker bit");
        }
        this.skip(this.stream, 7);
    }

    private void parseSystemHeader() throws IOException, BadHeaderException {
        byte[] buf1 = new byte[1];
        int len = this.readShort(this.stream, true);
        if (this.sysHeaderSeen) {
            this.skip(this.stream, len);
        } else {
            this.sysHeader.resetSystemHeader();
            this.sysHeader.headerLen = len;
            int itmp = this.readInt(this.stream, true);
            len -= 4;
            if ((itmp & 0x80000100) != -2147483392) {
                throw new BadHeaderException("illegal marker bits in system header");
            }
            this.sysHeader.rateBound = (itmp & 0x7FFFFE00) >> 9;
            this.sysHeader.audioBound = (itmp & 0xFC) >> 2;
            this.sysHeader.fixedFlag = (itmp & 2) >> 1;
            this.sysHeader.CSPSFlag = itmp & 1;
            this.readBytes(this.stream, buf1, 1);
            byte bval = buf1[0];
            --len;
            if ((bval & 0x20) != 32) {
                throw new BadHeaderException("illegal marker bits in system header");
            }
            this.sysHeader.audioLockFlag = (bval & 0x80) >> 7;
            this.sysHeader.videoLockFlag = (bval & 0x40) >> 6;
            this.sysHeader.videoBound = bval & 0x1F;
            this.readBytes(this.stream, buf1, 1);
            --len;
            this.sysHeader.reserved = buf1[0];
            while (len > 1) {
                int i2;
                int size;
                short stmp;
                this.readBytes(this.stream, buf1, 1);
                bval = buf1[0];
                --len;
                if ((bval & 0xFFFFFF80) != -128) break;
                if (bval == -72) {
                    stmp = this.readShort(this.stream, true);
                    len -= 2;
                    if ((stmp & 0xC000) != 49152) {
                        throw new BadHeaderException("illegal marker bits in system header");
                    }
                    size = stmp & 0x1FFF;
                    this.sysHeader.allAudioSTDFlag = true;
                    i2 = 0;
                    while (i2 <= 31) {
                        this.sysHeader.STDBufBoundScale[i2] = 0;
                        this.sysHeader.STDBufSizeBound[i2] = size;
                        ++i2;
                    }
                    continue;
                }
                if (bval == -71) {
                    stmp = this.readShort(this.stream, true);
                    len -= 2;
                    if ((stmp & 0xC000) != 49152) {
                        throw new BadHeaderException("illegal marker bits in system header");
                    }
                    size = stmp & 0x1FFF;
                    this.sysHeader.allVideoSTDFlag = true;
                    i2 = 32;
                    while (i2 <= 47) {
                        this.sysHeader.STDBufBoundScale[i2] = 1;
                        this.sysHeader.STDBufSizeBound[i2] = size;
                        ++i2;
                    }
                    continue;
                }
                if ((bval & 0xFF) < 188 || (bval & 0xFF) > 255) {
                    throw new BadHeaderException("illegal track number in system header");
                }
                int streamID = this.getStreamID(bval);
                if (streamID < 0 || streamID >= 48) continue;
                stmp = this.readShort(this.stream, true);
                len -= 2;
                if ((stmp & 0xC000) != 49152) {
                    throw new BadHeaderException("illegal marker bits in system header");
                }
                int scale = (stmp & 0x2000) >> 13;
                size = stmp & 0x1FFF;
                this.sysHeader.streamFlags[streamID] = true;
                this.sysHeader.STDBufBoundScale[streamID] = scale;
                this.sysHeader.STDBufSizeBound[streamID] = size;
            }
            if (len < 0) {
                throw new BadHeaderException("illegal system header");
            }
            if (len > 0) {
                this.skip(this.stream, len);
            }
            this.sysHeaderSeen = true;
        }
    }

    private void parsePacket(byte bval, boolean justLooking) throws IOException, BadDataException {
        int count = 0;
        int STDBufSize = 0;
        int STDBufScale = 0;
        int numWrittenToTmpBuf = 0;
        byte[] tmpBuf = null;
        byte[] buf1 = new byte[1];
        if ((bval & 0xFF) < 188 || (bval & 0xFF) > 255) {
            throw new BadDataException("invalid stream(track) number");
        }
        int streamID = this.getStreamID(bval);
        short packetLen = this.readShort(this.stream, true);
        buf1[0] = bval;
        if ((buf1[0] & 0xFF) != 191) {
            do {
                this.readBytes(this.stream, buf1, 1);
                ++count;
            } while (buf1[0] == -1);
            if ((buf1[0] & 0xFFFFFFC0) == 64) {
                STDBufScale = (buf1[0] & 0x20) >> 5;
                STDBufSize = (buf1[0] & 0x1F) << 8;
                this.readBytes(this.stream, buf1, 1);
                STDBufSize |= buf1[0];
                this.readBytes(this.stream, buf1, 1);
                count += 2;
            }
            if ((buf1[0] & 0xFFFFFFE0) == 32) {
                long pts = (long)(buf1[0] & 0xE) << 29;
                pts = pts << 31 >> 31;
                if ((buf1[0] & 1) != 1) {
                    throw new BadDataException("illegal marker bit");
                }
                int itmp = this.readInt(this.stream, true);
                count += 4;
                if ((itmp & 0x10001) != 65537) {
                    throw new BadDataException("illegal marker bit");
                }
                int itmp2 = (itmp & 0xFFFE0000) >> 2;
                pts |= (long)(itmp2 & 0x3FFFFFFF);
                this.currentPTS = pts |= (long)((itmp & 0xFFFE) >> 1);
                if (this.startPTS == -3333333L) {
                    this.startPTS = this.currentPTS;
                    if (this.startPTS > 0L && (float)this.startPTS <= 45000.0f) {
                        this.startPTS = 0L;
                    }
                }
                if ((buf1[0] & 0xFFFFFFF0) == 48) {
                    this.skip(this.stream, 5);
                    count += 5;
                }
            } else if (buf1[0] != 15) {
                throw new BadDataException("invalid packet");
            }
        }
        int dataSize = packetLen - count;
        if (justLooking) {
            this.skip(this.stream, dataSize);
            return;
        }
        if (streamID < 0 || streamID >= 48) {
            this.skip(this.stream, dataSize);
        } else {
            if (this.trackList[streamID] == null) {
                this.trackList[streamID] = new TrackList();
            }
            TrackList trackInfo = this.trackList[streamID];
            if (!trackInfo.infoFlag) {
                tmpBuf = new byte[dataSize];
                numWrittenToTmpBuf = this.extractStreamInfo(tmpBuf, streamID, dataSize, false);
            }
            if (!trackInfo.infoFlag) {
                this.trackList[streamID] = null;
                if (numWrittenToTmpBuf < dataSize) {
                    this.skip(this.stream, dataSize - numWrittenToTmpBuf);
                }
            } else {
                if (this.startPTS == -3333333L) {
                    trackInfo.startPTS = this.currentPTS;
                }
                trackInfo.copyStreamDataToInnerBuffer(tmpBuf, numWrittenToTmpBuf, dataSize - numWrittenToTmpBuf, this.currentPTS);
                ++trackInfo.numPackets;
                if (dataSize > trackInfo.maxPacketSize) {
                    trackInfo.maxPacketSize = dataSize;
                }
            }
        }
        ++this.numPackets;
    }

    private int extractStreamInfo(byte[] tmpBuf, int streamID, int dataLen, boolean AVOnlyState) throws IOException, BadDataException {
        int stype = 0;
        TrackList trackInfo = this.trackList[streamID];
        if (trackInfo.trackType == 0) {
            stype = AVOnlyState ? this.streamType : (streamID < 32 ? 1 : 2);
            trackInfo.init((byte)stype);
            this.sysHeader.streamFlags[streamID] = true;
            trackInfo.startPTS = this.currentPTS;
        }
        int numBytes = stype == 1 ? this.extractAudioInfo(tmpBuf, trackInfo, dataLen, AVOnlyState) : this.extractVideoInfo(tmpBuf, trackInfo, dataLen, AVOnlyState);
        if (trackInfo.infoFlag) {
            if (AVOnlyState) {
                this.tracks[0] = new MediaTrack(trackInfo);
            } else {
                this.tracks[this.numTracks] = new MediaTrack(trackInfo);
                ++this.numTracks;
            }
        }
        return numBytes;
    }

    private int extractAudioInfo(byte[] tmpBuf, TrackList trackInfo, int dataLen, boolean AVOnlyState) throws IOException, BadDataException {
        Audio audio = new Audio();
        int[] samplingFrequencyTable = new int[]{44100, 48000, 32000};
        short[] bitrateIndexTableL2 = new short[]{0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384};
        short[] bitrateIndexTableL23Ext = new short[]{0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160};
        int numBytes = AVOnlyState ? dataLen : this.readBytes(this.stream, tmpBuf, dataLen);
        int i2 = (int)this.startLocation;
        while (i2 < numBytes - 3) {
            if (tmpBuf[i2] == -1 && (tmpBuf[i2 + 1] & 0xFFFFFFF0) == -16) {
                audio.ID = (tmpBuf[i2 + 1] & 8) >> 3;
                audio.layer = 4 - ((tmpBuf[i2 + 1] & 6) >> 1);
                audio.protection = tmpBuf[i2 + 1] & 1;
                int br = (tmpBuf[i2 + 2] & 0xF0) >> 4;
                int sr = (tmpBuf[i2 + 2] & 0xC) >> 2;
                if (sr < 0 || sr >= samplingFrequencyTable.length) {
                    throw new BadDataException("Non Standard sample rates not supported");
                }
                audio.mode = (tmpBuf[i2 + 3] & 0xC0) >> 6;
                audio.modeExt = (tmpBuf[i2 + 3] & 0x30) >> 4;
                audio.channels = audio.mode == 3 ? 1 : 2;
                audio.copyright = (tmpBuf[i2 + 3] & 8) >> 3;
                audio.original = (tmpBuf[i2 + 3] & 4) >> 2;
                audio.emphasis = tmpBuf[i2 + 3] & 3;
                boolean bl = audio.valid = br != 15;
                if (audio.ID == 1) {
                    audio.sampleRate = samplingFrequencyTable[sr];
                    audio.bitRate = audio.layer == 3 ? (br < 2 ? bitrateIndexTableL2[br] : (br == 2 ? 40 : bitrateIndexTableL2[br - 1])) : (audio.layer == 2 ? bitrateIndexTableL2[br] : br << 5);
                } else {
                    audio.sampleRate = samplingFrequencyTable[sr] >> 1;
                    audio.bitRate = audio.layer == 3 || audio.layer == 2 ? bitrateIndexTableL23Ext[br] : (br < 9 ? bitrateIndexTableL2[br] : (br == 9 ? 144 : (br == 10 ? bitrateIndexTableL2[br - 1] : (br == 11 ? 176 : bitrateIndexTableL2[br - 2]))));
                }
                trackInfo.readFrameSize = audio.bitRate * 1000 >> 3;
                trackInfo.infoFlag = true;
                trackInfo.media = audio;
                break;
            }
            ++i2;
        }
        return numBytes;
    }

    private int extractVideoInfo(byte[] tmpBuf, TrackList trackInfo, int dataLen, boolean AVOnlyState) throws IOException, BadDataException {
        Video video = new Video();
        float[] aspectRatioTable = new float[]{0.0f, 1.0f, 0.6735f, 0.7031f, 0.7615f, 0.8055f, 0.8437f, 0.8935f, 0.9375f, 0.9815f, 1.0255f, 1.0695f, 1.125f, 1.1575f, 1.2015f, 1.0f};
        float[] pictureRateTable = new float[]{0.0f, 23.976f, 24.0f, 25.0f, 29.97f, 30.0f, 50.0f, 59.94f, 60.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f};
        int numBytes = AVOnlyState ? dataLen : this.readBytes(this.stream, tmpBuf, dataLen);
        int i2 = 0;
        while (i2 < numBytes - 10) {
            int code = tmpBuf[i2] << 24 & 0xFF000000 | tmpBuf[i2 + 1] << 16 & 0xFF0000 | tmpBuf[i2 + 2] << 8 & 0xFF00 | tmpBuf[i2 + 3] & 0xFF;
            if (code == 435) {
                video.width = (tmpBuf[i2 + 4 + 0] & 0xFF) << 4;
                video.width |= tmpBuf[i2 + 4 + 1] >> 4 & 0xF;
                video.height = (tmpBuf[i2 + 4 + 1] & 0xF) << 8;
                video.height |= tmpBuf[i2 + 4 + 2] & 0xFF;
                int pr = (tmpBuf[i2 + 4 + 3] & 0xF0) >> 4;
                video.pelAspectRatio = aspectRatioTable[pr];
                pr = tmpBuf[i2 + 4 + 3] & 0xF;
                video.pictureRate = pictureRateTable[pr];
                pr = (tmpBuf[i2 + 4 + 4] & 0xFF) << 10 | (tmpBuf[i2 + 4 + 5] & 0xFF) << 2 | (tmpBuf[i2 + 4 + 6] & 0xC0) >> 6;
                video.bitRate = pr * 400;
                if ((double)video.pelAspectRatio == 0.0 || (double)video.pictureRate == 0.0) {
                    throw new BadDataException("video header corrupted");
                }
                if ((double)video.pictureRate < 23.0) {
                    trackInfo.readFrameSize = 65536;
                } else {
                    trackInfo.readFrameSize = video.bitRate >> 3;
                    if (trackInfo.readFrameSize > 100000) {
                        trackInfo.readFrameSize = 100000;
                    }
                }
                trackInfo.infoFlag = true;
                trackInfo.media = video;
                break;
            }
            ++i2;
        }
        return numBytes;
    }

    private int getStreamID(byte bval) {
        return (bval & 0xFF) - 192;
    }

    private long getLocation() {
        return this.getLocation(this.stream);
    }

    boolean needingMore() {
        int i2 = 0;
        while (i2 < this.numTracks) {
            if (this.tracks[i2] != null) {
                TrackList trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                if (trackInfo.bufQ.canRead()) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    void flushInnerBuffers() {
        int i2 = 0;
        while (i2 < this.numTracks) {
            if (this.tracks[i2] != null) {
                TrackList trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                CircularBuffer circularBuffer = trackInfo.bufQ;
                synchronized (circularBuffer) {
                    trackInfo.flushFlag = true;
                    trackInfo.bufQ.notifyAll();
                }
                trackInfo.flushBuffer();
            }
            ++i2;
        }
    }

    void saveInnerBuffersToFiles() {
        int i2 = 0;
        while (i2 < this.numTracks) {
            if (this.tracks[i2] != null) {
                TrackList trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                trackInfo.saveBufToFile();
            }
            ++i2;
        }
    }

    void throwInnerBuffersContents() {
        int i2 = 0;
        while (i2 < this.numTracks) {
            if (this.tracks[i2] != null) {
                TrackList trackInfo = ((MediaTrack)this.tracks[i2]).getTrackInfo();
                trackInfo.flushBuffer();
            }
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        bitrates = new int[][][]{new int[][]{{-1}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256, -1}}, new int[][]{{-1}}, new int[][]{{-1}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256, -1}}, new int[][]{{-1}, {0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, -1}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384, -1}, {0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, -1}}};
        samplerates = new int[][]{{11025, 12000, 8000, -1}, {-1}, {22050, 24000, 16000, -1}, {44100, 48000, 32000, -1}};
    }

    private class SystemHeader {
        int headerLen = 0;
        int rateBound = 0;
        int audioBound = 0;
        int fixedFlag = 0;
        int CSPSFlag = 0;
        int audioLockFlag = 0;
        int videoLockFlag = 0;
        int videoBound = 0;
        int reserved = 0;
        boolean allAudioSTDFlag = false;
        boolean allVideoSTDFlag = false;
        boolean[] streamFlags = new boolean[48];
        int[] STDBufBoundScale = new int[48];
        int[] STDBufSizeBound = new int[48];

        SystemHeader() {
            int i2 = 0;
            while (i2 < 48) {
                this.streamFlags[i2] = false;
                this.STDBufBoundScale[i2] = 0;
                this.STDBufSizeBound[i2] = 0;
                ++i2;
            }
        }

        void resetSystemHeader() {
            this.headerLen = 0;
            this.rateBound = 0;
            this.audioBound = 0;
            this.fixedFlag = 0;
            this.CSPSFlag = 0;
            this.audioLockFlag = 0;
            this.videoLockFlag = 0;
            this.videoBound = 0;
            this.reserved = 0;
            this.allAudioSTDFlag = false;
            this.allVideoSTDFlag = false;
            int i2 = 0;
            while (i2 < 48) {
                this.streamFlags[i2] = false;
                this.STDBufBoundScale[i2] = 0;
                this.STDBufSizeBound[i2] = 0;
                ++i2;
            }
        }

        void printFields() {
            System.out.println("headerLen " + this.headerLen);
            System.out.println("rateBound " + this.rateBound);
            System.out.println("audioBound " + this.audioBound);
            System.out.println("fixedFlag " + this.fixedFlag);
            System.out.println("CSPSFlag " + this.CSPSFlag);
            System.out.println("audioLockFlag " + this.audioLockFlag);
            System.out.println("videoLockFlag " + this.videoLockFlag);
            System.out.println("videoBound " + this.videoBound);
            System.out.println("reserved " + this.reserved);
            System.out.println("allAudioSTDFlag " + this.allAudioSTDFlag);
            System.out.println("allVideoSTDFlag " + this.allVideoSTDFlag);
            int i2 = 0;
            while (i2 < 48) {
                if (this.streamFlags[i2]) {
                    System.out.println("[" + i2 + "]  STDBufBoundScale " + this.STDBufBoundScale[i2] + "     STDBufSizeBound " + this.STDBufSizeBound[i2]);
                }
                ++i2;
            }
        }
    }

    private class MediaTrack
    implements Track {
        private TrackList trackInfo;
        private boolean enabled;
        private long sequenceNumber = 0L;
        private Format format;
        private TrackListener listener;
        MpegParser parser = MpegParser.this;

        MediaTrack(TrackList trackInfo) {
            this.trackInfo = trackInfo;
            this.enabled = true;
            this.format = trackInfo.media.createFormat();
        }

        public void setTrackListener(TrackListener l2) {
            this.listener = l2;
        }

        public Format getFormat() {
            return this.format;
        }

        public void setEnabled(boolean t) {
            this.enabled = t;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time getDuration() {
            return this.trackInfo.duration;
        }

        public Time getStartTime() {
            if (MpegParser.this.streamType == 3) {
                return new Time((double)MpegParser.this.startPTS / 90000.0);
            }
            return new Time(MpegParser.this.AVstartTimeNs);
        }

        public void readFrame(Buffer buffer) {
            if (buffer == null) {
                return;
            }
            if (!this.enabled) {
                buffer.setDiscard(true);
                return;
            }
            if (MpegParser.this.streamType == 3) {
                this.systemStreamReadFrame(buffer);
            } else {
                this.AudioVideoOnlyReadFrame(buffer);
            }
            buffer.setFormat(this.format);
            buffer.setSequenceNumber(++this.sequenceNumber);
            if (this.format instanceof AudioFormat) {
                long tmp = buffer.getTimeStamp();
                buffer.setTimeStamp(MpegParser.this.lastAudioNs);
                MpegParser.this.lastAudioNs = tmp;
            }
        }

        private void AudioVideoOnlyReadFrame(Buffer buffer) {
            int counter;
            int read1;
            block14: {
                byte[] data;
                if (MpegParser.this.sysPausedFlag || MpegParser.this.parserErrorFlag) {
                    buffer.setLength(0);
                    buffer.setDiscard(true);
                }
                int size = this.trackInfo.readFrameSize;
                Object obj = buffer.getData();
                if (obj == null || !(obj instanceof byte[]) || ((byte[])obj).length < size) {
                    data = new byte[size];
                    buffer.setData(data);
                } else {
                    data = (byte[])obj;
                }
                read1 = 0;
                int read2 = size;
                int actualBytesRead = 0;
                counter = 0;
                if (MpegParser.this.initTmpBufLen > 0) {
                    read1 = MpegParser.this.initTmpBufLen > size ? size : MpegParser.this.initTmpBufLen;
                    System.arraycopy(MpegParser.this.initTmpStreamBuf, 0, data, 0, read1);
                    MpegParser.this.initTmpBufLen -= read1;
                    read2 -= read1;
                    counter = read1;
                }
                if (this.trackInfo.trackType == 1) {
                    buffer.setTimeStamp(MpegParser.this.convBytesToTimeAV(MpegParser.this.getLocation() - (long)read1));
                }
                if (read2 > 0 && !MpegParser.this.EOMflag) {
                    try {
                        actualBytesRead = this.parser.readBytes(MpegParser.this.stream, data, read1, read2);
                        if (actualBytesRead == -2) {
                            if (read1 == 0) {
                                buffer.setDiscard(true);
                                return;
                            }
                        } else {
                            counter += actualBytesRead;
                        }
                    }
                    catch (IOException e2) {
                        MpegParser.this.updateEOMState();
                        MpegParser.this.EOMflag = true;
                        if (MpegParser.this.AVlastTimeNs != 0L) break block14;
                        MpegParser.this.AVcurrentTimeNs = MpegParser.this.convBytesToTimeAV(MpegParser.this.getLocation());
                        MpegParser.this.AVlastTimeNs = MpegParser.this.AVcurrentTimeNs;
                    }
                }
            }
            if (MpegParser.this.EOMflag) {
                if (read1 > 0) {
                    buffer.setLength(read1);
                    buffer.setOffset(0);
                } else {
                    buffer.setLength(0);
                    buffer.setEOM(true);
                }
            }
            buffer.setOffset(0);
            buffer.setLength(counter);
        }

        private void systemStreamReadFrame(Buffer buffer) {
            int i2;
            TrackList AtrackInfo;
            this.trackInfo.copyFromInnerBuffer(buffer);
            if (MpegParser.this.sysPausedFlag || MpegParser.this.parserErrorFlag) {
                return;
            }
            int i3 = 0;
            while (i3 < MpegParser.this.numTracks) {
                if (MpegParser.this.tracks[i3] != null && !MpegParser.this.tracks[i3].isEnabled()) {
                    AtrackInfo = ((MediaTrack)MpegParser.this.tracks[i3]).getTrackInfo();
                    AtrackInfo.flushBuffer();
                }
                ++i3;
            }
            if (MpegParser.this.hideAudioTracks) {
                i2 = 0;
                while (i2 < MpegParser.this.numTracks) {
                    if (MpegParser.this.tracks[i2] != null) {
                        AtrackInfo = ((MediaTrack)MpegParser.this.tracks[i2]).getTrackInfo();
                        if (AtrackInfo.trackType == 1) {
                            AtrackInfo.flushBuffer();
                        }
                    }
                    ++i2;
                }
            }
            if (MpegParser.this.hideVideoTracks) {
                i2 = 0;
                while (i2 < MpegParser.this.numTracks) {
                    if (MpegParser.this.tracks[i2] != null) {
                        AtrackInfo = ((MediaTrack)MpegParser.this.tracks[i2]).getTrackInfo();
                        if (AtrackInfo.trackType == 2) {
                            AtrackInfo.flushBuffer();
                        }
                    }
                    ++i2;
                }
            }
        }

        public int mapTimeToFrame(Time t) {
            return 0;
        }

        public Time mapFrameToTime(int frameNumber) {
            return null;
        }

        private TrackList getTrackInfo() {
            return this.trackInfo;
        }
    }

    private class TrackList {
        byte trackType = 0;
        Time duration = Duration.DURATION_UNKNOWN;
        long startPTS = -3333333L;
        boolean infoFlag = false;
        int numPackets = 0;
        int maxPacketSize = 0;
        int readFrameSize = 0;
        Media media;
        boolean supported = false;
        boolean flushFlag = false;
        CircularBuffer bufQ = null;
        Buffer current = null;
        MpegParser parser = MpegParser.this;

        private TrackList() {
        }

        void init(byte stype) {
            this.supported = true;
            this.trackType = stype;
            this.bufQ = this.trackType == 2 ? new CircularBuffer(15) : new CircularBuffer(10);
        }

        int readyDataBytes() {
            return 1;
        }

        void copyStreamDataToInnerBuffer(byte[] in, int inSize, int size, long pts) throws IOException {
            int total = size;
            int len = 0;
            if (inSize > 0) {
                total += inSize;
            } else {
                inSize = 0;
            }
            CircularBuffer circularBuffer = this.bufQ;
            synchronized (circularBuffer) {
                byte[] data;
                if (this.current != null && (len = this.current.getLength()) != 0 && len + total >= this.readFrameSize) {
                    this.bufQ.writeReport();
                    this.bufQ.notify();
                    this.current = null;
                }
                this.flushFlag = false;
                if (this.current == null) {
                    while (!this.bufQ.canWrite() && !this.flushFlag) {
                        try {
                            this.bufQ.wait();
                        }
                        catch (InterruptedException e2) {
                            // empty catch block
                        }
                    }
                    if (this.flushFlag) {
                        return;
                    }
                    this.current = this.bufQ.getEmptyBuffer();
                    this.current.setFlags(0);
                    this.current.setOffset(0);
                    this.current.setLength(0);
                    this.current.setTimeStamp(MpegParser.this.convPTStoNanoseconds(pts));
                    int bsize = total > this.readFrameSize ? total : this.readFrameSize;
                    data = (byte[])this.current.getData();
                    if (data == null || data.length < bsize) {
                        data = new byte[bsize];
                        this.current.setData(data);
                    }
                } else {
                    data = (byte[])this.current.getData();
                }
                len = this.current.getLength();
                if (inSize > 0) {
                    System.arraycopy(in, 0, data, len, inSize);
                }
                this.parser.readBytes(MpegParser.this.stream, data, len + inSize, size);
                this.current.setLength(len + total);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void copyFromInnerBuffer(Buffer out) {
            CircularBuffer circularBuffer = this.bufQ;
            synchronized (circularBuffer) {
                while (!(this.bufQ.canRead() || MpegParser.this.sysPausedFlag || MpegParser.this.parserErrorFlag)) {
                    try {
                        this.bufQ.wait();
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                }
                if (!MpegParser.this.sysPausedFlag && !MpegParser.this.parserErrorFlag) {
                    Buffer buf = this.bufQ.read();
                    byte[] saved = (byte[])out.getData();
                    out.copy(buf);
                    buf.setData(saved);
                    this.bufQ.readReport();
                    this.bufQ.notify();
                    return;
                }
                out.setLength(0);
                out.setDiscard(true);
                return;
            }
        }

        void releaseReadFrame() {
            CircularBuffer circularBuffer = this.bufQ;
            synchronized (circularBuffer) {
                this.bufQ.notifyAll();
            }
        }

        void generateEOM() {
            CircularBuffer circularBuffer = this.bufQ;
            synchronized (circularBuffer) {
                if (this.current != null) {
                    this.bufQ.writeReport();
                    this.bufQ.notify();
                    this.current = null;
                }
                while (!this.bufQ.canWrite()) {
                    try {
                        this.bufQ.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Buffer buf = this.bufQ.getEmptyBuffer();
                buf.setFlags(1);
                buf.setLength(0);
                this.bufQ.writeReport();
                this.bufQ.notify();
            }
        }

        void flushBuffer() {
            CircularBuffer circularBuffer = this.bufQ;
            synchronized (circularBuffer) {
                if (this.current != null) {
                    this.current.setDiscard(true);
                    this.bufQ.writeReport();
                    this.current = null;
                }
                while (this.bufQ.canRead()) {
                    this.bufQ.read();
                    this.bufQ.readReport();
                }
                this.bufQ.notifyAll();
            }
        }

        public String toString() {
            System.out.println("track type " + this.trackType + "(0 ?, 1 audio, 2 video)");
            System.out.println("start PTS " + this.startPTS);
            System.out.println("info flag " + this.infoFlag);
            System.out.println("number of packets " + this.numPackets);
            System.out.println("maximum packet size " + this.maxPacketSize);
            System.out.println("supported " + this.supported);
            System.out.println("duration (?) " + this.duration);
            return this.media.toString();
        }

        void saveBufToFile() {
        }
    }

    private class Video
    extends Media {
        int width = 0;
        int height = 0;
        float pelAspectRatio = 0.0f;
        float pictureRate = 0.0f;
        int bitRate = 0;
        VideoFormat format = null;
        static /* synthetic */ Class array$B;

        private Video() {
        }

        Format createFormat() {
            int size = (int)((double)(this.width * this.height) * 1.5);
            if (this.format != null) {
                return this.format;
            }
            this.format = new VideoFormat("mpeg", new Dimension(this.width, this.height), size, array$B == null ? (array$B = Video.class$("[B")) : array$B, this.pictureRate);
            return this.format;
        }

        public String toString() {
            System.out.println("Video Media: " + this.format);
            System.out.println("width " + this.width);
            System.out.println("height " + this.height);
            System.out.println("pixel aspect ratio " + this.pelAspectRatio);
            System.out.println("picture rate " + this.pictureRate);
            System.out.println("bitrate " + this.bitRate);
            return super.toString();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class Audio
    extends Media {
        boolean valid = false;
        int ID = 0;
        int layer = 0;
        int protection = 0;
        int bitRate = 0;
        int sampleRate = 0;
        int mode = 0;
        int modeExt = 0;
        int copyright = 0;
        int original = 0;
        int emphasis = 0;
        int channels = 0;
        AudioFormat format = null;
        static /* synthetic */ Class array$B;

        private Audio() {
        }

        Format createFormat() {
            if (this.format != null) {
                return this.format;
            }
            String encodingString = this.layer == 3 ? "mpeglayer3" : "mpegaudio";
            int bitsPerSample = 16;
            int frameSizeInBits = (this.layer == 1 ? 352 : 1024) * this.channels * bitsPerSample;
            int bytesPerSecond = this.bitRate * 1000 >> 3;
            this.format = new WavAudioFormat(encodingString, this.sampleRate, bitsPerSample, this.channels, frameSizeInBits, bytesPerSecond, 0, 1, -1.0f, array$B == null ? (array$B = Audio.class$("[B")) : array$B, null);
            return this.format;
        }

        public String toString() {
            System.out.println("Audio Media: " + this.format);
            System.out.println("Number of channels " + this.channels);
            System.out.println("valid " + this.valid);
            System.out.println("ID " + this.ID);
            System.out.println("layer " + this.layer);
            System.out.println("protection " + this.protection);
            System.out.println("bitrate " + this.bitRate);
            System.out.println("sample rate " + this.sampleRate);
            System.out.println("Mode " + this.mode + " ext " + this.modeExt);
            System.out.println("copyright " + this.copyright);
            System.out.println("original " + this.original);
            System.out.println("emphasis " + this.emphasis);
            System.out.println("channels " + this.channels);
            return super.toString();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private abstract class Media {
        private Media() {
        }

        abstract Format createFormat();
    }
}

