/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Point2D;

public class PPanEventHandler
extends PDragSequenceEventHandler {
    private static final int DEFAULT_MAX_AUTOPAN_SPEED = 750;
    private static final int DEFAULT_MIN_AUTOPAN_SPEED = 250;
    private boolean autopan;
    private double minAutopanSpeed = 250.0;
    private double maxAutopanSpeed = 750.0;

    public PPanEventHandler() {
        this.setEventFilter(new PInputEventFilter(16));
        this.setAutopan(true);
    }

    protected void drag(PInputEvent event) {
        super.drag(event);
        this.pan(event);
    }

    protected void pan(PInputEvent event) {
        PCamera c2 = event.getCamera();
        Point2D l2 = event.getPosition();
        if (c2.getViewBounds().contains(l2)) {
            PDimension d2 = event.getDelta();
            c2.translateView(d2.getWidth(), d2.getHeight());
        }
    }

    public void setAutopan(boolean autopan) {
        this.autopan = autopan;
    }

    public boolean getAutopan() {
        return this.autopan;
    }

    public void setMinAutopanSpeed(double minAutopanSpeed) {
        this.minAutopanSpeed = minAutopanSpeed;
    }

    public void setMaxAutopanSpeed(double maxAutopanSpeed) {
        this.maxAutopanSpeed = maxAutopanSpeed;
    }

    public double getMinAutoPanSpeed() {
        return this.minAutopanSpeed;
    }

    public double getMaxAutoPanSpeed() {
        return this.maxAutopanSpeed;
    }

    protected void dragActivityStep(PInputEvent event) {
        if (!this.autopan) {
            return;
        }
        PCamera c2 = event.getCamera();
        PBounds b2 = c2.getBoundsReference();
        Point2D l2 = event.getPositionRelativeTo(c2);
        int outcode = b2.outcode(l2);
        PDimension delta = new PDimension();
        if ((outcode & 2) != 0) {
            delta.height = this.validatePanningSpeed(-1.0 - 0.5 * Math.abs(l2.getY() - b2.getY()));
        } else if ((outcode & 8) != 0) {
            delta.height = this.validatePanningSpeed(1.0 + 0.5 * Math.abs(l2.getY() - (b2.getY() + b2.getHeight())));
        }
        if ((outcode & 4) != 0) {
            delta.width = this.validatePanningSpeed(1.0 + 0.5 * Math.abs(l2.getX() - (b2.getX() + b2.getWidth())));
        } else if ((outcode & 1) != 0) {
            delta.width = this.validatePanningSpeed(-1.0 - 0.5 * Math.abs(l2.getX() - b2.getX()));
        }
        c2.localToView(delta);
        if (delta.width != 0.0 || delta.height != 0.0) {
            c2.translateView(delta.width, delta.height);
        }
    }

    protected double validatePanningSpeed(double delta) {
        double stepsPerSecond = 1000.0 / (double)this.getDragActivity().getStepRate();
        double minDelta = this.minAutopanSpeed / stepsPerSecond;
        double maxDelta = this.maxAutopanSpeed / stepsPerSecond;
        double absDelta = Math.abs(delta);
        double clippedDelta = absDelta < minDelta ? minDelta : (absDelta > maxDelta ? maxDelta : delta);
        if (delta < 0.0) {
            return -clippedDelta;
        }
        return clippedDelta;
    }
}

