/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.util.PNodeLocator;
import java.awt.geom.RectangularShape;

public class PBoundsLocator
extends PNodeLocator {
    private static final long serialVersionUID = 1L;
    private int side;

    public static PBoundsLocator createEastLocator(PNode node) {
        return new PBoundsLocator(node, 3);
    }

    public static PBoundsLocator createNorthEastLocator(PNode node) {
        return new PBoundsLocator(node, 2);
    }

    public static PBoundsLocator createNorthWestLocator(PNode node) {
        return new PBoundsLocator(node, 8);
    }

    public static PBoundsLocator createNorthLocator(PNode node) {
        return new PBoundsLocator(node, 1);
    }

    public static PBoundsLocator createSouthLocator(PNode node) {
        return new PBoundsLocator(node, 5);
    }

    public static PBoundsLocator createWestLocator(PNode node) {
        return new PBoundsLocator(node, 7);
    }

    public static PBoundsLocator createSouthWestLocator(PNode node) {
        return new PBoundsLocator(node, 6);
    }

    public static PBoundsLocator createSouthEastLocator(PNode node) {
        return new PBoundsLocator(node, 4);
    }

    public PBoundsLocator(PNode node, int aSide) {
        super(node);
        this.side = aSide;
    }

    public int getSide() {
        return this.side;
    }

    public void setSide(int side) {
        this.side = side;
    }

    public double locateX() {
        PBounds aBounds = this.node.getBoundsReference();
        switch (this.side) {
            case 6: 
            case 7: 
            case 8: {
                return ((RectangularShape)aBounds).getX();
            }
            case 2: 
            case 3: 
            case 4: {
                return ((RectangularShape)aBounds).getX() + ((RectangularShape)aBounds).getWidth();
            }
            case 1: 
            case 5: {
                return ((RectangularShape)aBounds).getX() + ((RectangularShape)aBounds).getWidth() / 2.0;
            }
        }
        return -1.0;
    }

    public double locateY() {
        PBounds aBounds = this.node.getBoundsReference();
        switch (this.side) {
            case 3: 
            case 7: {
                return ((RectangularShape)aBounds).getY() + ((RectangularShape)aBounds).getHeight() / 2.0;
            }
            case 4: 
            case 5: 
            case 6: {
                return ((RectangularShape)aBounds).getY() + ((RectangularShape)aBounds).getHeight();
            }
            case 1: 
            case 2: 
            case 8: {
                return ((RectangularShape)aBounds).getY();
            }
        }
        return -1.0;
    }
}

