/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public final class ShadowUtils {
    private static final int BLUR_BOUNDS_AFFORDANCE = 4;

    private ShadowUtils() {
    }

    public static BufferedImage createShadow(Image src, Paint shadowPaint, int blurRadius) {
        if (src == null) {
            throw new IllegalArgumentException("src image must not be null");
        }
        if (blurRadius < 1) {
            throw new IllegalArgumentException("blur radius must be greater than zero, was " + blurRadius);
        }
        int w = src.getWidth(null) + 4 * blurRadius;
        int h2 = src.getHeight(null) + 4 * blurRadius;
        BufferedImage mask = new BufferedImage(w, h2, 2);
        Graphics2D g2 = mask.createGraphics();
        g2.drawImage(src, 2 * blurRadius, 2 * blurRadius, null);
        g2.setComposite(AlphaComposite.SrcIn);
        g2.setPaint(shadowPaint);
        g2.fillRect(0, 0, w, h2);
        g2.dispose();
        ConvolveOp convolveOp = new ConvolveOp(new GaussianKernel(blurRadius));
        BufferedImage shadow = convolveOp.filter(mask, null);
        return shadow;
    }

    private static class GaussianKernel
    extends Kernel {
        GaussianKernel(int blurRadius) {
            super(2 * blurRadius + 1, 2 * blurRadius + 1, GaussianKernel.createKernel(blurRadius));
        }

        private static float[] createKernel(int r) {
            int w = 2 * r + 1;
            float[] kernel = new float[w * w];
            double m3 = 2.0 * Math.pow((double)r / 3.0, 2.0);
            double n2 = Math.PI * m3;
            double sum = 0.0;
            for (int x = 0; x < w; ++x) {
                int xr2 = (x - r) * (x - r);
                for (int y = 0; y < w; ++y) {
                    int yr2 = (y - r) * (y - r);
                    kernel[x * w + y] = (float)(Math.pow(Math.E, (double)(-(yr2 + xr2)) / m3) / n2);
                    sum += (double)kernel[x * w + y];
                }
            }
            int i2 = kernel.length - 1;
            while (i2 >= 0) {
                int n3 = i2--;
                kernel[n3] = (float)((double)kernel[n3] / sum);
            }
            return kernel;
        }
    }
}

