/*
 * Decompiled with CFR 0.152.
 */
package javax.media.bean.playerbean;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerAdapter;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.EndOfMediaEvent;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.TransitionEvent;
import javax.media.bean.playerbean.MediaPlayerResource;
import javax.media.format.FormatChangeEvent;
import javax.media.protocol.DataSource;

public class MediaPlayer
extends Container
implements Player,
Externalizable {
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private String urlString = "";
    private MediaLocator mrl;
    private URL url;
    private AppletContext mpAppletContext = null;
    private boolean panelVisible = true;
    private boolean cachingVisible = false;
    private boolean fixedAspectRatio = true;
    private boolean fitVideo = true;
    private boolean looping = true;
    transient Player player = null;
    transient Panel panel;
    transient Panel vPanel;
    transient Panel newPanel;
    transient Component visualComponent;
    transient Component controlComponent;
    transient Component cachingComponent;
    private transient int controlPanelHeight = 0;
    private transient int urlFieldHeight = 0;
    private int preferredHeight;
    private int preferredWidth;
    private int state;
    private Vector controlListeners = new Vector();
    PopupMenu zoomMenu = null;
    private URL mpCodeBase = null;
    protected transient GainControl gainControl;
    protected transient String curVolumeLevel = MediaPlayerResource.getString("THREE");
    protected transient float curVolumeValue = 0.6f;
    protected transient String curZoomLevel = MediaPlayerResource.getString("SCALE_NORMAL");
    protected transient float curZoomValue = 1.0f;
    protected transient Time mediaTime;
    private InternalControllerAdapter selfListener;
    private long contentLength = 0L;
    private boolean fixtedFirstTime = true;
    private boolean displayURL = false;
    private boolean isPopupActive = true;
    private transient TextField urlName;
    private transient visualMouseAdapter mouseListen;
    Method errMeth = null;

    public MediaPlayer() {
        this.setLayout(null);
        if (this.panel == null) {
            this.panel = new Panel();
            this.panel.setLayout(new BorderLayout());
            this.panel.setVisible(false);
            this.add("Center", this.panel);
        }
    }

    private synchronized void doRealize() {
        this.debug("in doRealize");
        if (this.player == null) {
            this.Fatal(MediaPlayerResource.getString("SHOULD NOT OCCUR"));
            System.exit(-1);
        }
        this.gainControl = this.player.getGainControl();
        if (this.gainControl != null) {
            float f2 = this.gainControl.setLevel(this.curVolumeValue);
        }
        if ((this.visualComponent = this.player.getVisualComponent()) != null) {
            this.vPanel = new Panel();
            this.vPanel.setLayout(new BorderLayout());
            this.panel.setVisible(false);
            this.visualComponent.setVisible(false);
            this.vPanel.add("Center", this.visualComponent);
            this.panel.add("Center", this.vPanel);
            this.addComponentListener(new visualComponentAdapter(this));
            this.addPopupMenu(this.visualComponent);
            this.setPopupActive();
        }
        this.newPanel = new Panel();
        this.newPanel.setLayout(new BorderLayout());
        this.panel.add("South", this.newPanel);
        this.urlName = new TextField(10);
        this.urlName.setEditable(false);
        if (this.displayURL) {
            this.urlName.setText(this.urlString);
            this.newPanel.add("South", this.urlName);
        }
        if ((this.controlComponent = this.player.getControlPanelComponent()) != null && this.isControlPanelVisible()) {
            this.controlComponent.setVisible(false);
            this.newPanel.add("North", this.controlComponent);
        }
        this.calculateSize();
        if (this.visualComponent == null) {
            if (this.controlComponent != null) {
                this.panel.setSize(this.controlComponent.getPreferredSize().width, this.controlPanelHeight + this.urlFieldHeight);
            } else {
                this.panel.setSize(100, this.urlFieldHeight);
            }
        }
        this.showVisual();
    }

    private void calculateSize() {
        if (this.player == null) {
            return;
        }
        this.debug("claculateSize");
        this.visualComponent = this.player.getVisualComponent();
        if (this.visualComponent != null) {
            this.preferredHeight = this.visualComponent.getPreferredSize().height;
            this.preferredWidth = this.visualComponent.getPreferredSize().width;
        }
        if ((this.controlComponent = this.player.getControlPanelComponent()) != null && this.isControlPanelVisible() || this.displayURL) {
            if (this.controlComponent != null && this.isControlPanelVisible()) {
                this.controlPanelHeight = this.controlComponent.getPreferredSize().height;
                this.preferredHeight += this.controlPanelHeight;
                if (this.preferredWidth == 0) {
                    this.preferredWidth = 320;
                }
            }
            if (this.displayURL) {
                this.urlFieldHeight = this.urlName.getPreferredSize().height;
                this.preferredHeight += this.urlFieldHeight;
            }
        }
        if (this.visualComponent != null) {
            Dimension vSize = this.visualComponent.getPreferredSize();
            int totalHeight = 0;
            if (this.controlComponent != null) {
                totalHeight += this.controlComponent.getPreferredSize().height;
            }
            if (this.displayURL) {
                totalHeight += this.urlName.getPreferredSize().height;
            }
            if (this.fixedAspectRatio && (double)this.curZoomValue == 1.0) {
                if (vSize.width != 0 && vSize.height != 0) {
                    this.curZoomValue = (float)this.getSize().width / (float)vSize.width >= (float)(this.getSize().height - totalHeight) / (float)vSize.height ? (float)(this.getSize().height - totalHeight) / (float)vSize.height : (float)this.getSize().width / (float)vSize.width;
                }
                if ((double)this.curZoomValue < 0.5) {
                    this.curZoomValue = 1.0f;
                }
            }
            if (this.newPanel != null) {
                this.newPanel.setSize(this.visualComponent.getPreferredSize().width, this.controlPanelHeight + this.urlFieldHeight);
            }
        }
    }

    private synchronized void showVisual() {
        if (this.cachingComponent != null) {
            this.panel.remove(this.cachingComponent);
            this.validate();
        }
        if (this.visualComponent != null && (this.fixedAspectRatio || !this.fixtedFirstTime)) {
            this.zoomTo(this.curZoomValue);
        } else {
            this.panel.setSize(this.getSize());
        }
        this.panel.setVisible(true);
        if (this.visualComponent != null) {
            this.visualComponent.setVisible(true);
        }
        if (this.controlComponent != null && this.isControlPanelVisible()) {
            this.controlComponent.setVisible(true);
        }
        this.panel.validate();
        this.validate();
    }

    private void initSetCodeBase() {
        if (this.mpCodeBase != null) {
            return;
        }
        Container p = this.getParent();
        while (p != null) {
            if (p instanceof Applet) break;
            p = p.getParent();
        }
        if (p != null) {
            this.setCodeBase(((Applet)p).getCodeBase());
            this.mpAppletContext = ((Applet)p).getAppletContext();
        }
    }

    public String getMediaLocation() {
        if (this.mrl != null) {
            return this.mrl.toString();
        }
        return this.urlString;
    }

    protected MediaLocator getMediaLocator(String filename) {
        MediaLocator localml = null;
        if (filename.regionMatches(true, 0, "<codebase>", 0, 10)) {
            try {
                if (this.mpCodeBase == null) {
                    this.initSetCodeBase();
                }
                localml = new MediaLocator(new URL(this.mpCodeBase, filename.substring(11)));
            }
            catch (MalformedURLException e2) {
                if (this.mpCodeBase != null) {
                    this.log(MediaPlayerResource.getString("NO IMAGE:BAD_URL") + filename + " " + this.mpCodeBase);
                    this.urlString = " ";
                }
                return null;
            }
        } else {
            localml = new MediaLocator(filename);
        }
        return localml;
    }

    public void setMediaLocation(String location) {
        try {
            String old = "";
            if (this.mrl != null) {
                old = this.mrl.toExternalForm();
                if (this.panel != null) {
                    this.panel.removeAll();
                }
                if (this.player != null) {
                    this.player.stop();
                    this.player.close();
                    this.panel.validate();
                    if (this.controlListeners.contains(this.selfListener)) {
                        this.controlListeners.removeElement(this.selfListener);
                    }
                }
            }
            this.urlString = location;
            this.mrl = this.getMediaLocator(location);
            if (this.mrl == null) {
                return;
            }
            try {
                this.player = Manager.createPlayer(this.mrl);
            }
            catch (Exception e2) {
                this.player = null;
                this.urlString = " ";
                this.changes.firePropertyChange("mediaLocation", location, old);
                this.Fatal(MediaPlayerResource.getString("UNABLE_CREATE_PLAYER") + e2);
                return;
            }
            if (this.player == null) {
                return;
            }
            if (this.urlName != null) {
                this.urlName.setText(this.urlString);
                this.urlName.setFont(this.getFont());
            }
            this.selfListener = new InternalControllerAdapter(this);
            this.player.addControllerListener(this.selfListener);
            if (!this.controlListeners.isEmpty()) {
                int i2 = 0;
                while (i2 < this.controlListeners.size()) {
                    this.player.addControllerListener((ControllerListener)this.controlListeners.elementAt(i2));
                    ++i2;
                }
            }
            this.changes.firePropertyChange("mediaLocation", old, location);
        }
        catch (Exception e3) {
            this.mrl = null;
            e3.printStackTrace();
            this.Fatal(MediaPlayerResource.getString("UNABLE_CREATE_PLAYER") + e3);
            return;
        }
    }

    public void setMediaLocator(MediaLocator locator) {
        try {
            this.debug("setMediaLocator");
            if (locator != null) {
                if (this.mrl != null) {
                    if (this.panel != null) {
                        this.panel.removeAll();
                    }
                    if (this.player != null) {
                        this.player.stop();
                        this.player.close();
                        if (this.controlListeners.contains(this.selfListener)) {
                            this.controlListeners.removeElement(this.selfListener);
                        }
                    }
                }
            } else {
                return;
            }
            try {
                this.player = Manager.createPlayer(locator);
            }
            catch (NoPlayerException e2) {
                this.player = null;
                this.urlString = " ";
                this.Fatal(MediaPlayerResource.getString("UNABLE_CREATE_PLAYER") + e2);
                return;
            }
            catch (IOException e3) {
                this.player = null;
                this.urlString = " ";
                this.Fatal(MediaPlayerResource.getString("IO_EXCEPTION") + e3);
                return;
            }
            if (this.player == null) {
                return;
            }
            this.urlString = locator.toExternalForm();
            this.mrl = locator;
            if (this.urlName != null) {
                this.urlName.setText(this.urlString);
                this.urlName.setFont(this.getFont());
            }
            this.selfListener = new InternalControllerAdapter(this);
            this.player.addControllerListener(this.selfListener);
            if (!this.controlListeners.isEmpty()) {
                int i2 = 0;
                while (i2 < this.controlListeners.size()) {
                    this.player.addControllerListener((ControllerListener)this.controlListeners.elementAt(i2));
                    ++i2;
                }
            }
        }
        catch (Exception e4) {
            this.url = null;
            e4.printStackTrace();
            this.Fatal(MediaPlayerResource.getString("UNABLE_CREATE_PLAYER") + e4);
            return;
        }
    }

    public void setDataSource(DataSource ds) {
        try {
            this.debug("setDataSource");
            if (ds != null) {
                if (this.panel != null) {
                    this.panel.removeAll();
                }
                if (this.player != null) {
                    this.player.stop();
                    if (this.controlListeners.contains(this.selfListener)) {
                        this.controlListeners.removeElement(this.selfListener);
                    }
                }
            }
            if (this.urlName != null) {
                if (ds.getLocator() != null) {
                    this.urlName.setText(ds.getLocator().toExternalForm());
                } else {
                    this.urlName.setText("");
                }
                this.urlName.setFont(this.getFont());
            }
            try {
                this.player = Manager.createPlayer(ds);
            }
            catch (Exception e2) {
                this.player = null;
                this.urlString = " ";
                this.Fatal(MediaPlayerResource.getString("UNABLE_CREATE_PLAYER") + e2);
                return;
            }
            if (this.player == null) {
                return;
            }
            this.urlString = ds.getLocator() != null ? ds.getLocator().toExternalForm() : "";
            this.selfListener = new InternalControllerAdapter(this);
            this.player.addControllerListener(this.selfListener);
            if (!this.controlListeners.isEmpty()) {
                int i2 = 0;
                while (i2 < this.controlListeners.size()) {
                    this.player.addControllerListener((ControllerListener)this.controlListeners.elementAt(i2));
                    ++i2;
                }
            }
        }
        catch (Exception e3) {
            this.mrl = null;
            e3.printStackTrace();
            this.Fatal(MediaPlayerResource.getString("UNABLE_CREATE_PLAYER") + e3);
            return;
        }
    }

    public void setPlayer(Player newPlayer) {
        this.debug("setPlayer");
        if (newPlayer == null) {
            return;
        }
        if (newPlayer != null) {
            if (this.panel != null) {
                this.panel.removeAll();
            }
            if (this.player != null) {
                this.player.stop();
                if (this.controlListeners.contains(this.selfListener)) {
                    this.controlListeners.removeElement(this.selfListener);
                }
            }
        }
        this.player = newPlayer;
        this.urlString = "";
        this.selfListener = new InternalControllerAdapter(this);
        this.player.addControllerListener(this.selfListener);
        switch (this.player.getState()) {
            case 500: {
                this.debug("player state prefetched ");
                break;
            }
            case 400: {
                this.debug("player state prefetching ");
                break;
            }
            case 300: {
                this.debug("player state Realized ");
                break;
            }
            case 200: {
                this.debug("player state  Realizing");
                break;
            }
            case 600: {
                this.debug("player state started ");
                break;
            }
            case 100: {
                this.debug("player state Unrealized ");
            }
        }
        if (this.player.getState() == 300 || this.player.getState() == 400) {
            this.doRealize();
        }
        if (this.player.getState() == 500 || this.player.getState() == 600) {
            this.doRealize();
        }
        if (!this.controlListeners.isEmpty()) {
            int i2 = 0;
            while (i2 < this.controlListeners.size()) {
                this.player.addControllerListener((ControllerListener)this.controlListeners.elementAt(i2));
                ++i2;
            }
        }
    }

    public boolean getPlaybackLoop() {
        return this.looping;
    }

    public void setPlaybackLoop(boolean val) {
        boolean old = this.looping;
        this.looping = val;
        this.changes.firePropertyChange("playbackLoop", new Boolean(old), new Boolean(this.looping));
    }

    public boolean isPlayBackLoop() {
        return this.looping;
    }

    public void setZoomTo(String scale) {
        this.debug("setZoomTo");
        this.curZoomLevel = scale;
        if (scale.trim().equals(MediaPlayerResource.getString("1:2"))) {
            this.curZoomValue = 0.5f;
        } else if (scale.trim().equals(MediaPlayerResource.getString("1:1"))) {
            this.curZoomValue = 1.0f;
        } else if (scale.trim().equals(MediaPlayerResource.getString("2:1"))) {
            this.curZoomValue = 2.0f;
        } else if (scale.trim().equals(MediaPlayerResource.getString("4:1"))) {
            this.curZoomValue = 4.0f;
        }
        this.fixtedFirstTime = false;
        this.zoomTo(this.curZoomValue);
    }

    public String getZoomTo() {
        return this.curZoomLevel;
    }

    public int getControlPanelHeight() {
        if (this.isControlPanelVisible()) {
            return this.controlPanelHeight;
        }
        return 0;
    }

    public int getMediaLocationHeight() {
        if (this.isMediaLocationVisible()) {
            return this.urlFieldHeight;
        }
        return 0;
    }

    public void setVolumeLevel(String volumeString) {
        this.debug("in setVolumeLevel");
        if (volumeString == null) {
            return;
        }
        String old = this.curVolumeLevel;
        int level = Integer.parseInt(volumeString);
        this.curVolumeLevel = volumeString;
        this.curVolumeValue = (float)level * 0.2f;
        if (this.gainControl != null) {
            this.gainControl.setLevel(this.curVolumeValue);
        }
        this.changes.firePropertyChange("volumeLevel", old, this.curVolumeLevel);
    }

    public String getVolumeLevel() {
        return this.curVolumeLevel;
    }

    public boolean isMediaLocationVisible() {
        return this.displayURL;
    }

    public void setMediaLocationVisible(boolean val) {
        if (this.displayURL != val) {
            if (this.urlName != null) {
                if (val) {
                    this.urlName.setText(this.urlString);
                    this.newPanel.add("South", this.urlName);
                } else {
                    this.newPanel.remove(this.urlName);
                }
            }
            this.panel.validate();
            this.validate();
            this.displayURL = val;
        }
    }

    public boolean isControlPanelVisible() {
        return this.panelVisible;
    }

    public void setControlPanelVisible(boolean isVisible) {
        if (this.panelVisible != isVisible) {
            boolean old = this.panelVisible;
            if (this.controlComponent != null) {
                if (isVisible) {
                    this.panel.add("South", this.controlComponent);
                } else {
                    this.panel.remove(this.controlComponent);
                }
            }
            this.invalidate();
            this.validate();
            this.panelVisible = isVisible;
            this.changes.firePropertyChange("controlPanelVisible", new Boolean(old), new Boolean(this.panelVisible));
        }
    }

    public boolean isCachingControlVisible() {
        return this.cachingVisible;
    }

    public void setCachingControlVisible(boolean isVisible) {
        if (this.cachingVisible != isVisible) {
            boolean old = this.cachingVisible;
            if (this.cachingComponent != null) {
                if (isVisible) {
                    this.panel.add("South", this.cachingComponent);
                } else {
                    this.panel.remove(this.cachingComponent);
                }
            }
            this.invalidate();
            this.validate();
            this.changes.firePropertyChange("cachingControlVisible", new Boolean(old), new Boolean(this.cachingVisible));
        }
        this.cachingVisible = isVisible;
    }

    public boolean isFixedAspectRatio() {
        return this.fixedAspectRatio;
    }

    public void setFixedAspectRatio(boolean isFixed) {
        boolean old = this.fixedAspectRatio;
        this.fixedAspectRatio = isFixed;
        this.changes.firePropertyChange("fixedAspectRatio", new Boolean(old), new Boolean(this.fixedAspectRatio));
    }

    public void setPopupActive(boolean isActive) {
        if (isActive != this.isPopupActive) {
            this.isPopupActive = isActive;
            this.setPopupActive();
        }
    }

    private void setPopupActive() {
        if (this.isPopupActive) {
            this.mouseListen = new visualMouseAdapter();
            this.visualComponent.addMouseListener(this.mouseListen);
        } else if (this.mouseListen != null) {
            this.visualComponent.removeMouseListener(this.mouseListen);
        }
    }

    public Component getVisualComponent() {
        if (this.player != null) {
            return this.player.getVisualComponent();
        }
        return null;
    }

    public GainControl getGainControl() {
        if (this.player != null) {
            return this.player.getGainControl();
        }
        return null;
    }

    public Component getControlPanelComponent() {
        if (this.player != null) {
            return this.player.getControlPanelComponent();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        if (this.player != null) {
            this.player.start();
            return;
        } else {
            if (this.mrl == null) {
                this.initSetCodeBase();
                this.mrl = this.getMediaLocator(this.urlString);
            }
            if (this.mrl != null) {
                try {
                    this.player = Manager.createPlayer(this.mrl);
                    this.selfListener = new InternalControllerAdapter(this);
                    this.player.addControllerListener(this.selfListener);
                    this.start();
                    if (this.controlListeners.size() <= 0) return;
                    int i2 = 0;
                    while (i2 < this.controlListeners.size()) {
                        this.player.addControllerListener((ControllerListener)this.controlListeners.elementAt(i2));
                        ++i2;
                    }
                    return;
                }
                catch (Exception e2) {
                    this.player = null;
                    this.urlString = " ";
                    this.Fatal(MediaPlayerResource.getString("UNABLE_CREATE_PLAYER") + e2);
                    return;
                }
            } else {
                this.Fatal(MediaPlayerResource.getString("COULD_NOT_START_PLAYER"));
            }
        }
    }

    public void addController(Controller n2) {
        try {
            if (this.player != null) {
                this.player.addController(n2);
            }
        }
        catch (IncompatibleTimeBaseException e2) {
            this.Fatal(MediaPlayerResource.getString("PLAYER_NO_COMPATIBLE_TIME_BASE"));
            return;
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public void removeController(Controller old) {
        if (this.player != null) {
            this.player.removeController(old);
        }
    }

    public void setSource(DataSource data) {
        try {
            if (this.player != null) {
                this.player.setSource(data);
            }
        }
        catch (IOException e2) {
            this.Fatal(MediaPlayerResource.getString("IO_EXCEPTION") + e2);
            return;
        }
        catch (IncompatibleSourceException e3) {
            this.Fatal(MediaPlayerResource.getString("INCOMPATIBLE_SOURCE_EXCEPTION") + e3);
            return;
        }
    }

    public int getState() {
        if (this.player != null) {
            return this.player.getState();
        }
        return 100;
    }

    public int getTargetState() {
        if (this.player != null) {
            return this.player.getTargetState();
        }
        return 100;
    }

    public void realize() {
        if (this.player == null) {
            return;
        }
        this.player.realize();
    }

    public void prefetch() {
        if (this.player == null) {
            return;
        }
        this.player.prefetch();
    }

    public void deallocate() {
        if (this.player == null) {
            return;
        }
        this.debug("in deallocate");
        this.player.deallocate();
    }

    public void close() {
        if (this.player == null) {
            return;
        }
        this.panel.removeAll();
        this.player.close();
        this.player = null;
    }

    public Time getStartLatency() {
        if (this.player != null) {
            return this.player.getStartLatency();
        }
        return Controller.LATENCY_UNKNOWN;
    }

    public Control[] getControls() {
        if (this.player != null) {
            return this.player.getControls();
        }
        return new Control[0];
    }

    public Control getControl(String forName) {
        if (this.player != null) {
            return this.player.getControl(forName);
        }
        return null;
    }

    public void addControllerListener(ControllerListener listener) {
        if (this.player != null) {
            this.player.addControllerListener(listener);
        }
        if (!this.controlListeners.contains(listener)) {
            this.controlListeners.addElement(listener);
        }
    }

    public void removeControllerListener(ControllerListener listener) {
        if (this.player != null) {
            this.player.removeControllerListener(listener);
        }
        if (this.controlListeners.contains(listener)) {
            this.controlListeners.removeElement(listener);
        }
    }

    public void setTimeBase(TimeBase master) {
        try {
            if (this.player != null) {
                this.player.setTimeBase(master);
            }
        }
        catch (IncompatibleTimeBaseException e2) {
            this.Fatal(MediaPlayerResource.getString("INCOMPATIBLE_TIME_BASE") + e2);
            return;
        }
    }

    public void syncStart(Time at) {
        this.debug("syncStart ");
        if (this.player != null) {
            this.player.syncStart(at);
        }
    }

    public void stop() {
        if (this.player != null) {
            this.player.stop();
        }
    }

    public void stopAndDeallocate() {
        if (this.player != null) {
            this.player.stop();
        }
    }

    public void setStopTime(Time stopTime) {
        if (this.player != null) {
            this.player.setStopTime(stopTime);
        }
    }

    public Time getStopTime() {
        if (this.player != null) {
            return this.player.getStopTime();
        }
        return null;
    }

    public void setMediaTime(Time now) {
        if (this.player != null) {
            this.player.setMediaTime(now);
        }
    }

    public Time getMediaTime() {
        if (this.player != null) {
            return this.player.getMediaTime();
        }
        return Controller.LATENCY_UNKNOWN;
    }

    public long getMediaNanoseconds() {
        if (this.player != null) {
            return this.player.getMediaNanoseconds();
        }
        return Long.MAX_VALUE;
    }

    public Time getSyncTime() {
        if (this.player != null) {
            return this.player.getSyncTime();
        }
        return Controller.LATENCY_UNKNOWN;
    }

    public TimeBase getTimeBase() {
        if (this.player != null) {
            return this.player.getTimeBase();
        }
        return null;
    }

    public Time mapToTimeBase(Time t) {
        try {
            if (this.player != null) {
                return this.player.mapToTimeBase(t);
            }
        }
        catch (ClockStoppedException e2) {
            this.log(MediaPlayerResource.getString("CALL_A_STOPPED_CLOCK"));
        }
        return Controller.LATENCY_UNKNOWN;
    }

    public float getRate() {
        if (this.player != null) {
            return this.player.getRate();
        }
        return 0.0f;
    }

    public float setRate(float factor) {
        if (this.player != null) {
            return this.player.setRate(factor);
        }
        return 0.0f;
    }

    public Time getDuration() {
        if (this.player != null) {
            return this.player.getDuration();
        }
        return Duration.DURATION_UNKNOWN;
    }

    public synchronized void waitForState(int s2) {
        while (this.state != s2) {
            try {
                this.wait(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void Fatal(String name) {
        try {
            if (this.errMeth == null) {
                Class<?> cls = Class.forName("com.sun.media.Log");
                Class[] params = new Class[]{Class.forName("java.lang.Object")};
                this.errMeth = cls.getMethod("error", params);
            }
            Object[] args = new Object[]{name};
            this.errMeth.invoke(null, args);
        }
        catch (Throwable t) {
            System.err.println(name);
        }
    }

    private void log(String name) {
        try {
            if (this.errMeth == null) {
                Class<?> cls = Class.forName("com.sun.media.Log");
                Class[] params = new Class[]{Class.forName("java.lang.Object")};
                this.errMeth = cls.getMethod("comment", params);
            }
            Object[] args = new Object[]{name};
            this.errMeth.invoke(null, args);
        }
        catch (Throwable t) {
            System.err.println(name);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setBounds((Rectangle)in.readObject());
        this.setBackground((Color)in.readObject());
        this.setForeground((Color)in.readObject());
        this.setFont((Font)in.readObject());
        this.setVisible(in.readBoolean());
        this.setEnabled(in.readBoolean());
        String n2 = (String)in.readObject();
        if (n2 != null) {
            this.mrl = new MediaLocator(n2);
        }
        if (this.mrl != null) {
            try {
                this.setMediaLocator(this.mrl);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        this.setMediaLocationVisible(in.readBoolean());
        this.panelVisible = in.readBoolean();
        this.cachingVisible = in.readBoolean();
        this.fixedAspectRatio = in.readBoolean();
        this.preferredHeight = in.readInt();
        this.preferredWidth = in.readInt();
        if (in.readBoolean()) {
            int s2 = in.readInt();
            int ts = in.readInt();
            this.state = 100;
            if (s2 >= 300) {
                long mt = in.readLong();
                long st = in.readLong();
                float r = in.readFloat();
                if (ts >= 500) {
                    this.player.prefetch();
                    this.waitForState(500);
                } else if (ts >= 300) {
                    this.player.realize();
                    this.waitForState(300);
                }
                this.player.setMediaTime(new Time(mt));
                this.player.setStopTime(new Time(st));
                this.player.setRate(r);
                float l2 = in.readFloat();
                if (l2 != -1.0f) {
                    GainControl g2 = this.player.getGainControl();
                    if (g2 != null) {
                        boolean mute = in.readBoolean();
                        g2.setLevel(l2);
                        g2.setMute(mute);
                    } else {
                        in.readBoolean();
                    }
                }
                if (ts >= 600) {
                    this.player.start();
                }
            }
        }
        this.invalidate();
        this.validate();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getBounds());
        out.writeObject(this.getBackground());
        out.writeObject(this.getForeground());
        out.writeObject(this.getFont());
        out.writeBoolean(this.isVisible());
        out.writeBoolean(this.isEnabled());
        if (this.mrl != null) {
            out.writeObject(this.mrl.toExternalForm());
        } else {
            out.writeObject(null);
        }
        out.writeBoolean(this.displayURL);
        out.writeBoolean(this.panelVisible);
        out.writeBoolean(this.cachingVisible);
        out.writeBoolean(this.fixedAspectRatio);
        out.writeInt(this.preferredHeight);
        out.writeInt(this.preferredWidth);
        if (this.player == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.player.getState());
            out.writeInt(this.player.getTargetState());
            if (this.player.getState() >= 300) {
                out.writeLong(this.player.getMediaNanoseconds());
                out.writeLong(this.player.getStopTime().getNanoseconds());
                out.writeFloat(this.player.getRate());
                GainControl g2 = this.player.getGainControl();
                if (g2 != null) {
                    out.writeFloat(g2.getLevel());
                    out.writeBoolean(g2.getMute());
                } else {
                    out.writeFloat(-1.0f);
                }
            }
        }
    }

    private void zoomTo(float z) {
        this.debug("zoomTo " + z);
        int ddwidth = 0;
        int ddheight = 0;
        if (this.visualComponent != null && this.fitVideo) {
            try {
                Dimension d2 = this.visualComponent.getPreferredSize();
                ddwidth = (int)((float)d2.width * z);
                ddheight = (int)((float)d2.height * z);
                int dheight = 0;
                if (this.controlComponent != null && this.isControlPanelVisible()) {
                    dheight = this.controlComponent.getPreferredSize().height;
                }
                if (this.displayURL) {
                    dheight += this.urlName.getPreferredSize().height;
                }
                if (this.newPanel != null) {
                    this.newPanel.setSize(ddwidth, dheight);
                }
                this.panel.setSize(ddwidth, ddheight + dheight);
                if (this.fixedAspectRatio || !this.fixedAspectRatio && !this.fixtedFirstTime) {
                    this.center(this, this.panel, true, dheight);
                } else {
                    this.center(this, this.panel, false, dheight);
                }
                this.panel.validate();
            }
            catch (Exception e2) {
                this.log(MediaPlayerResource.getString("UNABLE_TO_ZOOM") + e2);
            }
        }
    }

    private float aspectRatio(float width, float height, int controllerHeight) {
        return width / (height - (float)controllerHeight);
    }

    private void center(Container parent, Panel comp, boolean fit, int dheight) {
        int pwidth = parent.getSize().width;
        int pheight = parent.getSize().height;
        int width = comp.getSize().width;
        int height = comp.getSize().height;
        if (fit) {
            float aspect = this.aspectRatio(width, height, dheight);
            if (width > pwidth) {
                height = (int)((float)pwidth / aspect) + dheight;
                if (height > pheight) {
                    width = (int)(aspect * (float)(pheight - dheight));
                    height = pheight;
                } else {
                    width = pwidth;
                }
                comp.setBounds(parent.getBounds().x, parent.getBounds().y, width, height);
            } else if (height > pheight) {
                width = (int)(aspect * (float)(pheight - dheight));
                height = pheight;
                comp.setBounds(parent.getBounds().x, parent.getBounds().y, width, height);
            }
        }
        comp.setLocation(pwidth / 2 - width / 2, pheight / 2 - height / 2);
        comp.setSize(width, height);
    }

    private void addPopupMenu(Component visual) {
        this.zoomMenu = new PopupMenu("Zoom");
        popupActionListener zoomSelect = new popupActionListener();
        visual.add(this.zoomMenu);
        MenuItem mi = new MenuItem("Scale 1:2");
        this.zoomMenu.add(mi);
        mi.addActionListener(zoomSelect);
        mi = new MenuItem("Scale 1:1");
        this.zoomMenu.add(mi);
        mi.addActionListener(zoomSelect);
        mi = new MenuItem("Scale 2:1");
        this.zoomMenu.add(mi);
        mi.addActionListener(zoomSelect);
        mi = new MenuItem("Scale 4:1");
        this.zoomMenu.add(mi);
        mi.addActionListener(zoomSelect);
    }

    public void setBounds(int x, int y, int w, int h2) {
        this.debug("setBounds " + x + " " + y + " " + w + " " + h2 + " ");
        super.setBounds(x, y, w, h2);
        Dimension d2 = this.getSize();
        int pheight = d2.height;
        int pwidth = d2.width;
        boolean p = false;
        int totalHeight = 0;
        if (this.urlName != null && this.isMediaLocationVisible()) {
            totalHeight = this.urlFieldHeight = this.urlName.getPreferredSize().height;
            if (pheight < 5 && this.displayURL) {
                pheight = 5;
            }
        }
        if (this.controlComponent != null && this.isControlPanelVisible()) {
            this.controlPanelHeight = this.controlComponent.getPreferredSize().height;
            totalHeight += this.controlPanelHeight;
            if (d2.width < 160) {
                d2.width = 160;
            }
            if (pheight < 2 && this.visualComponent != null) {
                pheight += 2;
            }
        }
        if (this.visualComponent != null) {
            Dimension vSize = this.visualComponent.getPreferredSize();
            if (this.fixedAspectRatio) {
                this.curZoomValue = (float)pwidth / (float)vSize.width >= (float)(pheight - totalHeight) / (float)(vSize.height - totalHeight) ? (float)(pheight - totalHeight) / (float)(vSize.height - totalHeight) : (float)pwidth / (float)vSize.width;
                if ((double)this.curZoomValue < 1.0) {
                    this.curZoomValue = 1.0f;
                }
                this.zoomTo(this.curZoomValue);
            } else {
                this.panel.setBounds(this.getBounds());
            }
        } else {
            this.panel.setSize(this.getSize());
            this.validate();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredWidth, this.preferredHeight);
    }

    public void addPropertyChangeListener(PropertyChangeListener c2) {
        this.changes.addPropertyChangeListener(c2);
    }

    public void removePropertyChangeListener(PropertyChangeListener c2) {
        this.changes.removePropertyChangeListener(c2);
    }

    public void setCodeBase(URL cb) {
        this.mpCodeBase = cb;
    }

    public void saveMediaTime() {
        this.mediaTime = this.getMediaTime();
    }

    public void restoreMediaTime() {
        this.setMediaTime(this.mediaTime);
    }

    private void debug(String s2) {
    }

    private class popupActionListener
    implements ActionListener {
        private popupActionListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            String action = ae.getActionCommand();
            MediaPlayer.this.setZoomTo(action);
        }
    }

    private class visualMouseAdapter
    extends MouseAdapter {
        private visualMouseAdapter() {
        }

        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                MediaPlayer.this.zoomMenu.show(MediaPlayer.this.visualComponent, me.getX(), me.getY());
            }
        }

        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                MediaPlayer.this.zoomMenu.show(MediaPlayer.this.visualComponent, me.getX(), me.getY());
            }
        }

        public void mouseClicked(MouseEvent me) {
            if (me.isPopupTrigger()) {
                MediaPlayer.this.zoomMenu.show(MediaPlayer.this.visualComponent, me.getX(), me.getY());
            }
        }
    }

    private class visualComponentAdapter
    extends ComponentAdapter {
        private MediaPlayer thisBean;

        public visualComponentAdapter(MediaPlayer b2) {
            this.thisBean = b2;
        }

        public void componentResized(ComponentEvent ce) {
            if (ce.getSource() == this.thisBean) {
                MediaPlayer.this.debug("componentResized");
                int dheight = 0;
                if (MediaPlayer.this.controlComponent != null && MediaPlayer.this.isControlPanelVisible()) {
                    dheight = MediaPlayer.this.controlComponent.getPreferredSize().height;
                }
                MediaPlayer.this.center(this.thisBean, MediaPlayer.this.panel, MediaPlayer.this.isFixedAspectRatio(), dheight);
            }
        }
    }

    class InternalControllerAdapter
    extends ControllerAdapter {
        private MediaPlayer thisBean;

        public InternalControllerAdapter(MediaPlayer b2) {
            this.thisBean = b2;
        }

        public void replaceURL(Object e2) {
            MediaPlayer.this.debug("ReplaceURLEvent ");
            URL retobj = null;
            try {
                Class<?> cls = Class.forName("com.ibm.media.ReplaceURLEvent");
                Method meth = cls.getMethod("getURL", null);
                retobj = (URL)meth.invoke(e2, null);
            }
            catch (Throwable t) {
                System.err.println(t);
            }
            MediaPlayer.this.setMediaLocation(retobj.toExternalForm());
            this.thisBean.start();
        }

        public void showDocument(Object e2) {
            MediaPlayer.this.debug("ShowDocumentEvent ");
            MediaPlayer.this.initSetCodeBase();
            URL retURL = null;
            String retContext = null;
            try {
                Class<?> cls = Class.forName("com.ibm.media.ShowDocumentEvent");
                Method meth = cls.getMethod("getURL", null);
                retURL = (URL)meth.invoke(e2, null);
                meth = cls.getMethod("getString", null);
                retContext = (String)meth.invoke(e2, null);
            }
            catch (Throwable t) {
                System.err.println(t);
            }
            if (MediaPlayer.this.mpAppletContext != null) {
                MediaPlayer.this.mpAppletContext.showDocument(retURL, retContext);
            }
        }

        public void transition(TransitionEvent e2) {
            MediaPlayer.this.debug("TransitionEvent " + e2);
            MediaPlayer.this.state = e2.getCurrentState();
        }

        public void realizeComplete(RealizeCompleteEvent e2) {
            MediaPlayer.this.debug("  Event:  RealizeComplete");
            MediaPlayer.this.doRealize();
        }

        public void prefetchComplete(PrefetchCompleteEvent e2) {
            MediaPlayer.this.debug("  Event:prefetchComplete");
        }

        public void formatChange(FormatChangeEvent e2) {
            MediaPlayer.this.debug(" formatChangeevent");
            Component oldVisualComp = MediaPlayer.this.visualComponent;
            if (MediaPlayer.this.player == null) {
                MediaPlayer.this.Fatal(MediaPlayerResource.getString("SHOULD NOT OCCUR"));
                System.exit(-1);
            }
            if ((MediaPlayer.this.visualComponent = MediaPlayer.this.player.getVisualComponent()) != null) {
                if (oldVisualComp != MediaPlayer.this.visualComponent) {
                    if (oldVisualComp != null) {
                        oldVisualComp.remove(MediaPlayer.this.zoomMenu);
                        MediaPlayer.this.vPanel.remove(oldVisualComp);
                        MediaPlayer.this.panel.remove(MediaPlayer.this.vPanel);
                        Component oldComp = MediaPlayer.this.controlComponent;
                        if (oldComp != null && MediaPlayer.this.newPanel != null) {
                            MediaPlayer.this.newPanel.remove(oldComp);
                            if (MediaPlayer.this.displayURL) {
                                MediaPlayer.this.newPanel.remove(MediaPlayer.this.urlName);
                            }
                            MediaPlayer.this.panel.remove(MediaPlayer.this.newPanel);
                        }
                    }
                    MediaPlayer.this.doRealize();
                } else if (MediaPlayer.this.getMediaLocation().endsWith("mvr") || MediaPlayer.this.getMediaLocation().endsWith("MVR")) {
                    MediaPlayer.this.zoomTo(1.0f);
                }
            } else {
                Component oldComp = MediaPlayer.this.controlComponent;
                MediaPlayer.this.controlComponent = MediaPlayer.this.player.getControlPanelComponent();
                if (MediaPlayer.this.controlComponent != null && MediaPlayer.this.isControlPanelVisible()) {
                    if (oldComp != MediaPlayer.this.controlComponent) {
                        if (oldComp != null) {
                            MediaPlayer.this.newPanel.remove(oldComp);
                            if (MediaPlayer.this.displayURL) {
                                MediaPlayer.this.newPanel.remove(MediaPlayer.this.urlName);
                            }
                            MediaPlayer.this.panel.remove(MediaPlayer.this.newPanel);
                        }
                        MediaPlayer.this.doRealize();
                    }
                } else if (oldVisualComp != null && MediaPlayer.this.vPanel != null) {
                    oldVisualComp.remove(MediaPlayer.this.zoomMenu);
                    MediaPlayer.this.vPanel.remove(oldVisualComp);
                    MediaPlayer.this.panel.remove(MediaPlayer.this.vPanel);
                }
            }
        }

        public void start(StartEvent e2) {
            MediaPlayer.this.debug("  Event:StartEvent ");
        }

        public void endOfMedia(EndOfMediaEvent e2) {
            MediaPlayer.this.debug("  Event:EndofMediaEvent");
            if (MediaPlayer.this.isPlayBackLoop()) {
                InternalControllerAdapter internalControllerAdapter = this;
                synchronized (internalControllerAdapter) {
                    if (MediaPlayer.this.player == null) {
                        MediaPlayer.this.Fatal(MediaPlayerResource.getString("SHOULD NOT OCCUR"));
                        System.exit(-1);
                    }
                    if (MediaPlayer.this.player != null) {
                        MediaPlayer.this.player.setMediaTime(new Time(0L));
                    }
                    if (MediaPlayer.this.player != null) {
                        MediaPlayer.this.player.start();
                    }
                }
            }
        }

        public void controllerError(ControllerErrorEvent e2) {
            MediaPlayer.this.debug("  Event:ControllerErrorEvent");
            MediaPlayer.this.player = null;
            MediaPlayer.this.Fatal(e2.getMessage());
        }

        public void sizeChange(SizeChangeEvent e2) {
            MediaPlayer.this.debug("  Event:SizeChangeEvent");
            int newPanelHeight = 0;
            if (MediaPlayer.this.controlComponent != null && MediaPlayer.this.isControlPanelVisible()) {
                newPanelHeight = MediaPlayer.this.controlPanelHeight;
            }
            if (MediaPlayer.this.urlName != null && MediaPlayer.this.isMediaLocationVisible()) {
                newPanelHeight += MediaPlayer.this.urlFieldHeight;
            }
            if (MediaPlayer.this.visualComponent != null) {
                MediaPlayer.this.visualComponent.setSize(e2.getWidth(), e2.getHeight());
                MediaPlayer.this.preferredHeight = MediaPlayer.this.visualComponent.getPreferredSize().height;
                MediaPlayer.this.preferredWidth = MediaPlayer.this.visualComponent.getPreferredSize().width;
            }
            if (MediaPlayer.this.panel != null) {
                if (MediaPlayer.this.vPanel != null) {
                    MediaPlayer.this.vPanel.setBounds(0, 0, e2.getWidth(), e2.getHeight() - newPanelHeight);
                    MediaPlayer.this.vPanel.validate();
                }
                MediaPlayer.this.panel.setBounds(0, 0, e2.getWidth(), e2.getHeight());
                MediaPlayer.this.panel.validate();
            }
            MediaPlayer.this.invalidate();
            MediaPlayer.this.validate();
        }

        public void cachingControl(CachingControlEvent e2) {
            MediaPlayer.this.debug("  Event:  CachingControl");
            if (MediaPlayer.this.isCachingControlVisible()) {
                CachingControl cc = e2.getCachingControl();
                long contentLength = cc.getContentLength();
                if (cc != null && MediaPlayer.this.cachingComponent == null && contentLength != Long.MAX_VALUE) {
                    MediaPlayer.this.cachingComponent = cc.getControlComponent();
                    if (MediaPlayer.this.cachingComponent == null) {
                        MediaPlayer.this.cachingComponent = cc.getProgressBarComponent();
                    }
                    if (MediaPlayer.this.cachingComponent != null) {
                        MediaPlayer.this.panel.add("South", MediaPlayer.this.cachingComponent);
                        Dimension prefSize = MediaPlayer.this.cachingComponent.getPreferredSize();
                        MediaPlayer.this.cachingComponent.setBounds(0, 0, prefSize.width, prefSize.height);
                        MediaPlayer.this.panel.setSize(prefSize.width, prefSize.height);
                        MediaPlayer.this.panel.validate();
                    }
                } else if (cc.getContentProgress() == contentLength && MediaPlayer.this.cachingComponent != null) {
                    MediaPlayer.this.panel.remove(MediaPlayer.this.cachingComponent);
                    MediaPlayer.this.validate();
                }
            }
        }
    }
}

