/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.sikuli.api.APILogger;
import org.sikuli.api.ScreenLocation;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultLogger
extends APILogger {
    static Logger apiLogger = LoggerFactory.getLogger((String)"org.sikuli.api");

    DefaultLogger() {
    }

    String now() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(new Date());
    }

    void out(String str) {
        apiLogger.trace(str);
    }

    @Override
    public void typePerformed(String text) {
        this.out(this.now() + "\tType " + text);
    }

    @Override
    public void clickPerformed(ScreenLocation location) {
        this.out(this.now() + "\tClick at " + location);
    }

    @Override
    public void rightClickPerformed(ScreenLocation location) {
        this.out(this.now() + "\tRight click at " + location);
    }

    @Override
    public void doubleClickPerformed(ScreenLocation location) {
        this.out(this.now() + "\tDouble click at " + location);
    }

    @Override
    public void findPerformed(ScreenRegion screenRegion, Target target, ScreenRegion result) {
        this.out(this.now() + "\tFind " + target + (result != null ? " at " + result : " not found"));
    }

    @Override
    public void findAllPerformed(ScreenRegion screenRegion, Target target, List<ScreenRegion> result) {
        this.out(this.now() + "\tFindAll " + target + "\t" + result.size() + " matches found");
        for (int i2 = 0; i2 < result.size(); ++i2) {
            this.out("\t\t" + (i2 + 1) + ":" + result.get(i2));
        }
    }

    @Override
    public void waitPerformed(ScreenRegion screenRegion, Target target, int duration, ScreenRegion result) {
        this.out(this.now() + "\tWait " + target + (result != null ? " at " + result : " not found"));
    }
}

