/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.robot.desktop;

import java.awt.Point;
import org.sikuli.api.APILogger;
import org.sikuli.api.ScreenLocation;
import org.sikuli.api.robot.desktop.AWTRobot;

class AWTMouse {
    AWTRobot robot;
    private static int _hold_buttons = 0;

    AWTMouse(AWTRobot robot) {
        this.robot = robot;
    }

    private void _moveTo(ScreenLocation screenLoc) {
        Point o2 = this.robot.getOrigin();
        this.robot.smoothMove(new Point(-o2.x + screenLoc.getX(), -o2.y + screenLoc.getY()));
        this.robot.waitForIdle();
    }

    private void _click(int buttons, int modifiers, boolean dblClick) {
        this.robot.pressModifiers(modifiers);
        this.robot.mousePress(buttons);
        this.robot.mouseRelease(buttons);
        if (dblClick) {
            this.robot.mousePress(buttons);
            this.robot.mouseRelease(buttons);
        }
        this.robot.releaseModifiers(modifiers);
        this.robot.waitForIdle();
    }

    public void drag(ScreenLocation screenLoc) {
        this._moveTo(screenLoc);
        this.robot.mousePress(16);
        this.robot.waitForIdle();
    }

    public void drop(ScreenLocation screenLoc) {
        this._moveTo(screenLoc);
        int delay = 1;
        this.robot.delay(delay * 1000);
        this.robot.mouseRelease(16);
        this.robot.waitForIdle();
    }

    public void rightClick(ScreenLocation screenLoc) {
        APILogger.getLogger().rightClickPerformed(screenLoc);
        this._moveTo(screenLoc);
        this._click(4, 0, false);
    }

    public void doubleClick(ScreenLocation screenLoc) {
        APILogger.getLogger().doubleClickPerformed(screenLoc);
        this._moveTo(screenLoc);
        this._click(16, 0, true);
    }

    public void click(ScreenLocation screenLoc) {
        APILogger.getLogger().clickPerformed(screenLoc);
        this._moveTo(screenLoc);
        this._click(16, 0, false);
    }

    public void wheel(int direction, int steps) {
        for (int i2 = 0; i2 < steps; ++i2) {
            this.robot.mouseWheel(direction);
            this.robot.delay(50);
        }
    }

    public void mouseDown(int buttons) {
        _hold_buttons = buttons;
        this.robot.mousePress(buttons);
        this.robot.waitForIdle();
    }

    public void mouseUp() {
        this.mouseUp(0);
    }

    public void mouseUp(int buttons) {
        if (buttons == 0) {
            this.robot.mouseRelease(_hold_buttons);
        } else {
            this.robot.mouseRelease(buttons);
        }
        this.robot.waitForIdle();
    }
}

