/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.cv;

import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import org.sikuli.core.cv.DownsampleTemplateFinder;
import org.sikuli.core.cv.FindResult;

public class TemplateFinder {
    static final float MIM_TARGET_DIMENSION = 6.0f;
    static final float MIM_TARGET_DIMENSION_FINDALL = 24.0f;
    static final float MIM_TARGET_DIMENSION_FINDALLSIMILAR = 32.0f;
    static final float REMATCH_THRESHOLD = 0.995f;

    static BufferedImage deepCopy(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = bi.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    private opencv_core.IplImage createGrayScaleIplImage(BufferedImage colorImage) {
        opencv_core.IplImage colorIplImage = opencv_core.IplImage.createFrom(colorImage);
        opencv_core.IplImage grayIplImage = opencv_core.IplImage.create(opencv_core.cvGetSize(colorIplImage), 8, 1);
        opencv_imgproc.cvCvtColor(colorIplImage, grayIplImage, 7);
        colorIplImage.release();
        return grayIplImage;
    }

    public FindResult findFirstGoodMatch(BufferedImage inputImage, BufferedImage targetImage) {
        FindResult[] results = this.findSimilarMatches(inputImage, targetImage, 1, 0.995);
        if (results.length > 0) {
            return results[0];
        }
        return null;
    }

    public FindResult[] findSimilarMatches(BufferedImage inputImage, BufferedImage targetImage, int k2, double minSimilarity) {
        if (inputImage.getWidth() < targetImage.getWidth() || inputImage.getHeight() < targetImage.getHeight()) {
            return new FindResult[0];
        }
        minSimilarity = Math.min(0.999, minSimilarity);
        opencv_core.IplImage targetGray = this.createGrayScaleIplImage(targetImage);
        opencv_core.IplImage inputGray = this.createGrayScaleIplImage(inputImage);
        FindResult[] r = this.findSimilarMatches(inputGray, targetGray, k2, minSimilarity);
        inputGray.release();
        targetGray.release();
        return r;
    }

    public FindResult[] findMatches(BufferedImage inputImage, BufferedImage targetImage, int k2) {
        if (inputImage.getWidth() < targetImage.getWidth() || inputImage.getHeight() < targetImage.getHeight()) {
            return new FindResult[0];
        }
        opencv_core.IplImage inputGray = this.createGrayScaleIplImage(inputImage);
        opencv_core.IplImage targetGray = this.createGrayScaleIplImage(targetImage);
        FindResult[] r = this.findMatches(inputGray, targetGray, k2);
        inputGray.release();
        targetGray.release();
        return r;
    }

    public FindResult findFirstMatch(BufferedImage inputImage, BufferedImage targetImage) {
        if (inputImage.getWidth() < targetImage.getWidth() || inputImage.getHeight() < targetImage.getHeight()) {
            return null;
        }
        opencv_core.IplImage inputGray = this.createGrayScaleIplImage(inputImage);
        opencv_core.IplImage targetGray = this.createGrayScaleIplImage(targetImage);
        FindResult r = this.findFirstMatch1(inputGray, targetGray);
        inputGray.release();
        targetGray.release();
        return r;
    }

    private FindResult[] findSimilarMatches(opencv_core.IplImage input, opencv_core.IplImage target, int k2, double minSimilarity) {
        double factor = Math.min((double)target.height() * 1.0 / 32.0, (double)target.width() * 1.0 / 32.0);
        DownsampleTemplateFinder tm = new DownsampleTemplateFinder();
        FindResult[] topResults = tm.findTopKMatches(input, target, factor, k2);
        ArrayList<FindResult> filteredResults = new ArrayList<FindResult>();
        for (FindResult r : topResults) {
            if (!(r.score >= minSimilarity)) continue;
            filteredResults.add(r);
        }
        return filteredResults.toArray(new FindResult[0]);
    }

    private FindResult[] findMatches(opencv_core.IplImage input, opencv_core.IplImage target, int k2) {
        double factor = Math.min((double)target.height() * 1.0 / 24.0, (double)target.width() * 1.0 / 24.0);
        DownsampleTemplateFinder tm = new DownsampleTemplateFinder();
        FindResult[] topResults = tm.findTopKMatches(input, target, factor, k2);
        FindResult top = topResults[0];
        if (top.score < (double)0.995f) {
            topResults = tm.findTopKMatches(input, target, factor * 0.75, k2);
        }
        return topResults;
    }

    private FindResult findFirstMatch1(opencv_core.IplImage input, opencv_core.IplImage target) {
        double factor = Math.min((double)target.height() * 1.0 / 6.0, (double)target.width() * 1.0 / 6.0);
        DownsampleTemplateFinder tm = new DownsampleTemplateFinder();
        FindResult top = tm.findTopMatch(input, target, factor);
        if (top.score < (double)0.995f) {
            top = tm.findTopMatch(input, target, factor * 0.75);
        }
        if (top.score < (double)0.995f) {
            top = tm.findTopMatch(input, target, factor / 2.0);
        }
        if (top.score < (double)0.995f) {
            top = tm.findTopMatch(input, target, factor / 4.0);
        }
        return top;
    }
}

