/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.azure.setting;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.appium.driver.AppiumDriverManager;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.integration.azure.constant.StringConstants;
import com.kms.katalon.integration.azure.setting.TestConfigurationMapping;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ExecutionMappingUtil {
    public static final String ANY_OS = "--Any--";
    public static final String ANY_PLATFORM = "--Any--";
    public static final String ANY_PROFILE = "--Any--";
    public static final String[] EXECUTION_OSES = new String[]{"--Any--", "Windows", "macOS", "Linux", "Android", "iOS"};
    public static final String[] EXECUTION_PLATFORMS = new String[]{"--Any--", "Chrome", "Firefox", "IE", "Safari", "Edge", "Edge Chromium", "Native App"};

    public static List<Integer> getSuitableConfigurations(TestSuiteLogRecord suiteRecord, List<TestConfigurationMapping> mappings) {
        try {
            List<String> profiles = GlobalVariableController.getInstance().getAllGlobalVariableCollections(ProjectController.getInstance().getCurrentProject()).stream().map(ExecutionProfileEntity::getName).toList();
            mappings.stream().map(TestConfigurationMapping::getExecutionProfile).filter(profile -> StringUtils.isNotEmpty((CharSequence)profile) && !profiles.contains(profile)).distinct().forEach(profile -> LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_NON_EXISTING_EXECUTION_PROFILE_FORMAT, profile)));
        }
        catch (Exception exception) {}
        File executionSettingFile = ReportController.getInstance().getExecutionSettingFile(suiteRecord.getLogFolder());
        RunConfiguration.setExecutionSettingFile((String)executionSettingFile.getAbsolutePath());
        String os = ExecutionMappingUtil.getOs(suiteRecord);
        String browser = ExecutionMappingUtil.getBrowser(suiteRecord);
        String executionProfile = RunConfiguration.getExecutionProfile();
        return mappings.stream().filter(m -> ExecutionMappingUtil.isMatched(os, browser, executionProfile, m)).map(TestConfigurationMapping::getAzureTestConfigurationId).toList();
    }

    private static boolean compareOs(String os, String mappingOs) {
        if (os.toLowerCase().contains(mappingOs.toLowerCase())) {
            return true;
        }
        if ("macOS".equals(mappingOs)) {
            return os.toLowerCase().contains("mac");
        }
        return false;
    }

    private static boolean isMatched(String os, String browser, String executionProfile, TestConfigurationMapping mapping) {
        String mappingOs = mapping.getOs();
        String mappingPlatform = mapping.getPlatform();
        String mappingProfile = mapping.getExecutionProfile();
        if (mappingOs != null && !"--Any--".equals(mappingOs) && !ExecutionMappingUtil.compareOs(os, mappingOs)) {
            return false;
        }
        if (mappingPlatform != null && !"--Any--".equals(mappingPlatform) && !browser.toLowerCase().contains(mappingPlatform.toLowerCase())) {
            return false;
        }
        boolean notMatched = mappingProfile != null && !mappingProfile.equals(executionProfile);
        return !notMatched;
    }

    public static String getOs(TestSuiteLogRecord suiteRecord) {
        Type typeToken;
        Map desiredCapabilities;
        String platformName;
        Map runData = suiteRecord.getRunData();
        if (runData == null) {
            return "";
        }
        String remoteServerUrl = runData.getOrDefault("remoteDriverUrl", "");
        String desiredCapabilitiesString = runData.getOrDefault("desiredCapabilities", "");
        if (StringUtils.isNotEmpty((CharSequence)remoteServerUrl) && StringUtils.isNotEmpty((CharSequence)desiredCapabilitiesString) && StringUtils.isNotEmpty((CharSequence)(platformName = (desiredCapabilities = (Map)JsonUtil.fromJson((String)desiredCapabilitiesString, (Type)(typeToken = new TypeToken<Map<String, Object>>(){}.getType()))).getOrDefault("platformName", "").toString()))) {
            return platformName;
        }
        String mobileOs = runData.getOrDefault(AppiumDriverManager.EXECUTED_DEVICE_OS, "");
        if (StringUtils.isEmpty((CharSequence)mobileOs)) {
            mobileOs = ExecutionMappingUtil.getMobileOSInExecutionProperties();
        }
        return StringUtils.isNotEmpty((CharSequence)mobileOs) ? mobileOs : suiteRecord.getOs();
    }

    private static String getBrowser(TestSuiteLogRecord suiteRecord) {
        String browser = ExecutionMappingUtil.getBrowserFromRunData(suiteRecord);
        if (StringUtils.isEmpty((CharSequence)browser)) {
            browser = ExecutionMappingUtil.getBrowserInExecutionProperties();
        }
        return StringUtils.isNotEmpty((CharSequence)browser) ? browser : "Native App";
    }

    public static String getBrowserFromRunData(TestSuiteLogRecord suiteRecord) {
        Map runData = suiteRecord.getRunData();
        if (runData == null) {
            return "";
        }
        String browser = suiteRecord.getBrowser();
        return StringUtils.isNotEmpty((CharSequence)browser) ? browser : "";
    }

    public static String getMobileOSInExecutionProperties() {
        return RunConfiguration.getDriverSystemProperty((String)"Mobile", (String)AppiumDriverManager.EXECUTED_DEVICE_OS, (String)"");
    }

    public static String getBrowserInExecutionProperties() {
        String driverTypeString;
        block6: {
            try {
                driverTypeString = RunConfiguration.getDriverSystemProperty((String)"WebUI", (String)"browserType", (String)"");
                if (!StringUtils.isBlank((CharSequence)driverTypeString)) break block6;
                return "";
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return "";
            }
        }
        WebUIDriverType driverType = WebUIDriverType.valueOf((String)driverTypeString);
        return switch (driverType) {
            case WebUIDriverType.REMOTE_WEB_DRIVER, WebUIDriverType.KOBITON_WEB_DRIVER -> "";
            default -> driverType.toString();
        };
    }
}

