/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.mobile.configuration.contributor;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.mobile.configuration.MobileRunConfiguration;
import com.kms.katalon.execution.mobile.configuration.providers.MobileDeviceProvider;
import com.kms.katalon.execution.mobile.constants.StringConstants;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.execution.mobile.driver.AndroidDriverConnector;
import com.kms.katalon.execution.mobile.driver.IosDriverConnector;
import com.kms.katalon.execution.mobile.driver.MobileDriverConnector;
import com.kms.katalon.execution.mobile.exception.MobileSetupException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class MobileRunConfigurationContributor
implements IRunConfigurationContributor {
    public static final String DEVICE_ID_CONFIGURATION_KEY = "deviceId";
    public static final String DEVICE_DISPLAY_NAME_CONFIGURATION_KEY = "deviceName";
    public static final String APPIUM_DIRECTORY = "appiumDirectory";
    private String deviceIdConsoleOption;
    private static String appiumDirectory;
    public static final StringConsoleOption DEVICE_ID_CONSOLE_OPTION;
    public static final StringConsoleOption APPIUM_DIRECTORY_CONSOLE_OPTION;

    static {
        DEVICE_ID_CONSOLE_OPTION = new StringConsoleOption(){

            public String getOption() {
                return MobileRunConfigurationContributor.DEVICE_ID_CONFIGURATION_KEY;
            }
        };
        APPIUM_DIRECTORY_CONSOLE_OPTION = new StringConsoleOption(){

            public String getOption() {
                return MobileRunConfigurationContributor.APPIUM_DIRECTORY;
            }
        };
    }

    public String getId() {
        return this.getMobileDriverType().toString();
    }

    public IRunConfiguration getRunConfiguration(String projectDir) throws IOException, ExecutionException, InterruptedException {
        String chosenDeviceId;
        String string = chosenDeviceId = StringUtils.isNotBlank((String)this.deviceIdConsoleOption) ? this.deviceIdConsoleOption : MobileRunConfigurationContributor.getDefaultDeviceId(projectDir, this.getMobileDriverType());
        if (StringUtils.isBlank((String)chosenDeviceId)) {
            throw new ExecutionException(StringConstants.MOBILE_ERR_NO_DEVICE_NAME_AVAILABLE);
        }
        MobileDeviceInfo device = null;
        try {
            device = MobileDeviceProvider.getDevice(this.getMobileDriverType(), chosenDeviceId);
        }
        catch (MobileSetupException e) {
            throw new ExecutionException(e.getMessage());
        }
        if (device == null) {
            throw new ExecutionException(MessageFormat.format(StringConstants.MOBILE_ERR_CANNOT_FIND_DEVICE_WITH_NAME_X, chosenDeviceId));
        }
        MobileRunConfiguration runConfiguration = this.getMobileRunConfiguration(projectDir);
        runConfiguration.setDevice(device);
        return runConfiguration;
    }

    public IRunConfiguration getRunConfiguration(String projectDir, IDriverConnector driverConnector) throws IOException, ExecutionException, InterruptedException {
        String chosenDeviceId;
        if (!(driverConnector instanceof MobileDriverConnector)) {
            throw new ExecutionException("Invalid driver connector");
        }
        MobileDriverConnector mobileDriverConnector = (MobileDriverConnector)driverConnector;
        String string = chosenDeviceId = StringUtils.isNotBlank((String)this.deviceIdConsoleOption) ? this.deviceIdConsoleOption : mobileDriverConnector.getDefaultDeviceId();
        if (StringUtils.isBlank((String)chosenDeviceId)) {
            throw new ExecutionException(StringConstants.MOBILE_ERR_NO_DEVICE_NAME_AVAILABLE);
        }
        MobileDeviceInfo device = null;
        try {
            device = MobileDeviceProvider.getDevice(this.getMobileDriverType(), chosenDeviceId);
        }
        catch (MobileSetupException e) {
            throw new ExecutionException(e.getMessage());
        }
        if (device == null) {
            throw new ExecutionException(MessageFormat.format(StringConstants.MOBILE_ERR_CANNOT_FIND_DEVICE_WITH_NAME_X, chosenDeviceId));
        }
        MobileRunConfiguration runConfiguration = this.getMobileRunConfiguration(projectDir);
        runConfiguration.setDevice(device);
        mobileDriverConnector.setDevice(device);
        return runConfiguration;
    }

    public IRunConfiguration getRunConfiguration(String projectDir, RunConfigurationDescription runConfigurationDescription) throws IOException, ExecutionException, InterruptedException {
        String chosenDeviceId;
        String string = chosenDeviceId = StringUtils.isNotBlank((String)this.deviceIdConsoleOption) ? this.deviceIdConsoleOption : this.getDeviceId(runConfigurationDescription);
        if (StringUtils.isBlank((String)chosenDeviceId)) {
            throw new ExecutionException(StringConstants.MOBILE_ERR_NO_DEVICE_NAME_AVAILABLE);
        }
        MobileDeviceInfo device = null;
        try {
            device = MobileDeviceProvider.getDevice(this.getMobileDriverType(), chosenDeviceId);
        }
        catch (MobileSetupException e) {
            throw new ExecutionException(e.getMessage());
        }
        if (device == null) {
            throw new ExecutionException(MessageFormat.format(StringConstants.MOBILE_ERR_CANNOT_FIND_DEVICE_WITH_NAME_X, chosenDeviceId));
        }
        MobileRunConfiguration runConfiguration = this.getMobileRunConfiguration(projectDir);
        try {
            runConfiguration.setExecutionProfile(GlobalVariableController.getInstance().getGlobalVariableCollection(runConfigurationDescription.getProfileName(), ProjectController.getInstance().getCurrentProject()));
        }
        catch (DALException dALException) {
            throw new ExecutionException(MessageFormat.format("Profile {0} not found.", runConfigurationDescription.getProfileName()));
        }
        runConfiguration.setDevice(device);
        return runConfiguration;
    }

    private String getDeviceId(RunConfigurationDescription runConfigurationDescription) {
        if (runConfigurationDescription != null && runConfigurationDescription.getRunConfigurationData() != null) {
            return (String)runConfigurationDescription.getRunConfigurationData().get(DEVICE_ID_CONFIGURATION_KEY);
        }
        return "";
    }

    protected abstract MobileRunConfiguration getMobileRunConfiguration(String var1) throws IOException;

    public List<ConsoleOption<?>> getConsoleOptionList() {
        ArrayList consoleOptionList = new ArrayList();
        consoleOptionList.add((ConsoleOption<?>)DEVICE_ID_CONSOLE_OPTION);
        consoleOptionList.add((ConsoleOption<?>)APPIUM_DIRECTORY_CONSOLE_OPTION);
        return consoleOptionList;
    }

    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        if (StringUtils.isBlank((String)argumentValue)) {
            return;
        }
        if (consoleOption == DEVICE_ID_CONSOLE_OPTION) {
            this.deviceIdConsoleOption = argumentValue.trim();
        }
    }

    protected abstract MobileDriverType getMobileDriverType();

    public static String getDefaultDeviceId(String projectDir, MobileDriverType platform) throws IOException {
        String deviceId = null;
        switch (platform) {
            case ANDROID_DRIVER: {
                deviceId = new AndroidDriverConnector(projectDir + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME).getDefaultDeviceId();
                break;
            }
            case IOS_DRIVER: {
                deviceId = new IosDriverConnector(projectDir + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME).getDefaultDeviceId();
            }
        }
        return deviceId;
    }

    public List<ConsoleOption<?>> getConsoleOptions(final RunConfigurationDescription description) {
        return Arrays.asList(new StringConsoleOption(){

            public String getOption() {
                return MobileRunConfigurationContributor.DEVICE_ID_CONFIGURATION_KEY;
            }

            public String getValue() {
                return MobileRunConfigurationContributor.this.getDeviceId(description);
            }
        });
    }
}

