/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.mobile.util;

import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.execution.mobile.constants.ExecutionMobileMessageConstants;
import com.kms.katalon.execution.mobile.exception.MobileSetupException;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;

public class MobileExecutionUtil {
    private static final String ENV_APPIUM_HOME_DIRECTORY = System.getenv("APPIUM_HOME");
    private static final String[] APPIUM_HOME_DIRS_MACOS = new String[]{"/usr/local/lib/node_modules/appium", "/opt/homebrew/lib/node_modules/appium"};

    public static void detectInstalledAppiumAndNodeJs() throws MobileSetupException {
        String appiumDir = null;
        appiumDir = MobileExecutionUtil.findAppiumDir();
        boolean isNodeInstalled = ConsoleCommandExecutor.isInstalled((String)"node");
        String errorMessage = "";
        if (StringUtils.isEmpty((String)appiumDir) && !isNodeInstalled) {
            errorMessage = ExecutionMobileMessageConstants.MSG_NO_APPIUM_AND_NODEJS;
        }
        if (StringUtils.isEmpty((String)appiumDir)) {
            errorMessage = ExecutionMobileMessageConstants.MSG_NO_APPIUM;
        }
        if (!isNodeInstalled) {
            errorMessage = ExecutionMobileMessageConstants.MSG_NO_NODEJS;
        }
        if (!errorMessage.isEmpty()) {
            throw new MobileSetupException(errorMessage);
        }
    }

    public static String findAppiumDir() {
        ScopedPreferenceStore mobilePreferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.mobile");
        String appiumDir = mobilePreferenceStore.getString("mobile.appiumDirectory");
        if (StringUtils.isNotEmpty((String)appiumDir)) {
            return appiumDir;
        }
        return MobileExecutionUtil.saveAppiumDirToMobilePreferenceStore(mobilePreferenceStore);
    }

    public static String saveAppiumDirToMobilePreferenceStore(ScopedPreferenceStore mobilePreferenceStore) {
        String appiumDir = "";
        if (StringUtils.isNotBlank((String)ENV_APPIUM_HOME_DIRECTORY)) {
            appiumDir = ENV_APPIUM_HOME_DIRECTORY;
        }
        if (StringUtils.isEmpty((String)appiumDir) || !new File(appiumDir).exists()) {
            appiumDir = MobileExecutionUtil.findAppiumFromDefaultLocation();
        }
        if (StringUtils.isNotEmpty((String)appiumDir) && new File(appiumDir).exists()) {
            mobilePreferenceStore.setValue("mobile.appiumDirectory", appiumDir);
            try {
                mobilePreferenceStore.save();
            }
            catch (IOException error) {
                LogUtil.logError((Throwable)error);
            }
        }
        return appiumDir;
    }

    private static String findAppiumFromDefaultLocation() {
        switch (Platform.getOS()) {
            case "macosx": {
                return MobileExecutionUtil.findAppiumHome(APPIUM_HOME_DIRS_MACOS);
            }
            case "linux": {
                return MobileExecutionUtil.findAppiumHome("/usr/lib/node_modules/appium/");
            }
            case "win32": {
                return MobileExecutionUtil.findAppiumHome(System.getProperty("user.home") + "\\AppData\\Roaming\\npm\\node_modules\\appium");
            }
        }
        return null;
    }

    private static String findAppiumHome(String ... defaultLocations) {
        String validAppiumDir = "";
        String appiumBin = ConsoleCommandExecutor.safeWhere((String)"appium");
        if (StringUtils.isNotBlank((String)appiumBin)) {
            File parent = new File(appiumBin);
            if (StringUtils.equals((String)parent.getName(), (String)"appium")) {
                parent = new File(parent.getParentFile(), "node_modules/appium");
            }
            while (parent.exists()) {
                if (parent.isDirectory() && StringUtils.equals((String)parent.getName(), (String)"appium")) {
                    validAppiumDir = parent.getAbsolutePath();
                    break;
                }
                parent = parent.getParentFile();
            }
        }
        if (StringUtils.isBlank((String)validAppiumDir)) {
            validAppiumDir = Arrays.stream(defaultLocations).filter(appiumHomeDir -> new File((String)appiumHomeDir).exists()).findFirst().orElse(null);
        }
        return validAppiumDir;
    }
}

