/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.custom.improvement.plugin.model;

import com.kms.katalon.core.annotation.Keyword;
import com.kms.katalon.core.keyword.internal.IKeywordContributor;
import com.kms.katalon.custom.improvement.plugin.model.KeywordMethod;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class KeywordClass {
    private String name;
    private String simpleName;
    private String labelName;
    private String aliasName;
    private IKeywordContributor keywordContributor;
    private Class<?> type;
    private List<KeywordMethod> keywordMethods = new ArrayList<KeywordMethod>();

    public KeywordClass(IKeywordContributor keywordContributor) {
        this.keywordContributor = keywordContributor;
        this.name = keywordContributor.getKeywordClass().getName();
        this.simpleName = keywordContributor.getKeywordClass().getSimpleName();
        this.labelName = keywordContributor.getLabelName();
        this.aliasName = keywordContributor.getAliasName();
        this.type = keywordContributor.getKeywordClass();
        Method[] methodArray = keywordContributor.getKeywordClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (KeywordClass.isBuiltinMethod(method)) {
                this.keywordMethods.add(new KeywordMethod(method));
            }
            ++n2;
        }
        Collections.sort(this.keywordMethods, new Comparator<KeywordMethod>(){

            @Override
            public int compare(KeywordMethod o1, KeywordMethod o2) {
                if (o1 != null && o2 != null) {
                    return o1.getName().compareTo(o2.getName());
                }
                return 0;
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public List<KeywordMethod> getKeywordMethods() {
        return this.keywordMethods;
    }

    private static boolean isBuiltinMethod(Method method) {
        int modifiers = method.getModifiers();
        Keyword ann = method.getAnnotation(Keyword.class);
        return Modifier.isPublic(modifiers) && ann != null;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public IKeywordContributor getKeywordContributor() {
        return this.keywordContributor;
    }
}

