/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.entity;

import com.kms.katalon.integration.qtest.entity.QTestCycle;
import com.kms.katalon.integration.qtest.entity.QTestEntity;
import com.kms.katalon.integration.qtest.entity.QTestRelease;
import com.kms.katalon.integration.qtest.entity.QTestReleaseRoot;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qas.qtest.api.internal.model.ArtifactLevel;

public abstract class QTestSuiteParent
extends QTestEntity {
    public static final int RELEASE_ROOT_TYPE = 6;
    public static final int RELEASE_TYPE = 8;
    public static final int CYCLE_TYPE = 4;

    public abstract List<QTestSuiteParent> getChildren();

    public abstract QTestSuiteParent getParent();

    public abstract int getType();

    public abstract String getTypeName();

    public Map<String, Object> getPropertyMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("id", this.id);
        properties.put("name", this.name);
        properties.put("type", this.getType());
        QTestSuiteParent parent = this.getParent();
        if (parent != null) {
            properties.put("parentId", parent.getId());
            properties.put("parentName", parent.getName());
        } else {
            properties.put("parentId", 0);
            properties.put("parentName", "");
        }
        return properties;
    }

    public static QTestSuiteParent getTestSuiteParent(long id, int type, String name) {
        QTestSuiteParent parent = null;
        switch (type) {
            case 6: {
                parent = new QTestReleaseRoot();
                break;
            }
            case 8: {
                parent = new QTestRelease();
                break;
            }
            case 4: {
                parent = new QTestCycle();
            }
        }
        if (parent != null) {
            parent.setId(id);
            parent.setName(name);
        }
        return parent;
    }

    public ArtifactLevel getArtifactLevel() {
        switch (this.getType()) {
            case 6: {
                return ArtifactLevel.ROOT;
            }
            case 8: {
                return ArtifactLevel.RELEASE;
            }
            case 4: {
                return ArtifactLevel.TEST_CYCLE;
            }
        }
        return ArtifactLevel.ROOT;
    }
}

