/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.model;

import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import com.kms.katalon.integration.qtest.model.ParityReportInput;
import com.kms.katalon.logging.LogUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class TestSuiteCollectionParityReportInput
extends ParityReportInput {
    private static final String TEST_SUITE_COLLECTION = "Test Suite Collection";
    private TestSuiteCollectionEntity testSuiteCollection;

    public TestSuiteCollectionParityReportInput(TestSuiteCollectionEntity testSuiteCollection) {
        this.testSuiteCollection = testSuiteCollection;
    }

    @Override
    public FileEntity getExecutedEntity() {
        return this.testSuiteCollection;
    }

    @Override
    public List<TestCaseEntity> getExecutedTestCases() {
        try {
            HashSet<TestCaseEntity> testCases = new HashSet<TestCaseEntity>();
            for (TestSuiteRunConfiguration suiteRunConfig : this.testSuiteCollection.getTestSuiteRunConfigurations()) {
                TestSuiteEntity testSuite = suiteRunConfig.getTestSuiteEntity();
                List<TestCaseEntity> testCasesInSuite = this.getExecutedTestCasesInTestSuite(testSuite);
                testCases.addAll(testCasesInSuite);
            }
            return new ArrayList<TestCaseEntity>(testCases);
        }
        catch (ControllerException e) {
            LogUtil.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<TestCaseEntity> getExecutedTestCasesInTestSuite(TestSuiteEntity testSuite) throws ControllerException {
        HashSet<TestCaseEntity> testCases = new HashSet<TestCaseEntity>();
        for (TestSuiteTestCaseLink testCaseLink : testSuite.getTestSuiteTestCaseLinks()) {
            if (!testCaseLink.getIsRun()) continue;
            String testCaseId = testCaseLink.getTestCaseId();
            TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseId);
            testCases.add(testCase);
        }
        return new ArrayList<TestCaseEntity>(testCases);
    }

    @Override
    public String getExecutedEntityType() {
        return TEST_SUITE_COLLECTION;
    }
}

