/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.about.dialog;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.VersionInfo;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.FontUtil;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.update.UpdateManager;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.core.model.KatalonEdition;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.session.core.model.License;
import com.kms.katalon.session.core.model.LicenseType;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.model.User;
import com.kms.katalon.session.core.model.exception.SessionException;
import com.kms.katalon.session.core.services.ISessionController;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.LinkedList;
import java.util.Objects;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.about.AboutBundleGroupData;
import org.eclipse.ui.internal.about.InstallationDialog;
import org.eclipse.ui.services.IServiceLocator;

public class KatalonAboutDialog
extends TrayDialog {
    private String productName;
    private Image logo;
    protected static final String VERSION_UPDATE = "KatalonVersionUpdate";
    private boolean isKSEEdition = false;
    private boolean isLatestVersion = true;
    private String latestVersion;
    private String expirationDate;
    private Label lblNotice;
    private Label notice;
    private Label expiration;
    private KatalonEdition edition;
    private UpdateManager updateManager = UpdateManager.getInstance();
    private boolean isKsNewVersionNotification;
    @Inject
    private ISessionController sessionController;

    public KatalonAboutDialog(Shell parentShell) {
        super(parentShell);
        this.edition = ApplicationEdition.get();
        this.productName = Platform.getProduct().getName();
        this.isKsNewVersionNotification = this.updateManager.isKsNewVersionNotification();
        switch (this.edition) {
            case ENTERPRISE: {
                this.isKSEEdition = true;
                break;
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)WorkbenchMessages.AboutDialog_shellTitle, (Object)this.productName));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.ui.about_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    private String getExpirationDate() {
        if (this.edition.equals((Object)KatalonEdition.ENTERPRISE)) {
            Session session = this.sessionController.getSession();
            License license = session.getLicense();
            if (license.isOffline()) {
                Instant instant = Instant.ofEpochMilli(license.getExpirationDate());
                return Date.from(instant).toString();
            }
            Date expDate = null;
            if (LicenseType.TRIAL.equals((Object)license.getLicenseType())) {
                User user = session.getUser();
                expDate = Date.from(user.getTrialExpirationDate().toInstant());
            } else {
                try {
                    expDate = this.sessionController.getExpirationOnline(session.getLicenseFeature());
                }
                catch (SessionException sessionException) {}
            }
            if (Objects.nonNull(expDate)) {
                SimpleDateFormat formatter = new SimpleDateFormat("MMMMM dd, yyyy HH:mm");
                return formatter.format(expDate);
            }
        }
        return StringConstants.About_MSG_CANNOT_GET_EXPIRATION_DATE;
    }

    private void updateExpirationDate() {
        Thread getExpiration = new Thread(() -> {
            this.expirationDate = this.getExpirationDate();
            UISynchronizeService.asyncExec(() -> {
                if (this.expirationDate.equals(StringConstants.About_MSG_CANNOT_GET_EXPIRATION_DATE)) {
                    this.expiration.setForeground(ColorUtil.getTextErrorColor());
                    ControlUtils.setFontStyle((Control)this.expiration, (int)2, (int)12);
                } else {
                    this.expiration.setForeground(ColorUtil.getDefaultTextColor());
                    ControlUtils.setFontStyle((Control)this.expiration, (int)0, (int)12);
                }
                this.expiration.setText(this.expirationDate);
            });
        });
        getExpiration.start();
    }

    private void updateVersionInfo() {
        Thread checkLatestVersion = new Thread(() -> {
            if (!this.updateManager.isKsNewVersionNotification()) {
                this.isLatestVersion = false;
                this.latestVersion = MessageConstants.ABOUT_DIALOG_HAND_MSG_VERSION_CONTROLLED_BY_ADMIN;
            } else {
                VersionInfo latestVersionInfo = VersionUtil.getLatestVersion();
                if (VersionUtil.isNewer((String)latestVersionInfo.getVersion(), (String)VersionUtil.getCurrentVersion().getVersion())) {
                    this.isLatestVersion = false;
                    this.latestVersion = MessageFormat.format(MessageConstants.ABOUT_DIALOG_NEW_VERSION_AVAIABLE, latestVersionInfo.getVersion());
                } else {
                    this.isLatestVersion = true;
                    this.latestVersion = MessageConstants.HAND_MSG_UP_TO_DATE;
                }
            }
            UISynchronizeService.asyncExec(() -> {
                if (this.notice == null || this.notice.isDisposed()) {
                    return;
                }
                this.notice.setForeground(ColorUtil.getDefaultTextColor());
                this.notice.setText(this.latestVersion);
                ControlUtils.setFontStyle((Control)this.notice, (int)0, (int)12);
                if (!this.isLatestVersion) {
                    this.lblNotice.setText(MessageConstants.NEW_VERSION_AVAIABLE);
                }
            });
        });
        checkLatestVersion.start();
    }

    protected Control createDialogArea(Composite parent) {
        Session session = this.sessionController.getSession();
        License license = session.getLicense();
        LicenseType licenseType = license.getLicenseType();
        Instant instant = Instant.ofEpochMilli(license.getExpirationDate());
        this.expirationDate = Date.from(instant).toString();
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        if (providers != null) {
            LinkedList<AboutBundleGroupData> groups = new LinkedList<AboutBundleGroupData>();
            int i = 0;
            while (i < providers.length) {
                IBundleGroup[] bundleGroups = providers[i].getBundleGroups();
                int j = 0;
                while (j < bundleGroups.length) {
                    groups.add(new AboutBundleGroupData(bundleGroups[j]));
                    ++j;
                }
                ++i;
            }
        }
        ComponentUtil.appendGridLayout((Composite)parent, (int)2, (boolean)false);
        ComponentUtil.setMargin((Composite)parent, (int)10, (int)24, (int)0);
        parent.setBackgroundMode(1);
        this.getLogoImage();
        ComponentBuilder.label((Composite)parent, (int)0x40000000).image(this.logo).marginRight(20).marginLeft(20).middle().build();
        Composite contentComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1, (int)0x40000000).marginTop(15).marginLeft(20).middle().build();
        Composite titleComposite = (Composite)ComponentBuilder.gridContainer((Composite)contentComposite, (int)2, (int)0x40000000).colSpan(2).build();
        ComponentBuilder.label((Composite)titleComposite).text(this.productName).font(FontUtil.build((int)16, (int)1)).build();
        Label lblLicenseType = (Label)ComponentBuilder.label((Composite)titleComposite, (int)1024).font(FontUtil.build((int)10, (int)2)).marginTop(0).build();
        if (licenseType == LicenseType.TRIAL) {
            lblLicenseType.setText(StringConstants.ABOUT_LBL_TRIAL);
        }
        if (licenseType == LicenseType.EDUCATION) {
            lblLicenseType.setText(StringConstants.ABOUT_LBL_EDUCATION);
        }
        Composite infoComposite = (Composite)ComponentBuilder.gridContainer((Composite)contentComposite, (int)2, (int)0x40000000).gridHorizontalSpacing(12).marginTop(this.getMarginToptLatestVersionTextByOS()).build();
        Font labelFont = FontUtil.build((int)12, (int)1);
        Font infoFont = FontUtil.build((int)12);
        ComponentBuilder.label((Composite)infoComposite).text(StringConstants.ABOUT_LBL_VERSION).font(labelFont).build();
        ComponentBuilder.label((Composite)infoComposite).text(ApplicationInfo.versionTag()).font(infoFont).build();
        this.lblNotice = (Label)ComponentBuilder.label((Composite)infoComposite).font(labelFont).build();
        this.notice = (Label)ComponentBuilder.label((Composite)infoComposite).text(StringConstants.ABOUT_MSG_CHECKING_VERSION).color(ColorUtil.getTextRunningColor()).font(infoFont).width(this.getWidthLatestVersionTextByOS()).height(this.getHeightLatestVersionTextByOS()).build();
        this.updateVersionInfo();
        if (this.isKSEEdition) {
            ComponentBuilder.label((Composite)infoComposite).text(StringConstants.ABOUT_LBL_EXPIRATION_DATE).font(labelFont).build();
            this.expiration = (Label)ComponentBuilder.label((Composite)infoComposite).text(StringConstants.About_MSG_CHECKING_EXPIRATION_DATE).color(ColorUtil.getTextSuccessfulColor()).font(infoFont).build();
            this.updateExpirationDate();
        }
        Composite copyRightComposite = (Composite)ComponentBuilder.gridContainer((Composite)contentComposite, (int)1, (int)0x40000000).build();
        ComponentBuilder.label((Composite)copyRightComposite).text(StringConstants.ABOUT_LBL_COPYRIGHT).font(labelFont).build();
        Composite buttonBarComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2, (int)0x40000000).backgroundMode(2).gridHorizontalSpacing(10).colSpan(2).fillHorizontal().right().marginTop(10).marginBottom(0).noFillVertical().build();
        ComponentBuilder.button((Composite)buttonBarComposite).text(StringConstants.ABOUT_BTN_INSTALLATION_DETAILS).secondaryButton().width(this.getWidthInstalltionDetailsButtonByOS()).right().onClick(event -> {
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            InstallationDialog dialog = new InstallationDialog(this.getShell(), (IServiceLocator)workbenchWindow);
            dialog.setModalParent((Dialog)this);
            dialog.open();
        }).build();
        ComponentBuilder.button((Composite)buttonBarComposite).text(StringConstants.ABOUT_BTN_OK).primaryButton().width(80).right().onClick(event -> this.close()).build();
        return parent;
    }

    private void getLogoImage() {
        this.logo = Platform.OS.isWindows() ? (ColorUtil.isDarkTheme() ? ImageManager.getImage((String)"about/KS_logo_new_dark_theme_on_windows.png") : ImageManager.getImage((String)"about/KS_logo_new_light_theme_on_windows.png")) : (ColorUtil.isDarkTheme() ? ImageManager.getImage((String)"about/KS_logo_new_dark_theme.png") : ImageManager.getImage((String)"about/KS_logo_new_light_theme.png"));
    }

    private int getWidthInstalltionDetailsButtonByOS() {
        if (Platform.OS.isWindows()) {
            return 190;
        }
        if (Platform.OS.isLinux()) {
            return 160;
        }
        return 130;
    }

    private int getWidthLatestVersionTextByOS() {
        if (Platform.OS.isWindows()) {
            if (!this.isKsNewVersionNotification) {
                return 690;
            }
            return 380;
        }
        if (Platform.OS.isMac()) {
            if (!this.isKsNewVersionNotification) {
                return 360;
            }
        } else if (Platform.OS.isLinux()) {
            if (!this.isKsNewVersionNotification) {
                return 460;
            }
            return 250;
        }
        return 210;
    }

    private int getHeightLatestVersionTextByOS() {
        if (Platform.OS.isWindows()) {
            if (!this.isKsNewVersionNotification) {
                return 65;
            }
            return 35;
        }
        if (Platform.OS.isMac()) {
            if (!this.isKsNewVersionNotification) {
                return 30;
            }
        } else if (Platform.OS.isLinux()) {
            if (!this.isKsNewVersionNotification) {
                return 45;
            }
            return 20;
        }
        return 15;
    }

    private int getMarginToptLatestVersionTextByOS() {
        if (Platform.OS.isMac() && !this.isKsNewVersionNotification) {
            return 0;
        }
        return 10;
    }
}

