/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.activation.dialog.BaseModernDialog;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.ApplicationProxyUtil;
import com.kms.katalon.application.utils.BrowserLaunchMode;
import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.controls.SimpleComboBox;
import com.kms.katalon.composer.components.controls.SimpleTextField;
import com.kms.katalon.composer.components.controls.TextField;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.network.core.model.config.ProxyOption;
import jakarta.inject.Inject;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@Creatable
public class AdvancedSettingsDialog
extends BaseModernDialog {
    @Inject
    private IDiscoveryController discoveryController;
    private static final int MAX_PORT_VALUE = 65535;
    private Composite optionsGroup;
    private SimpleComboBox serverTypeInput;
    private SimpleTextField addressInput;
    private SimpleTextField portInput;
    private SimpleTextField excludesInput;
    private Button authCheckBox;
    private SimpleTextField usernameInput;
    private SimpleTextField passwordInput;
    private TextField licenseServerUrlInput;
    private Composite browserOptionComposite;
    private BrowserLaunchMode browserLaunchMode;

    public AdvancedSettingsDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected Point getInitialSize() {
        return new Point(500, -1);
    }

    @Override
    public String getDialogTitle() {
        return "Advanced Settings";
    }

    @Override
    protected void createContent(Composite container) {
        ComponentBuilder.label((Composite)container).text("Authentication Proxy Configuration").build();
        Composite container2 = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)1, (int)2048).gridSpacing(this.applyZoom(10)).margin(10).fillHorizontal().onSubmit(event -> this.okPressed()).build();
        this.optionsGroup = (Composite)ComponentBuilder.gridContainer((Composite)container2).gridSpacing(this.applyZoom(5)).fillHorizontal().onOptionChange((control, option) -> this.handleProxyOptionChange((ProxyOption)option)).build();
        ComponentBuilder.radio((Composite)this.optionsGroup).data((Object)ProxyOption.NO_PROXY).text("No proxy").fillHorizontal().build();
        ComponentBuilder.radio((Composite)this.optionsGroup).data((Object)ProxyOption.USE_SYSTEM).text("Use system proxy configuration").fillHorizontal().build();
        ComponentBuilder.radio((Composite)this.optionsGroup).data((Object)ProxyOption.MANUAL_CONFIG).text("Manual proxy configuration").fillHorizontal().build();
        Composite serverInfoContainer = (Composite)ComponentBuilder.gridContainer((Composite)container2).groupIndent().fillHorizontal().build();
        this.serverTypeInput = (SimpleComboBox)ComponentBuilder.simpleComboBox((Composite)serverInfoContainer, (int)0x800808).placeholder("Proxy server type").options(new String[]{"HTTP", "HTTPS", "SOCKS"}).select().fillHorizontal().build();
        Composite hostContainer = (Composite)ComponentBuilder.gridContainer((Composite)serverInfoContainer, (int)4, (boolean)true).fillHorizontal().build();
        this.addressInput = (SimpleTextField)ComponentBuilder.simpleTextField((Composite)hostContainer).placeholder("Address").colSpan(3).fillHorizontal().build();
        this.portInput = (SimpleTextField)ComponentBuilder.simpleTextField((Composite)hostContainer).placeholder("Port").fillHorizontal().build();
        this.portInput.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String text = AdvancedSettingsDialog.this.portInput.getText();
                String newText = text.substring(0, e.start) + e.text + text.substring(e.end);
                if (StringUtils.isEmpty((CharSequence)newText)) {
                    e.doit = true;
                    return;
                }
                try {
                    int val = Integer.parseInt(newText);
                    e.doit = val >= 0 && val <= 65535;
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                }
            }
        });
        this.excludesInput = (SimpleTextField)ComponentBuilder.simpleTextField((Composite)serverInfoContainer).placeholder(MessageConstants.LBL_EXCEPTION_LIST).fillHorizontal().build();
        Composite authContainer = (Composite)ComponentBuilder.gridContainer((Composite)container2).groupIndent().marginBottom(this.applyZoom(10)).fillHorizontal().build();
        this.authCheckBox = (Button)ComponentBuilder.checkBox((Composite)authContainer).text("Proxy server requires authentication").onSelection(event -> {
            boolean checked = this.authCheckBox.getSelection();
            this.usernameInput.setEnabled(checked);
            this.passwordInput.setEnabled(checked);
        }).build();
        Composite credentialContainer = (Composite)ComponentBuilder.gridContainer((Composite)authContainer).groupIndent().fillHorizontal().build();
        this.usernameInput = (SimpleTextField)ComponentBuilder.simpleTextField((Composite)credentialContainer).placeholder("Username").fillHorizontal().build();
        this.passwordInput = (SimpleTextField)ComponentBuilder.simpleTextField((Composite)credentialContainer, (int)16384).placeholder("Password").fillHorizontal().build();
        ComponentBuilder.label((Composite)container2, (int)4).linkButton().text("Learn more").fontSize(10).onClick(event -> ComponentUtil.triggerLink((String)DocumentationMessageConstants.AUTHENTICATION_PROXY)).build();
        Composite serverUrlContainer = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2, (int)0).marginTop(this.applyZoom(10)).build();
        ComponentBuilder.label((Composite)serverUrlContainer).text("License server address").build();
        HelpComposite helpIcon = (HelpComposite)ComponentBuilder.helpButton((Composite)serverUrlContainer, (String)DocumentationMessageConstants.SERVER_URL_IN_ADVANCED_SETTINGS_DIALOG, (int)0).build();
        helpIcon.setLayoutData((Object)new GridData(16384, 128, true, false));
        this.licenseServerUrlInput = (TextField)ComponentBuilder.textField((Composite)container, (int)65536).fillHorizontal().gridSpacing(ComponentUtil.applyZoom((int)2)).build();
        Composite browsweOptionContainer = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)1, (int)0).marginTop(this.applyZoom(10)).build();
        ComponentBuilder.label((Composite)browsweOptionContainer).text("Launch browser login site in").build();
        this.browserOptionComposite = (Composite)ComponentBuilder.gridContainer((Composite)browsweOptionContainer).gridSpacing(this.applyZoom(5)).fillHorizontal().onOptionChange((_control, option) -> this.setBrowserOption((BrowserLaunchMode)option)).build();
        Button inAppBrowser = (Button)ComponentBuilder.radio((Composite)this.browserOptionComposite).data((Object)BrowserLaunchMode.IN_APP).text(BrowserLaunchMode.IN_APP.getDisplayName()).fillHorizontal().build();
        Button systemBrowser = (Button)ComponentBuilder.radio((Composite)this.browserOptionComposite).data((Object)BrowserLaunchMode.SYSTEM).text(BrowserLaunchMode.SYSTEM.getDisplayName()).fillHorizontal().build();
        this.browserLaunchMode = ApplicationInfo.getBrowserLaunchMode();
        inAppBrowser.setSelection(this.browserLaunchMode == BrowserLaunchMode.IN_APP);
        systemBrowser.setSelection(this.browserLaunchMode == BrowserLaunchMode.SYSTEM);
    }

    private void handleProxyOptionChange(ProxyOption proxyOption) {
        boolean isManual = proxyOption == ProxyOption.MANUAL_CONFIG;
        this.serverTypeInput.setEnabled(isManual);
        this.addressInput.setEnabled(isManual);
        this.portInput.setEnabled(isManual);
        this.excludesInput.setEnabled(isManual);
        this.authCheckBox.setEnabled(isManual);
        boolean useAuth = this.authCheckBox.getSelection();
        this.usernameInput.setEnabled(isManual && useAuth);
        this.passwordInput.setEnabled(isManual && useAuth);
    }

    @Override
    protected void setInput() {
        this.loadProxySettings();
    }

    private void loadProxySettings() {
        ProxyInformation proxyInfo = ApplicationProxyUtil.getAuthProxyInformation();
        ProxyOption proxyOption = ProxyOption.valueOf((String)proxyInfo.getProxyOption());
        ComponentUtil.setRadioOption((Composite)this.optionsGroup, (Object)proxyOption);
        ComponentUtil.select((Widget)this.serverTypeInput, (String)proxyInfo.getProxyServerType());
        this.addressInput.setText(proxyInfo.getProxyServerAddress());
        this.portInput.setText(String.valueOf(proxyInfo.getProxyServerPort()));
        this.excludesInput.setText(proxyInfo.getExceptionList());
        if (StringUtils.isNotEmpty((CharSequence)proxyInfo.getUsername()) && StringUtils.isNotBlank((CharSequence)proxyInfo.getPassword())) {
            this.authCheckBox.setSelection(true);
        }
        this.usernameInput.setText(proxyInfo.getUsername());
        this.passwordInput.setText(proxyInfo.getPassword());
        String serverUrl = this.discoveryController.getDiscoveryServerUrl();
        this.licenseServerUrlInput.setText(serverUrl);
        this.handleProxyOptionChange(proxyOption);
    }

    @Override
    protected boolean useButtonBar() {
        return true;
    }

    @Override
    protected void createButtons(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).marginBottom(ComponentUtil.applyZoom((int)5)).fillHorizontal().build();
        Composite rightPart = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2, (boolean)true).gridSpacing(this.applyZoom(10)).fillHorizontal().right().build();
        ComponentBuilder.canvas((Composite)rightPart).text("Cancel").secondaryButton().autoSizeLG(100).fontSize(12).fillHorizontal().onClick(event -> this.cancelPressed()).build();
        ComponentBuilder.canvas((Composite)rightPart).text("Save").primaryButton3().autoSizeLG(100).fontSize(12).fillHorizontal().onClick(event -> {
            this.discoveryController.setDiscoveryServerUrl(this.licenseServerUrlInput.getText());
            this.okPressed();
        }).build();
    }

    protected void okPressed() {
        ProxyInformation proxyInfo = new ProxyInformation();
        proxyInfo.setProxyOption(((ProxyOption)this.optionsGroup.getData()).toString());
        proxyInfo.setProxyServerType(StringUtils.trim((String)this.serverTypeInput.getText()));
        proxyInfo.setProxyServerAddress(StringUtils.trim((String)this.addressInput.getText()));
        String portValue = StringUtils.trim((String)this.portInput.getText());
        proxyInfo.setProxyServerPort(StringUtils.isEmpty((CharSequence)portValue) ? String.valueOf(0) : portValue);
        boolean useAuth = this.authCheckBox.getSelection();
        proxyInfo.setUsername(useAuth ? StringUtils.trim((String)this.usernameInput.getText()) : "");
        proxyInfo.setPassword(useAuth ? StringUtils.trim((String)this.passwordInput.getText()) : "");
        proxyInfo.setExceptionList(StringUtils.trim((String)this.excludesInput.getText()));
        try {
            ApplicationProxyUtil.saveAuthProxyInformation((ProxyInformation)proxyInfo);
            ApplicationInfo.setBrowserLaunchMode((String)this.browserLaunchMode.toString());
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.PREF_MSG_UNABLE_TO_SAVE_PROXY_CONFIG);
        }
        super.okPressed();
    }

    public BrowserLaunchMode getBrowserOption() {
        return this.browserLaunchMode;
    }

    public void setBrowserOption(BrowserLaunchMode browserLaunchMode) {
        this.browserLaunchMode = browserLaunchMode;
    }
}

