/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.parts;

import com.kms.katalon.composer.components.operation.OperationExecutor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;
import org.eclipse.ui.operations.OperationHistoryActionHandler;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.WorkbenchPart;

public abstract class CPart
extends WorkbenchPart {
    protected OperationExecutor operationExecutor;
    private Map<String, String> actionIdByCommandId = new HashMap<String, String>();
    private Map<String, IHandlerActivation> activationsByActionId = new HashMap<String, IHandlerActivation>();
    private Expression expression;

    public void initialize(MPart mPart, EPartService partService) {
        this.setSite((IWorkbenchPartSite)new CPartSite(this, mPart));
        this.operationExecutor = new OperationExecutor((Object)this);
        this.expression = new ActivePartExpression(mPart, partService);
        this.createUndoRedoActions();
    }

    public void createPartControl(Composite parent) {
    }

    public void setFocus() {
    }

    private void createUndoRedoActions() {
        UndoActionHandler undoAction = new UndoActionHandler(this.getSite(), this.operationExecutor.getUndoContext());
        undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.setGlobalActionHandler(ActionFactory.UNDO.getId(), (OperationHistoryActionHandler)undoAction);
        RedoActionHandler redoAction = new RedoActionHandler(this.getSite(), this.operationExecutor.getUndoContext());
        redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.setGlobalActionHandler(ActionFactory.REDO.getId(), (OperationHistoryActionHandler)redoAction);
    }

    private void setGlobalActionHandler(String actionID, OperationHistoryActionHandler handler) {
        IHandlerActivation value;
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        if (handler != null) {
            IHandlerActivation value2;
            String commandId = null;
            IActionCommandMappingService mappingService = (IActionCommandMappingService)PlatformUI.getWorkbench().getService(IActionCommandMappingService.class);
            if (mappingService != null) {
                commandId = mappingService.getCommandId(actionID);
            }
            if (commandId == null) {
                commandId = handler.getActionDefinitionId();
            }
            if (this.activationsByActionId.containsKey(actionID)) {
                value2 = this.activationsByActionId.remove(actionID);
                if (value2 instanceof IHandlerActivation) {
                    activation = value2;
                    this.actionIdByCommandId.remove(activation.getCommandId());
                    if (service != null) {
                        service.deactivateHandler(activation);
                    }
                    activation.getHandler().dispose();
                }
            } else if (commandId != null && this.actionIdByCommandId.containsKey(commandId) && (value2 = this.activationsByActionId.remove(this.actionIdByCommandId.remove(commandId))) instanceof IHandlerActivation) {
                activation = value2;
                if (service != null) {
                    service.deactivateHandler(activation);
                }
                activation.getHandler().dispose();
            }
            if (commandId != null) {
                this.actionIdByCommandId.put(commandId, actionID);
                ActionHandler actionHandler = new ActionHandler((IAction)handler);
                Expression handlerExpression = this.expression;
                if (service != null) {
                    IHandlerActivation activation = service.activateHandler(commandId, (IHandler)actionHandler, handlerExpression);
                    this.activationsByActionId.put(actionID, activation);
                }
            }
        } else if (this.activationsByActionId != null && this.activationsByActionId.containsKey(actionID) && (value = this.activationsByActionId.remove(actionID)) instanceof IHandlerActivation) {
            IHandlerActivation activation = value;
            this.actionIdByCommandId.remove(activation.getCommandId());
            service.deactivateHandler(activation);
            activation.getHandler().dispose();
        }
    }

    public IStatus executeOperation(IUndoableOperation operation, IProgressMonitor progressMonitor, IAdaptable adaptable) {
        return this.operationExecutor.executeOperation(operation, progressMonitor, adaptable);
    }

    public IStatus executeOperation(IUndoableOperation operation, IAdaptable adaptable) {
        return this.executeOperation(operation, (IProgressMonitor)new NullProgressMonitor(), adaptable);
    }

    public IStatus executeOperation(IUndoableOperation operation) {
        return this.executeOperation(operation, null);
    }

    public IStatus undoOperation(IAdaptable adaptable, IProgressMonitor progressMonitor) {
        return this.operationExecutor.undoOperation(adaptable, progressMonitor);
    }

    public IStatus undoOperation(IAdaptable adaptable) {
        return this.undoOperation(adaptable, (IProgressMonitor)new NullProgressMonitor());
    }

    public IStatus undoOperation() {
        return this.undoOperation(null);
    }

    public IStatus redoOperation(IAdaptable adaptable, IProgressMonitor progressMonitor) {
        return this.operationExecutor.undoOperation(adaptable, progressMonitor);
    }

    public IStatus redoOperation(IAdaptable adaptable) {
        return this.redoOperation(adaptable, (IProgressMonitor)new NullProgressMonitor());
    }

    public IStatus redoOperation() {
        return this.redoOperation(null);
    }

    public void clearHistory() {
        this.operationExecutor.refresh();
        this.createUndoRedoActions();
    }

    public class ActivePartExpression
    extends Expression {
        private EPartService partService;
        private MPart mPart;

        public ActivePartExpression(MPart mPart, EPartService partService) {
            this.partService = partService;
            this.mPart = mPart;
        }

        public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
            if (this.mPart.equals(this.partService.getActivePart()) && !this.isModalDialogPresent()) {
                return EvaluationResult.TRUE;
            }
            return EvaluationResult.FALSE;
        }

        private boolean isModalDialogPresent() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            return workbench.getDisplay().getActiveShell() != workbench.getActiveWorkbenchWindow().getShell();
        }
    }

    public class CPartSite
    extends PartSite {
        public CPartSite(CPart part, MPart mPart) {
            super(mPart, (IWorkbenchPart)part, null, null);
        }
    }
}

