/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.toolbar;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.toolbar.CommunityContextMenuPopover;
import com.kms.katalon.composer.toolbar.CommunitySurveyPopover;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.License;
import com.kms.katalon.session.core.model.LicenseType;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.services.ISessionController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class CommunityToolControl {
    private final String TIMESTAMP_FORMAT = "HH:mm:ss - dd/MM/yyyy";
    private static final long TWO_WEEKS = 14L;
    private CommunitySurveyPopover communityPopover;
    private CommunityContextMenuPopover communityMenuPopover;
    private ToolBar toolbar;
    private ToolItem communityToolItem;
    private LicenseType licenseType;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ISessionController sessionController;

    @PostConstruct
    void createWidget(Composite parent, MToolControl toolControl) {
        this.toolbar = new ToolBar(parent, 0x820000);
        this.toolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.communityToolItem = new ToolItem(this.toolbar, 0);
        this.communityToolItem.setImage(ImageConstants.IMG_KATALON_COMMUNITY_24);
        this.eventBroker.subscribe("ACTIVATION/DEACTIVATED", event -> this.getPopoverTakeSurvey().closeImmediately());
        ComponentEventUtil.trackMouseState((Control)this.toolbar);
        ComponentEventUtil.onMouseEnter((Control)this.toolbar, event -> {
            if (!ControlUtil.isDisposed((Widget)this.communityMenuPopover)) {
                this.communityMenuPopover.closeImmediately();
            }
            this.getPopover().open();
        });
        ComponentEventUtil.onMouseLeave((Control)this.toolbar, event -> UITimeUtil.setTimeout(() -> {
            if (ControlUtil.isHovering((Control)this.getPopover())) {
                return;
            }
            this.getPopover().close();
        }, (long)300L));
    }

    private CommunityContextMenuPopover getPopover() {
        if (ControlUtil.isDisposed((Widget)this.communityMenuPopover)) {
            this.communityMenuPopover = new CommunityContextMenuPopover(this.toolbar.getShell(), (Widget)this.communityToolItem, 0, 132096);
            BundleContext bundleContext = FrameworkUtil.getBundle(CommunityToolControl.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            ContextInjectionFactory.inject((Object)((Object)this.communityMenuPopover), (IEclipseContext)context);
            ComponentEventUtil.trackMouseState((Control)this.communityMenuPopover);
            ComponentEventUtil.onMouseLeave((Control)this.communityMenuPopover, event -> UITimeUtil.setTimeout(() -> {
                if (ControlUtil.isHovering((Control)this.toolbar)) {
                    return;
                }
                this.getPopover().close();
            }, (long)200L));
        }
        return this.communityMenuPopover;
    }

    private CommunitySurveyPopover getPopoverTakeSurvey() {
        if (ControlUtil.isDisposed((Widget)this.communityPopover)) {
            this.communityPopover = new CommunitySurveyPopover(this.toolbar.getShell(), (Widget)this.communityToolItem, 0, 132096);
        }
        return this.communityPopover;
    }

    private boolean displayFeedback() {
        Session session = this.sessionController.getSession();
        License license = session.getLicense();
        this.licenseType = license.getLicenseType();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss - dd/MM/yyyy");
        UserProfile curUser = UserProfileHelper.getCurrentProfile();
        try {
            if (!curUser.getSkipFeedback()) {
                String currentDate = dateFormat.format(new Date());
                if (curUser.getUsedNewVersionAt() == null) {
                    curUser.setUsedNewVersionAt(currentDate);
                    UserProfileHelper.saveProfile((UserProfile)curUser);
                }
                if (this.licenseType == LicenseType.ENTERPRISE) {
                    long diffInDays = TimeUnit.DAYS.convert(dateFormat.parse(currentDate).getTime() - dateFormat.parse(curUser.getUsedNewVersionAt()).getTime(), TimeUnit.MILLISECONDS);
                    return diffInDays > 14L;
                }
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
        return false;
    }
}

