/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.toolbar;

import com.kms.katalon.composer.components.impl.control.DropdownToolItemSelectionListener;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.handlers.DeactivateHandler;
import com.kms.katalon.composer.handlers.KatalonStoreLoginHandler;
import com.kms.katalon.composer.handlers.ManageKStoreCLIKeysHandler;
import com.kms.katalon.composer.handlers.ManagePluginsHandler;
import com.kms.katalon.composer.handlers.OpenPlanGridExecutionHandler;
import com.kms.katalon.composer.handlers.OpenPluginHelpPageHandler;
import com.kms.katalon.composer.handlers.ReloadPluginsHandler;
import com.kms.katalon.composer.handlers.SearchPluginsHandler;
import com.kms.katalon.composer.handlers.ViewDashboardHandler;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.services.ISessionController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class PluginStoreToolControl {
    @Inject
    IEclipseContext context;
    @Inject
    IEventBroker eventBroker;
    @Inject
    ISessionController sessionController;

    @PostConstruct
    void createWidget(Composite parent, MToolControl toolControl) {
        final ToolBar toolbar = new ToolBar(parent, 0x820000);
        toolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        ToolItem accountToolItem = new ToolItem(toolbar, 4);
        accountToolItem.setImage(ImageConstants.IMG_KATALON_ACCOUNT_24);
        accountToolItem.addSelectionListener((SelectionListener)new DropdownToolItemSelectionListener(){

            protected Menu getMenu() {
                Menu menu = new Menu((Control)toolbar);
                Session session = PluginStoreToolControl.this.sessionController.getSession();
                if (session.getLicense() == null) {
                    MenuItem loginMenuItem = new MenuItem(menu, 8);
                    loginMenuItem.setText(StringConstants.Account_LOG_IN);
                    loginMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            new KatalonStoreLoginHandler().execute();
                        }
                    });
                    new MenuItem(menu, 2);
                }
                if (PluginStoreToolControl.this.isLoggedIn()) {
                    MenuItem userNameMenuItem = new MenuItem(menu, 8);
                    String username = "";
                    try {
                        username = PluginStoreToolControl.this.sessionController.getSession().getUser().getEmail();
                    }
                    catch (Exception e) {
                        LogUtil.logError((Throwable)e);
                    }
                    userNameMenuItem.setText(MessageFormat.format(StringConstants.Account_LOGIN_AS, username));
                    new MenuItem(menu, 2);
                    MenuItem viewDashboardMenuItem = new MenuItem(menu, 8);
                    viewDashboardMenuItem.setText(StringConstants.Account_VIEW_DASHBOARD);
                    viewDashboardMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            new ViewDashboardHandler().execute();
                        }
                    });
                    MenuItem planGridExecutionMenuItem = new MenuItem(menu, 8);
                    planGridExecutionMenuItem.setText(StringConstants.Account_PLAN_GRID_EXECUTION);
                    planGridExecutionMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            new OpenPlanGridExecutionHandler().execute();
                        }
                    });
                    new MenuItem(menu, 2);
                }
                if (PluginStoreToolControl.this.isLoggedIn()) {
                    MenuItem visitStoreMenuItem = new MenuItem(menu, 8);
                    visitStoreMenuItem.setText(StringConstants.Account_VISIT_PLUGIN);
                    visitStoreMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            new SearchPluginsHandler().execute();
                        }
                    });
                }
                MenuItem reloadPluginMenuItem = new MenuItem(menu, 8);
                reloadPluginMenuItem.setText(StringConstants.Account_RELOAD_PLUGIN);
                reloadPluginMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ReloadPluginsHandler reloadPluginsHandler = new ReloadPluginsHandler();
                        ContextInjectionFactory.inject((Object)reloadPluginsHandler, (IEclipseContext)(this).PluginStoreToolControl.this.context);
                        reloadPluginsHandler.execute();
                    }
                });
                if (PluginStoreToolControl.this.isLoggedIn()) {
                    MenuItem managePluginMenuItem = new MenuItem(menu, 8);
                    managePluginMenuItem.setText(StringConstants.Account_MANAGE_PLUGIN);
                    managePluginMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            new ManagePluginsHandler().execute();
                        }
                    });
                }
                if (PluginStoreToolControl.this.isLoggedIn()) {
                    new MenuItem(menu, 2);
                    MenuItem manageApiKeyMenuItem = new MenuItem(menu, 8);
                    manageApiKeyMenuItem.setText(StringConstants.Account_MANAGE_API_KEY);
                    manageApiKeyMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            new ManageKStoreCLIKeysHandler().execute();
                        }
                    });
                }
                new MenuItem(menu, 2);
                MenuItem logoutMenuItem = new MenuItem(menu, 8);
                logoutMenuItem.setText(StringConstants.Account_LOG_OUT);
                logoutMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DeactivateHandler.getInstance().execute();
                    }
                });
                MenuItem helpMenuItem = new MenuItem(menu, 8);
                helpMenuItem.setText(StringConstants.Account_HELP);
                helpMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        new OpenPluginHelpPageHandler().execute();
                    }
                });
                return menu;
            }
        });
        this.eventBroker.subscribe("ACTIVATION/CHECKED", new EventHandler(){

            public void handleEvent(Event event) {
                PluginStoreToolControl.this.eventBroker.post("WORKSPACE/PLUGIN_LOADED", null);
            }
        });
        this.eventBroker.subscribe("PROJECT/OPENED", new EventHandler(){

            public void handleEvent(Event event) {
                ReloadPluginsHandler reloadPluginsHandler = new ReloadPluginsHandler();
                ContextInjectionFactory.inject((Object)reloadPluginsHandler, (IEclipseContext)PluginStoreToolControl.this.context);
                reloadPluginsHandler.reloadPlugins(true);
                PluginStoreToolControl.this.eventBroker.post("PROJECT/LOAD_CLASS", null);
            }
        });
    }

    private boolean isLoggedIn() {
        return ObjectUtils.isNotEmpty((Object)this.sessionController.getSession().getUser());
    }
}

