/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.application;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.core.application.ApplicationWorkbenchWindowAdvisor;
import com.kms.katalon.plugin.dialog.FirstTimeUseDialog;
import com.kms.katalon.session.core.model.LicenseType;
import com.kms.katalon.session.core.services.ISessionController;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.WorkbenchErrorHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final String GREPCLIPSE_PACKAGE_NAME_PREFIX = "org.codehaus.groovy.eclipse";
    private AbstractStatusHandler workbenchErrorHandler;
    private IEventBroker eventBroker;
    private ISessionController sessionController;
    private LicenseType cachedLicenseType;

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        ApplicationWorkbenchWindowAdvisor workbenchWindowAdvisor = new ApplicationWorkbenchWindowAdvisor(configurer);
        BundleContext bundleContext = FrameworkUtil.getBundle(ApplicationWorkbenchAdvisor.class).getBundleContext();
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        ContextInjectionFactory.inject((Object)((Object)workbenchWindowAdvisor), (IEclipseContext)context);
        this.eventBroker = (IEventBroker)context.get(IEventBroker.class);
        this.sessionController = (ISessionController)context.get(ISessionController.class);
        this.eventBroker.subscribe("ACTIVATION/CHECKED", new EventHandler(){

            public void handleEvent(Event event) {
                ApplicationWorkbenchAdvisor.this.cachedLicenseType = ApplicationWorkbenchAdvisor.this.sessionController.getLicenseType();
            }
        });
        return workbenchWindowAdvisor;
    }

    public String getInitialWindowPerspectiveId() {
        return "com.kms.katalon.composer.perspective.keyword";
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        IDE.registerAdapters();
        configurer.setSaveAndRestore(true);
    }

    public synchronized AbstractStatusHandler getWorkbenchErrorHandler() {
        if (this.workbenchErrorHandler != null) {
            return this.workbenchErrorHandler;
        }
        this.workbenchErrorHandler = new WorkbenchErrorHandler(){

            public void handle(StatusAdapter statusAdapter, int style) {
                if (this.isGroovyEditorError(statusAdapter)) {
                    this.handleGroovyEditorError(statusAdapter);
                    return;
                }
                super.handle(statusAdapter, style);
            }

            private void handleGroovyEditorError(StatusAdapter statusAdapter) {
                super.handle(statusAdapter, 1);
            }

            private boolean isGroovyEditorError(StatusAdapter statusAdapter) {
                IStatus status = statusAdapter.getStatus();
                if (!(status.getException() instanceof StringIndexOutOfBoundsException)) {
                    return false;
                }
                StackTraceElement[] stackTraces = status.getException().getStackTrace();
                if (stackTraces.length < 2) {
                    return false;
                }
                return stackTraces[1].getClassName().startsWith(ApplicationWorkbenchAdvisor.GREPCLIPSE_PACKAGE_NAME_PREFIX);
            }
        };
        return this.workbenchErrorHandler;
    }

    public boolean preShutdown() {
        this.showFirstTimeUseSurvey();
        return true;
    }

    private void showFirstTimeUseSurvey() {
        boolean isNonPaidLicense;
        String userEmail = ApplicationContext.getInstance().getUserId();
        UserProfile userProfile = UserProfileHelper.getOrCreateProfile((String)userEmail);
        if (StringUtils.isBlank((CharSequence)userEmail) || userProfile.isDoneFirstTimeUseSurvey()) {
            return;
        }
        boolean bl = isNonPaidLicense = this.cachedLicenseType != LicenseType.ENTERPRISE;
        if (isNonPaidLicense) {
            FirstTimeUseDialog dialog = new FirstTimeUseDialog(Display.getCurrent().getActiveShell());
            dialog.open();
            userProfile = UserProfileHelper.getCurrentProfile();
            userProfile.setDoneFirstTimeUseSurvey(true);
            UserProfileHelper.saveProfile((UserProfile)userProfile);
        }
    }
}

