/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.handler.CommandCaller;
import com.kms.katalon.logging.LogUtil;
import java.util.ArrayList;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class CommandUtil {
    public static final String DEFAULT_ERROR_TITLE = "Execute command exception";

    public static Object autoHandleExecuteCommand(String commandId) {
        return CommandUtil.autoHandleExecuteCommand(commandId, null, DEFAULT_ERROR_TITLE);
    }

    public static Object autoHandleExecuteCommand(String commandId, String errorTitle) {
        return CommandUtil.autoHandleExecuteCommand(commandId, null, errorTitle);
    }

    public static Object autoHandleExecuteCommand(String commandId, Event event) {
        return CommandUtil.autoHandleExecuteCommand(commandId, event, DEFAULT_ERROR_TITLE);
    }

    public static Object autoHandleExecuteCommand(String commandId, Event event, String errorTitle) {
        try {
            return CommandUtil.executeCommand(commandId);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException error) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)error, (String)errorTitle, (String)error.getMessage(), (Shell)Display.getCurrent().getActiveShell());
            return null;
        }
    }

    public static Object safeExecuteCommand(String commandId) {
        return CommandUtil.safeExecuteCommand(commandId, null);
    }

    public static Object safeExecuteCommand(String commandId, Event event) {
        try {
            return CommandUtil.executeCommand(commandId, event);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException error) {
            LogUtil.logError((Throwable)error);
            return null;
        }
    }

    public static Object executeCommand(String commandId) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        return CommandUtil.executeCommand(commandId, null);
    }

    public static Object executeCommand(String commandId, Event event) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IHandlerService handlerService = (IHandlerService)window.getService(IHandlerService.class);
        return handlerService.executeCommand(commandId, event);
    }

    public static ParameterizedCommand buildCommand(String commandId, String ... parameters) {
        Command command = ((ICommandService)CommandCaller.getService(ICommandService.class)).getCommand(commandId);
        ArrayList<Parameterization> params = new ArrayList<Parameterization>();
        int i = 0;
        while (i < parameters.length - 1) {
            String key = parameters[i];
            String value = parameters[i + 1];
            try {
                IParameter param = command.getParameter(key);
                if (param != null) {
                    params.add(new Parameterization(param, value));
                }
            }
            catch (NotDefinedException notDefinedException) {}
            i += 2;
        }
        ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, params.toArray(new Parameterization[params.size()]));
        return parameterizedCommand;
    }

    public static Object autoHandleExecuteCommand(ParameterizedCommand parameterizedCommand) {
        return CommandUtil.autoHandleExecuteCommand(parameterizedCommand, null, DEFAULT_ERROR_TITLE);
    }

    public static Object autoHandleExecuteCommand(ParameterizedCommand parameterizedCommand, String errorTitle) {
        return CommandUtil.autoHandleExecuteCommand(parameterizedCommand, null, errorTitle);
    }

    public static Object autoHandleExecuteCommand(ParameterizedCommand parameterizedCommand, Event event) {
        return CommandUtil.autoHandleExecuteCommand(parameterizedCommand, event, DEFAULT_ERROR_TITLE);
    }

    public static Object autoHandleExecuteCommand(ParameterizedCommand parameterizedCommand, Event event, String errorTitle) {
        try {
            return CommandUtil.executeCommand(parameterizedCommand);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException error) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)error, (String)errorTitle, (String)error.getMessage(), (Shell)Display.getCurrent().getActiveShell());
            return null;
        }
    }

    public static Object safeExecuteCommand(ParameterizedCommand parameterizedCommand) {
        return CommandUtil.safeExecuteCommand(parameterizedCommand, null);
    }

    public static Object safeExecuteCommand(ParameterizedCommand parameterizedCommand, Event event) {
        try {
            return CommandUtil.executeCommand(parameterizedCommand, event);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException error) {
            LogUtil.logError((Throwable)error);
            return null;
        }
    }

    public static Object executeCommand(ParameterizedCommand parameterizedCommand) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        return CommandUtil.executeCommand(parameterizedCommand, null);
    }

    public static Object executeCommand(ParameterizedCommand parameterizedCommand, Event event) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IHandlerService handlerService = (IHandlerService)window.getService(IHandlerService.class);
        return handlerService.executeCommand(parameterizedCommand, event);
    }
}

