/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.util.ComponentUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class KREUtil {
    private static final String KRE_DOWNLOAD_LINK_FOR_WINDOWS = "https://download.katalon.com/%s/Katalon_Studio_Engine_Windows_64-%s.zip";
    private static final String KRE_DOWNLOAD_LINK_FOR_MAC = "https://download.katalon.com/%s/Katalon_Studio_Engine_MacOS-%s.tar.gz";
    private static final String KRE_DOWNLOAD_LINK_FOR_LINUX = "https://download.katalon.com/%s/Katalon_Studio_Engine_Linux_64-%s.tar.gz";

    private KREUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void downloadKRE() {
        String downloadKERLink = KREUtil.getDownloadKRELink();
        if (StringUtils.isNotBlank((CharSequence)downloadKERLink)) {
            ComponentUtil.triggerLink((String)downloadKERLink);
        }
    }

    private static String getDownloadKRELink() {
        String appVersion = ApplicationInfo.officialReleaseVersion();
        if (SystemUtils.IS_OS_WINDOWS) {
            return KREUtil.getDonwloadKRELinkForWindows(appVersion);
        }
        if (SystemUtils.IS_OS_MAC) {
            return KREUtil.getDonwloadKRELinkForMac(appVersion);
        }
        if (SystemUtils.IS_OS_LINUX) {
            return KREUtil.getDonwloadKRELinkForLinux(appVersion);
        }
        return null;
    }

    private static String getDonwloadKRELinkForWindows(String appVersion) {
        return String.format(KRE_DOWNLOAD_LINK_FOR_WINDOWS, appVersion, appVersion);
    }

    private static String getDonwloadKRELinkForMac(String appVersion) {
        return String.format(KRE_DOWNLOAD_LINK_FOR_MAC, appVersion, appVersion);
    }

    private static String getDonwloadKRELinkForLinux(String appVersion) {
        return String.format(KRE_DOWNLOAD_LINK_FOR_LINUX, appVersion, appVersion);
    }
}

