/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.handlers.CheckForUpdatesHandler;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import com.kms.katalon.webserver.types.WebViewAction;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Shell;

public class KatalonActionHandler
extends CustomHttpHandler {
    private static final String REPLAY_QUICK_START = "Replay Quick Start";
    public static final String KATALON_ANALYTICS_SETTING_PAGE_ID = "com.kms.katalon.composer.integration.analytics.page";
    private static String testSuiteName = "";
    @Inject
    private IEclipseContext eclipseContext;
    @Inject
    private IEventBroker eventBroker;

    @Override
    public void customHandle(CustomRequest req) throws IOException {
        if (this.handlePrefightRequestAndCORS(req)) {
            return;
        }
        String rawAction = req.query("action");
        if (StringUtils.isNotBlank((CharSequence)rawAction)) {
            WebViewAction action = WebViewAction.valueOf(rawAction);
            switch (action) {
                case CHECK_FOR_UPDATE: {
                    new CheckForUpdatesHandler().checkForUpdate(false);
                    break;
                }
                case REVIEW_BEST_PRACTICE: {
                    String bestPracticeUrl = req.query("url");
                    String rawBestPracticeReview = req.query("review");
                    boolean bestPracticeReview = Boolean.parseBoolean(rawBestPracticeReview);
                    UserProfile curUser = UserProfileHelper.getCurrentProfile();
                    curUser.addBestPracticeReview(bestPracticeUrl, bestPracticeReview);
                    UserProfileHelper.saveProfile((UserProfile)curUser);
                    break;
                }
                case I_GOT_IT_BTN_CLICKED: {
                    break;
                }
                case SEND_STUDIOASSIST_FEEDBACK: {
                    this.trackStudioAssistFeedback(req);
                    this.closeFeedbackDialogAfterDelay();
                    break;
                }
                case INTEGRATE_WITH_PLATFORM: {
                    this.openIntegrateWithPlatform();
                    break;
                }
                case OPEN_STUDIOASSIST_CHAT: {
                    this.openStudioAssist();
                    break;
                }
            }
        }
        req.end();
    }

    private void trackStudioAssistFeedback(CustomRequest request) {
        Map<String, Object> object = request.getRequestObject();
        Trackings.trackStudioAssistFeedback((int)((Integer)object.get("numOfStars")), (String)((String)object.get("feedback")));
    }

    private void closeFeedbackDialogAfterDelay() {
        UISynchronizeService.asyncExec(() -> {
            Shell quickStartOverviewShell = ComponentFinder.findShell((String)"Share Your Feedback");
            UITimeUtil.setTimeout(() -> DialogUtil.close((Shell)quickStartOverviewShell), (long)3000L);
        });
    }

    private void openIntegrateWithPlatform() {
        this.eventBroker.post("PROJECT/SETTINGS_PAGE", (Object)KATALON_ANALYTICS_SETTING_PAGE_ID);
    }

    private void openStudioAssist() {
        this.eventBroker.post("STUDIOASSIST/OPEN_CHAT", null);
    }
}

