/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.core.util.JsonBuilder;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.License;
import com.kms.katalon.session.core.model.LicenseType;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.model.exception.SessionException;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.model.AnalyticsTeam;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import com.kms.katalon.webserver.types.KatalonInfo;
import com.kms.katalon.webserver.types.ProjectConfiguration;
import jakarta.inject.Inject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class KatalonInfoHandler
extends CustomHttpHandler {
    private static String EMPTY_JSON_OBJECT_STRING = "{}";
    private static String KSE_EXPIRATION_DATE_KEY = "KSE";
    private static String KRE_EXPIRATION_DATE_KEY = "KRE";
    @Inject
    private ISessionController sessionController;
    @Inject
    private IDiscoveryController discoveryController;

    @Override
    public void customHandle(CustomRequest req) throws IOException {
        if (this.handlePrefightRequestAndCORS(req)) {
            return;
        }
        String rawRequestedInfo = req.query("info");
        KatalonInfo requestedInfo = KatalonInfo.valueOf(rawRequestedInfo);
        switch (requestedInfo) {
            case VERSION: {
                req.send(this.getVersion());
                break;
            }
            case BUILD_NUMBER: {
                req.send(this.getBuildNumber());
                break;
            }
            case USER_PROFILE: {
                req.send(UserProfileHelper.getCurrentProfile());
                break;
            }
            case PROJECT_CONFIGURATION: {
                req.send(this.getProjectConfiguration(req));
                break;
            }
            case IS_OPENED_PROJECT: {
                req.send(this.isOpenedProject());
                break;
            }
            case IS_ON_PREM_ACTIVATION: {
                req.send(false);
                break;
            }
            case KATALON_EDITION: {
                req.send(ApplicationEdition.get().name());
                break;
            }
            case LICENSE: {
                req.send(this.getLicenseInfo());
                break;
            }
        }
        req.end();
    }

    private String getVersion() {
        return ApplicationInfo.versionNo();
    }

    private int getBuildNumber() {
        return VersionUtil.getCurrentVersion().getBuildNumber();
    }

    private String getLicenseInfo() {
        Session session = this.sessionController.getSession();
        License license = session.getLicense();
        if (license == null) {
            return EMPTY_JSON_OBJECT_STRING;
        }
        LicenseType licenseType = license.getLicenseType();
        JsonBuilder jsonBuilder = JsonBuilder.object();
        jsonBuilder.property("type", (Object)licenseType.toString());
        if (license.isOffline()) {
            Long expirationDate = license.getExpirationDate();
            if (expirationDate == null) {
                return jsonBuilder.toJson();
            }
            jsonBuilder.property("expirationDate", Map.of(KSE_EXPIRATION_DATE_KEY, this.formatDate(new Date(expirationDate * 1000L))));
            return jsonBuilder.toJson();
        }
        if (licenseType == LicenseType.TRIAL || licenseType == LicenseType.FREE) {
            Date trialExpirationDate = ApplicationContext.getInstance().getExpirationTrial();
            jsonBuilder.property("expirationDate", Map.of(KSE_EXPIRATION_DATE_KEY, trialExpirationDate, KRE_EXPIRATION_DATE_KEY, trialExpirationDate));
            return jsonBuilder.toJson();
        }
        if (licenseType == LicenseType.ENTERPRISE || licenseType == LicenseType.EDUCATION) {
            String kre;
            HashMap<String, String> expirationDate = new HashMap<String, String>();
            String kse = this.getKSELicenseExpirationDate();
            if (StringUtils.isNotBlank((String)kse)) {
                expirationDate.put(KSE_EXPIRATION_DATE_KEY, kse);
            }
            if (StringUtils.isNotBlank((String)(kre = this.getKRELicenseExpirationDate()))) {
                expirationDate.put(KRE_EXPIRATION_DATE_KEY, kre);
            }
            if (!expirationDate.isEmpty()) {
                jsonBuilder.property("expirationDate", expirationDate);
            }
            return jsonBuilder.toJson();
        }
        return jsonBuilder.toJson();
    }

    private ProjectConfiguration getProjectConfiguration(CustomRequest req) {
        ProjectConfiguration projectConfiguration = new ProjectConfiguration();
        boolean isIntegrationEnabled = false;
        boolean isInKsProject = false;
        ProjectConfiguration.TestOpsProject testOpsProject = null;
        String testOpsServerUrl = this.discoveryController.getServerUrl(ServerType.TESTOPS);
        AnalyticsSettingStore analyticsSettingStore = AnalyticsSettingStore.getStore();
        if (analyticsSettingStore != null) {
            isInKsProject = true;
            isIntegrationEnabled = analyticsSettingStore.isIntegrationEnabled();
            if (isIntegrationEnabled) {
                AnalyticsTeam analyticsTeam;
                Organization analyticsOrganization;
                testOpsProject = new ProjectConfiguration.TestOpsProject();
                AnalyticsProject analyticsProject = analyticsSettingStore.getProject();
                if (analyticsProject != null) {
                    testOpsProject.setId(analyticsProject.getId());
                    testOpsProject.setName(analyticsProject.getName());
                }
                if ((analyticsOrganization = analyticsSettingStore.getOrganization()) != null) {
                    testOpsProject.setOrganizationId(analyticsOrganization.getId());
                    testOpsProject.setOrganizationName(analyticsOrganization.getName());
                }
                if ((analyticsTeam = analyticsSettingStore.getTeam()) != null) {
                    testOpsProject.setTeamId(analyticsTeam.getId());
                    testOpsProject.setTeamName(analyticsTeam.getName());
                }
                testOpsServerUrl = analyticsSettingStore.getServerEndpoint();
            }
        }
        projectConfiguration.setTestOpsProject(testOpsProject);
        projectConfiguration.setTestOpsServerUrl(testOpsServerUrl);
        projectConfiguration.setIntegrationEnabled(isIntegrationEnabled);
        projectConfiguration.setInKsProject(isInKsProject);
        return projectConfiguration;
    }

    private boolean isOpenedProject() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    private String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("MMMMM dd, yyyy");
        return formatter.format(date);
    }

    private String getKRELicenseExpirationDate() {
        try {
            Date date = this.sessionController.getExpirationOnline("ENGINE");
            if (date != null) {
                return this.formatDate(date);
            }
        }
        catch (SessionException e) {
            LogUtil.logError((Throwable)e);
        }
        return "";
    }

    private String getKSELicenseExpirationDate() {
        Session session = this.sessionController.getSession();
        License license = session.getLicense();
        if (license.isOffline()) {
            Instant instant = Instant.ofEpochMilli(license.getExpirationDate());
            return Date.from(instant).toString();
        }
        try {
            Date date = this.sessionController.getExpirationOnline(session.getLicenseFeature());
            if (date != null) {
                return this.formatDate(date);
            }
        }
        catch (SessionException e) {
            LogUtil.logError((Throwable)e);
        }
        return "";
    }
}

