/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.composer.components.impl.util.ResourcesUtil;
import com.kms.katalon.core.util.MimeTypeUtil;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;

public class StaticFileHandler
extends CustomHttpHandler {
    private String rootFolder;

    public StaticFileHandler(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    @Override
    public void customHandle(CustomRequest req) throws IOException {
        String path = req.getURI().getPath();
        byte[] content = this.getResource(path);
        String contentType = null;
        contentType = this.shouldUseHtmlContentType(path) ? "text/html" : MimeTypeUtil.getMimeType((String)path);
        if (contentType != null) {
            req.setHeader("Content-Type", contentType);
        }
        if (StringUtils.equals((CharSequence)req.getMethod(), (CharSequence)"HEAD")) {
            if (content.length <= 0) {
                req.sendResponseHeaders(400, -1);
                return;
            }
            req.setHeader("Content-Length", content.length);
            req.sendResponseHeaders(200, -1);
            return;
        }
        req.send(content);
    }

    private byte[] getResource(String filePath) throws IOException {
        String fullPath = StringUtils.defaultString((String)this.rootFolder) + filePath;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fullPath);
        if (inputStream == null) {
            String toAsset = this.rootFolder + "/index.html";
            inputStream = this.getClass().getClassLoader().getResourceAsStream(toAsset);
        }
        return ResourcesUtil.readResource((InputStream)inputStream, (boolean)false);
    }

    private byte[] getDevResource(String filePath) throws IOException {
        FileInputStream inputStream;
        String fullPath = StringUtils.defaultString((String)this.rootFolder) + filePath;
        FileInputStream fileInputStream = inputStream = new File(fullPath).exists() ? new FileInputStream(fullPath) : null;
        if (inputStream == null) {
            String toAsset = this.rootFolder + "/index.html";
            inputStream = new FileInputStream(toAsset);
        }
        return ResourcesUtil.readResource((InputStream)inputStream, (boolean)false);
    }

    private boolean shouldUseHtmlContentType(String path) {
        return path.contains("KnowledgeHub");
    }
}

