/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.ai.core.dto.StudioAssistAcceptAnswerRequest;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import jakarta.inject.Inject;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistChatAcceptAnswerHandler
extends CustomHttpHandler {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistChatAcceptAnswerHandler.class);
    @Inject
    private IEventBroker eventBroker;

    @Override
    public void customHandle(CustomRequest req) throws IOException {
        String requestDataAsString = req.getRequestDataAsString();
        try {
            StudioAssistAcceptAnswerRequest request = (StudioAssistAcceptAnswerRequest)JsonUtil.fromJson((String)"EEE MMM dd HH:mm:ss zzz yyyy", (String)requestDataAsString, StudioAssistAcceptAnswerRequest.class);
            if (!this.validate(req, request)) {
                this.logger.debug("validate failed | request = %s".formatted(JsonUtil.toJson((Object)request)));
                return;
            }
            this.eventBroker.post("ON_CHAT_ACCEPT_ANSWER", (Object)request);
            req.end();
        }
        catch (Exception e) {
            this.logger.error("Exception while handle accept answer | %s | %s".formatted(requestDataAsString, e.getMessage()), (Throwable)e);
            req.sendResponseHeaders(500, -1);
        }
    }

    private boolean validate(CustomRequest req, StudioAssistAcceptAnswerRequest request) throws IOException {
        if (request == null || StringUtils.isBlank((CharSequence)request.getConversationId()) || StringUtils.isBlank((CharSequence)request.getQuestionMsgId()) || StringUtils.isBlank((CharSequence)request.getQuestionContent())) {
            req.sendResponseHeaders(400, -1);
            return false;
        }
        return true;
    }
}

