/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistChatTrackingHandler
extends CustomHttpHandler {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistChatTrackingHandler.class);
    @Inject
    private IEventBroker eventBroker;

    @Override
    public void customHandle(CustomRequest req) throws IOException {
        try {
            String requestData = req.getRequestDataAsString();
            if (requestData == null || requestData.isEmpty()) {
                req.end();
                return;
            }
            List trackingData = (List)JsonUtil.fromJson((String)requestData, List.class);
            this.eventBroker.post("ON_STUDIO_ASSIST_TRACKING", (Object)trackingData);
            req.end();
        }
        catch (Exception e) {
            this.logger.error("%s | %s | %s".formatted("Exception while handle tracking", req.getRequestDataAsString(), e.getMessage()), (Throwable)e);
            req.sendResponseHeaders(500, -1);
        }
    }
}

