/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.constants;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public enum TextContentType {
    TEXT("Text", "text/plain"),
    JSON("JSON", "application/json"),
    XML("XML", "application/xml"),
    HTML("HTML", "text/html"),
    JAVASCRIPT("JavaScript", "application/javascript");

    private String text;
    private String contentType;

    private TextContentType(String text, String contentType) {
        this.text = text;
        this.contentType = contentType;
    }

    public String getText() {
        return this.text;
    }

    public String getContentType() {
        return this.contentType;
    }

    public static String[] getTextValues() {
        return (String[])Arrays.asList(TextContentType.values()).stream().map(t -> t.getText()).toArray(String[]::new);
    }

    public static TextContentType evaluateContentType(String contentType) {
        String sanitizedContentType = StringUtils.substringBefore((String)contentType, (String)";");
        switch (StringUtils.defaultString((String)sanitizedContentType)) {
            case "application/json": 
            case "application/ld+json": {
                return JSON;
            }
            case "application/ecmascript": 
            case "application/javascript": {
                return JAVASCRIPT;
            }
            case "application/atom+xml": 
            case "application/xml": 
            case "text/xml": 
            case "application/soap+xml": {
                return XML;
            }
            case "text/html": 
            case "application/xhtml+xml": {
                return HTML;
            }
        }
        return TEXT;
    }
}

