/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.control;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ImageButton
extends Composite {
    private Color textColor;
    private Image image;
    private String text;
    private int width;
    private int height;
    private boolean copied;

    public ImageButton(Composite parent, int style) {
        super(parent, style);
        Display display = parent.getDisplay();
        this.textColor = display.getSystemColor(1);
        this.text = "";
        this.addListener(12, new Listener(){

            public void handleEvent(Event arg0) {
                if (ImageButton.this.copied && ImageButton.this.image != null) {
                    ImageButton.this.image.dispose();
                }
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                ImageButton.this.paintControl(e);
            }
        });
    }

    private void paintControl(Event event) {
        GC gc = event.gc;
        if (this.image != null) {
            gc.drawImage(this.image, 1, 1 + (this.getBounds().height - this.height) / 2);
            Point textSize = gc.textExtent(this.text);
            gc.setForeground(this.textColor);
            gc.drawText(this.text, (this.width - textSize.x) / 2 + 1, (this.height - textSize.y) / 2 + 1, true);
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.copied = false;
        if (image.isDisposed()) {
            this.image = new Image((Device)Display.getDefault(), image, 0);
            this.copied = true;
        }
        this.width = image.getBounds().width;
        this.height = image.getBounds().height;
        this.redraw();
    }

    public void setText(String text) {
        this.text = text;
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int overallWidth = this.width;
        int overallHeight = this.height;
        if (wHint != -1 && wHint < overallWidth) {
            overallWidth = wHint;
        }
        if (hHint != -1 && hHint < overallHeight) {
            overallHeight = hHint;
        }
        return new Point(overallWidth + 2, overallHeight + 2);
    }
}

