/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.control;

import com.kms.katalon.composer.components.impl.control.FocusableComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ResizableBackgroundImageComposite
extends FocusableComposite
implements Listener {
    private Image originalImage;

    public ResizableBackgroundImageComposite(Composite parent, int style, Image originalImage) {
        super(parent, style);
        this.originalImage = originalImage;
        this.addListener(11, this);
    }

    public void handleEvent(Event event) {
        if (event.type == 11) {
            this.changeImage();
        }
    }

    private void changeImage() {
        this.disposeCurrentImage();
        if (this.originalImage != null) {
            Rectangle rect = this.getClientArea();
            this.setBackgroundImage(this.resize(this.originalImage, rect.width, rect.height));
        }
    }

    private Image resize(Image image, int width, int height) {
        Rectangle imageBounds = image.getBounds();
        int imageWidth = imageBounds.width;
        int imageHeight = imageBounds.height;
        if (width == imageWidth && height == imageHeight) {
            return image;
        }
        Image scaled = new Image((Device)this.getDisplay(), width, height);
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, imageWidth, imageHeight, 0, 0, width, height);
        gc.dispose();
        return scaled;
    }

    public void dispose() {
        this.disposeCurrentImage();
        super.dispose();
    }

    private void disposeCurrentImage() {
        Image oldImage = this.getBackgroundImage();
        if (oldImage != null && oldImage != this.originalImage) {
            oldImage.dispose();
        }
    }
}

