/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.dialogs.AbstractEntityDialog;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.dal.exception.InvalidNameException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class CommonNewEntityDialog<T extends FileEntity>
extends AbstractEntityDialog {
    protected T entity;
    private String description;

    public CommonNewEntityDialog(Shell parentShell, FolderEntity parentFolder, String suggestedName) {
        super(parentShell, parentFolder);
        this.setName(suggestedName);
    }

    @Override
    protected Control createEntityCustomControl(Composite parent, int column, int span) {
        return this.createPropertiesControl(parent, column, span);
    }

    protected Control createPropertiesControl(Composite parent, int column, int span) {
        Label lblDescription = new Label(parent, 0);
        lblDescription.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblDescription.setText(StringConstants.DESCRIPTION);
        Text txtDescription = new Text(parent, 2626);
        GridData descLayoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        descLayoutData.heightHint = 80;
        txtDescription.setLayoutData((Object)descLayoutData);
        txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonNewEntityDialog.this.description = ((Text)e.getSource()).getText();
            }
        });
        if (span > 0) {
            CommonNewEntityDialog.createEmptySpace(parent, span);
        }
        return parent;
    }

    public T getEntity() {
        return this.entity;
    }

    protected abstract void createEntity();

    protected void setEntityProperties() {
        this.entity.setDescription(StringUtils.trimToEmpty((String)this.description));
    }

    protected void okPressed() {
        if (!DialogUtil.getCanClickOK((Shell)this.getShell())) {
            return;
        }
        this.createEntity();
        if (this.entity != null) {
            this.setEntityProperties();
        }
        super.okPressed();
    }

    @Override
    public void validateEntityName(String entityName) throws Exception {
        if (EntityNameController.getInstance().isNameExisted(this.parentFolder, entityName)) {
            throw new InvalidNameException(StringConstants.DIA_NAME_EXISTED);
        }
    }

    protected void handleShellCloseEvent() {
        if (!DialogUtil.getCanClose((Shell)this.getShell())) {
            return;
        }
        super.handleShellCloseEvent();
    }

    protected boolean canHandleShellCloseEvent() {
        return true;
    }
}

