/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.entity.file.FileEntity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CommonPropertiesDialog<T extends FileEntity>
extends AbstractDialog {
    private boolean isModified;
    private T entity;
    protected Text txtId;
    protected Text txtName;
    protected Text txtDescription;
    protected ModifyListener modifyListener;

    public CommonPropertiesDialog(Shell parentShell, T entity) {
        super(parentShell);
        this.entity = entity;
    }

    protected int getShellStyle() {
        return 0x8860 | CommonPropertiesDialog.getDefaultOrientation();
    }

    @Override
    protected Control createDialogContainer(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout glMain = new GridLayout(1, false);
        glMain.marginHeight = 0;
        glMain.marginWidth = 0;
        main.setLayout((Layout)glMain);
        Composite container = new Composite(main, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblId = new Label(container, 0);
        lblId.setText(StringConstants.ID);
        this.txtId = new Text(container, 2056);
        this.txtId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblName = new Label(container, 0);
        lblName.setText(StringConstants.NAME);
        this.txtName = new Text(container, 2056);
        this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblDescription = new Label(container, 0);
        lblDescription.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblDescription.setText(StringConstants.DESCRIPTION);
        this.txtDescription = new Text(container, 2626);
        GridData descLayoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        descLayoutData.heightHint = 80;
        this.txtDescription.setLayoutData((Object)descLayoutData);
        return container;
    }

    @Override
    protected void setInput() {
        this.setModified(false);
        this.txtId.setText(this.getEntity().getIdForDisplay());
        this.txtName.setText(this.getEntity().getName());
        this.txtDescription.setText(StringUtils.defaultString((String)this.getEntity().getDescription()));
    }

    @Override
    protected void registerControlModifyListeners() {
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonPropertiesDialog.this.setModified(true);
            }
        };
        this.txtDescription.addModifyListener(this.modifyListener);
    }

    protected Point getInitialSize() {
        return new Point(500, super.getInitialSize().y);
    }

    protected void okPressed() {
        this.updateChanges();
        super.okPressed();
    }

    protected void updateChanges() {
        if (!this.isModified()) {
            return;
        }
        this.getEntity().setDescription(StringUtils.trimToEmpty((String)this.txtDescription.getText()));
    }

    public T getEntity() {
        return this.entity;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean isModified) {
        this.isModified = isModified;
    }
}

