/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.core.testdata.TestData;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TestDataColumnChooserDialog
extends Dialog {
    private Table table;
    private TableViewer tableViewer;
    private String selectedColumnName;
    private Link lblStatus;
    private TestData testData;
    private Label lblImage;
    private Composite container;
    private Composite compositeStatus;

    private void setTestData(TestData testData) {
        this.testData = testData;
    }

    private void setSelectedColumnName(String selectionName) {
        this.selectedColumnName = selectionName;
    }

    public TestDataColumnChooserDialog(Shell parentShell, TestData testData, String selectionName) {
        super(parentShell);
        this.setTestData(testData);
        this.setSelectedColumnName(selectionName);
    }

    public void create() {
        super.create();
        this.getShell().setText(ComposerComponentsImplMessageConstants.DIA_MSG_CHOOSE_DATA_COLUMN);
        this.setInput();
        this.registerListeners();
        this.validate();
    }

    private void registerListeners() {
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestDataColumnChooserDialog.this.validate();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (TestDataColumnChooserDialog.this.getButton(0).isEnabled()) {
                    TestDataColumnChooserDialog.this.okPressed();
                }
            }
        });
        this.lblStatus.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)TestDataColumnChooserDialog.this.testData.getSourceUrl());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void validate() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection == null || selection.getFirstElement() == null) {
            this.getButton(0).setEnabled(false);
            return;
        }
        ColumnNameIndexPair pair = (ColumnNameIndexPair)selection.getFirstElement();
        if (pair.getColumnName() == null) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
        this.selectedColumnName = pair.getColumnName();
    }

    private void setInput() {
        String[] columnNames;
        ArrayList<ColumnNameIndexPair> pairLst = new ArrayList<ColumnNameIndexPair>();
        ColumnNameIndexPair selection = null;
        ArrayList<Integer> emptyColumnIndexes = new ArrayList<Integer>();
        try {
            if (this.testData == null) {
                return;
            }
            columnNames = this.testData.getColumnNames();
        }
        catch (IOException iOException) {
            return;
        }
        int i = 0;
        while (i < columnNames.length) {
            ColumnNameIndexPair pair = new ColumnNameIndexPair(i, columnNames[i]);
            pairLst.add(pair);
            if (this.selectedColumnName != null && this.selectedColumnName.equals(pair.getColumnName())) {
                selection = pair;
            }
            if (pair.getColumnName() == null || pair.getColumnName().isEmpty()) {
                emptyColumnIndexes.add(i + 1);
            }
            ++i;
        }
        if (emptyColumnIndexes.size() > 0) {
            this.lblStatus.setToolTipText("Click to open");
            this.lblStatus.setText("Data source <A>" + this.testData.getSourceUrl() + "</A> has " + emptyColumnIndexes.size() + " empty column(s) name");
        } else {
            this.lblStatus.getParent().setVisible(false);
            ((GridData)this.compositeStatus.getLayoutData()).exclude = true;
        }
        this.tableViewer.setInput(pairLst);
        if (selection != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)selection));
        }
        this.container.layout(true, true);
        this.container.redraw();
    }

    protected Control createDialogArea(Composite parent) {
        this.container = (Composite)super.createDialogArea(parent);
        GridLayout glContainer = new GridLayout(1, false);
        glContainer.verticalSpacing = 10;
        this.container.setLayout((Layout)glContainer);
        this.compositeStatus = new Composite(this.container, 0);
        GridLayout glComposite = new GridLayout(2, false);
        glComposite.marginHeight = 0;
        this.compositeStatus.setLayout((Layout)glComposite);
        this.compositeStatus.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.lblImage = new Label(this.compositeStatus, 0);
        this.lblImage.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblImage.setImage(ImageConstants.IMG_16_WARN_TABLE_ITEM);
        this.lblStatus = new Link(this.compositeStatus, 72);
        this.lblStatus.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.tableViewer = new TableViewer(this.container, 67584);
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setLinesVisible(ControlUtils.shouldLineVisble(this.table.getDisplay()));
        this.table.setHeaderVisible(true);
        TableViewerColumn tableViewerColumnOrder = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnColumnOrder = tableViewerColumnOrder.getColumn();
        tblclmnColumnOrder.setWidth(60);
        tblclmnColumnOrder.setText(GlobalMessageConstants.NO_);
        tableViewerColumnOrder.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(1){

            public void update(ViewerCell cell) {
                super.update(cell);
                if (cell.getElement() == null || !(cell.getElement() instanceof ColumnNameIndexPair)) {
                    return;
                }
                cell.setText(Integer.toString(((ColumnNameIndexPair)cell.getElement()).getIndex() + 1));
                String columnName = ((ColumnNameIndexPair)cell.getElement()).getColumnName();
                if (StringUtils.isEmpty((String)columnName)) {
                    cell.setImage(ImageConstants.IMG_16_WARN_TABLE_ITEM);
                }
            }

            public String getToolTipText(Object element) {
                String columnName = ((ColumnNameIndexPair)element).getColumnName();
                if (StringUtils.isEmpty((String)columnName)) {
                    return ComposerComponentsImplMessageConstants.DIA_WARN_MSG_EMPTY_COLUMN_NAME;
                }
                return Integer.toString(((ColumnNameIndexPair)element).getIndex() + 1);
            }
        });
        TableViewerColumn tableViewerColumnName = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnColumnName = tableViewerColumnName.getColumn();
        tblclmnColumnName.setWidth(320);
        tblclmnColumnName.setText("Column Name");
        tableViewerColumnName.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(1){

            public void update(ViewerCell cell) {
                String columnName;
                cell.setText(this.getText(cell.getElement()));
                Object element = cell.getElement();
                if (element == null || !(element instanceof ColumnNameIndexPair)) {
                    cell.setForeground(ColorUtil.getErrorTableItemForegroundColor());
                }
                if (element != null && StringUtils.isEmpty((String)(columnName = ((ColumnNameIndexPair)element).getColumnName()))) {
                    cell.setForeground(ColorUtil.getErrorTableItemForegroundColor());
                }
                super.update(cell);
            }

            public String getText(Object element) {
                if (element == null || !(element instanceof ColumnNameIndexPair)) {
                    return "";
                }
                String columnName = ((ColumnNameIndexPair)element).getColumnName();
                return StringUtils.isEmpty((String)columnName) ? ComposerComponentsImplMessageConstants.DIA_TABLE_EMPTY_COLUMN : columnName;
            }

            public String getToolTipText(Object element) {
                String columnName = ((ColumnNameIndexPair)element).getColumnName();
                if (columnName == null || columnName.isEmpty()) {
                    return ComposerComponentsImplMessageConstants.DIA_WARN_MSG_EMPTY_COLUMN_NAME;
                }
                return this.getText(element);
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.getTable().setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        return this.container;
    }

    public String getSelectedColumnName() {
        return this.selectedColumnName;
    }

    protected Point getInitialSize() {
        return new Point(440, 400);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ComposerComponentsImplMessageConstants.DIA_SHELL_TEST_DATA_LINK_BROWSER);
    }

    protected void setShellStyle(int arg) {
        super.setShellStyle(112);
    }

    private class ColumnNameIndexPair {
        private int index;
        private String columnName;

        public ColumnNameIndexPair(int index, String columnName) {
            this.index = index;
            this.columnName = columnName;
        }

        public int getIndex() {
            return this.index;
        }

        public String getColumnName() {
            return this.columnName;
        }
    }
}

