/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.editors.extensions;

import com.kms.katalon.composer.components.impl.editors.extensions.CodeSelectHelper;
import java.lang.reflect.InvocationTargetException;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class SelectionConverter {
    private static final IJavaElement[] EMPTY_RESULT = new IJavaElement[0];

    private SelectionConverter() {
    }

    public static IStructuredSelection getStructuredSelection(IWorkbenchPart part) throws JavaModelException {
        ISelection selection;
        if (part instanceof JavaEditor) {
            return new StructuredSelection((Object[])SelectionConverter.codeResolve((JavaEditor)part));
        }
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static IJavaElement[] getElements(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            IJavaElement[] result = new IJavaElement[selection.size()];
            int i = 0;
            for (Object element : selection) {
                if (!(element instanceof IJavaElement)) {
                    return EMPTY_RESULT;
                }
                result[i] = (IJavaElement)element;
                ++i;
            }
            return result;
        }
        return EMPTY_RESULT;
    }

    public static boolean canOperateOn(JavaEditor editor) {
        if (editor == null) {
            return false;
        }
        return SelectionConverter.getInput(editor) != null;
    }

    public static IJavaElement[] codeResolveOrInputForked(JavaEditor editor) throws InvocationTargetException, InterruptedException {
        ITypeRoot input = SelectionConverter.getInput(editor);
        if (input == null) {
            return EMPTY_RESULT;
        }
        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
        IJavaElement[] result = SelectionConverter.performForkedCodeResolve(input, selection);
        if (result.length == 0) {
            result = new IJavaElement[]{input};
        }
        return result;
    }

    public static IJavaElement[] codeResolve(JavaEditor editor) throws JavaModelException {
        return SelectionConverter.codeResolve(editor, true);
    }

    public static IJavaElement[] codeResolve(JavaEditor editor, boolean primaryOnly) throws JavaModelException {
        ITypeRoot input = SelectionConverter.getInput(editor, primaryOnly);
        if (input != null) {
            return SelectionConverter.codeResolve((IJavaElement)input, (ITextSelection)editor.getSelectionProvider().getSelection());
        }
        return EMPTY_RESULT;
    }

    public static IJavaElement[] codeResolveForked(JavaEditor editor, boolean primaryOnly) throws InvocationTargetException, InterruptedException {
        ITypeRoot input = SelectionConverter.getInput(editor, primaryOnly);
        if (input != null) {
            return SelectionConverter.performForkedCodeResolve(input, (ITextSelection)editor.getSelectionProvider().getSelection());
        }
        return EMPTY_RESULT;
    }

    public static IJavaElement getElementAtOffset(JavaEditor editor) throws JavaModelException {
        return SelectionConverter.getElementAtOffset(editor, true);
    }

    public static IJavaElement getElementAtOffset(JavaEditor editor, boolean primaryOnly) throws JavaModelException {
        ITypeRoot input = SelectionConverter.getInput(editor, primaryOnly);
        if (input != null) {
            return SelectionConverter.getElementAtOffset(input, (ITextSelection)editor.getSelectionProvider().getSelection());
        }
        return null;
    }

    public static IType getTypeAtOffset(JavaEditor editor) throws JavaModelException {
        ICompilationUnit unit;
        IJavaElement element = SelectionConverter.getElementAtOffset(editor);
        IType type = (IType)element.getAncestor(7);
        if (type == null && (unit = SelectionConverter.getInputAsCompilationUnit(editor)) != null) {
            type = unit.findPrimaryType();
        }
        return type;
    }

    public static ITypeRoot getInput(JavaEditor editor) {
        return SelectionConverter.getInput(editor, true);
    }

    private static ITypeRoot getInput(JavaEditor editor, boolean primaryOnly) {
        if (editor == null) {
            return null;
        }
        return EditorUtility.getEditorInputJavaElement((IEditorPart)editor, (boolean)primaryOnly);
    }

    public static ICompilationUnit getInputAsCompilationUnit(JavaEditor editor) {
        ITypeRoot editorInput = SelectionConverter.getInput(editor);
        if (editorInput instanceof ICompilationUnit) {
            return (ICompilationUnit)editorInput;
        }
        return null;
    }

    private static IJavaElement[] performForkedCodeResolve(ITypeRoot input, ITextSelection selection) throws InvocationTargetException, InterruptedException {
        final class CodeResolveRunnable
        implements IRunnableWithProgress {
            IJavaElement[] result;
            private final /* synthetic */ ITypeRoot val$input;
            private final /* synthetic */ ITextSelection val$selection;

            CodeResolveRunnable(ITypeRoot iTypeRoot, ITextSelection iTextSelection) {
                this.val$input = iTypeRoot;
                this.val$selection = iTextSelection;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    this.result = SelectionConverter.codeResolve((IJavaElement)this.val$input, this.val$selection);
                }
                catch (JavaModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
        CodeResolveRunnable runnable = new CodeResolveRunnable(input, selection);
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)runnable);
        return runnable.result;
    }

    public static IJavaElement[] codeResolve(IJavaElement input, ITextSelection selection) throws JavaModelException {
        if (input instanceof ICodeAssist) {
            CodeSelectHelper selectHelper;
            IJavaElement[] elements;
            if (input instanceof ICompilationUnit) {
                JavaModelUtil.reconcile((ICompilationUnit)((ICompilationUnit)input));
            }
            if ((elements = (selectHelper = new CodeSelectHelper()).select((GroovyCompilationUnit)input, selection.getOffset() + selection.getLength(), 0)).length > 0) {
                return elements;
            }
        }
        return EMPTY_RESULT;
    }

    public static IJavaElement getElementAtOffset(ITypeRoot input, ITextSelection selection) throws JavaModelException {
        IJavaElement ref;
        if (input instanceof ICompilationUnit) {
            JavaModelUtil.reconcile((ICompilationUnit)((ICompilationUnit)input));
        }
        if ((ref = input.getElementAt(selection.getOffset())) == null) {
            return input;
        }
        return ref;
    }

    public static IJavaElement resolveEnclosingElement(JavaEditor editor, ITextSelection selection) throws JavaModelException {
        ITypeRoot input = SelectionConverter.getInput(editor);
        if (input != null) {
            return SelectionConverter.resolveEnclosingElement((IJavaElement)input, selection);
        }
        return null;
    }

    public static IJavaElement resolveEnclosingElement(IJavaElement input, ITextSelection selection) throws JavaModelException {
        IJavaElement atOffset = null;
        if (input instanceof ICompilationUnit) {
            ICompilationUnit cunit = (ICompilationUnit)input;
            JavaModelUtil.reconcile((ICompilationUnit)cunit);
            atOffset = cunit.getElementAt(selection.getOffset());
        } else if (input instanceof IClassFile) {
            IClassFile cfile = (IClassFile)input;
            atOffset = cfile.getElementAt(selection.getOffset());
        } else {
            return null;
        }
        if (atOffset == null) {
            return input;
        }
        int selectionEnd = selection.getOffset() + selection.getLength();
        IJavaElement result = atOffset;
        if (atOffset instanceof ISourceReference) {
            ISourceRange range = ((ISourceReference)atOffset).getSourceRange();
            while (range.getOffset() + range.getLength() < selectionEnd) {
                if (!((result = result.getParent()) instanceof ISourceReference)) {
                    result = input;
                    break;
                }
                range = ((ISourceReference)result).getSourceRange();
            }
        }
        return result;
    }

    public static IJavaElement selectJavaElement(IJavaElement[] elements, Shell shell, String title, String message) {
        int nResults = elements.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return elements[0];
        }
        int flags = 1106;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements((Object[])elements);
        if (dialog.open() == 0) {
            return (IJavaElement)dialog.getFirstResult();
        }
        return null;
    }
}

