/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.installer;

import com.kms.katalon.composer.components.impl.exception.RunInstallationStepException;
import com.kms.katalon.composer.components.impl.installer.InstallationStep;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class InstallationCommandStep
extends InstallationStep {
    private String command;
    private String preConditionFailedCommand;
    private String workingDirectory;
    private Map<String, String> envs;
    private PreConditionFunc preCondition;

    public InstallationCommandStep(String title, File logFile, File errorLogFile, String command, String workingDirectory) {
        super(title, logFile, errorLogFile);
        this.command = command;
        this.workingDirectory = workingDirectory;
        this.preCondition = () -> true;
    }

    public InstallationCommandStep(String title, File logFile, String command, String workingDirectory) {
        this(title, logFile, null, command, workingDirectory);
    }

    public InstallationCommandStep(String title, File logFile, File errorLogFile, String command) {
        this(title, logFile, errorLogFile, command, "");
    }

    public InstallationCommandStep(String title, File logFile, String command) {
        this(title, logFile, null, command, "");
    }

    public InstallationCommandStep(String title, String command, String workingDirectory) {
        this(title, null, null, command, workingDirectory);
    }

    public InstallationCommandStep(String title, String command) {
        this(title, null, null, command, "");
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            if (this.checkingPreCondition(this.preCondition)) {
                if (this.runCommand(this.command, this.getEnvs(), this.workingDirectory, this.getLogFile(), this.getErrorLogFile()) != 0) {
                    throw new RunInstallationStepException("Failed to run the installation command.", new Throwable(String.format("Command: \"%s\"", this.command)));
                }
            } else if (StringUtils.isNotBlank((String)this.preConditionFailedCommand)) {
                this.runCommand(this.preConditionFailedCommand, this.getEnvs(), this.workingDirectory, this.getLogFile(), this.getErrorLogFile());
            }
        }
        catch (Exception error) {
            LoggerSingleton.logError((Throwable)error);
            throw new RunInstallationStepException("Failed to run the installation command.", error);
        }
    }

    private int runCommand(String command, Map<String, String> envs, String workingDirectory, File logFile, File errorLogFile) throws IOException, InterruptedException {
        String fullCommand = ConsoleCommandExecutor.getSourcesLoadingCommand() + "; " + command;
        ProcessBuilder processBuilder = ConsoleCommandExecutor.build((String)fullCommand, (String)workingDirectory, envs);
        if (logFile != null) {
            processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(logFile));
        }
        if (errorLogFile != null) {
            processBuilder.redirectError(ProcessBuilder.Redirect.appendTo(errorLogFile));
        }
        Process process = processBuilder.start();
        return process.waitFor();
    }

    private boolean checkingPreCondition(PreConditionFunc preCondition) throws Exception {
        return preCondition.runCheck();
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public Map<String, String> getEnvs() {
        return this.envs;
    }

    public void setEnvironments(Map<String, String> envs) {
        this.envs = envs;
    }

    public void setPreCondition(PreConditionFunc preCondition) {
        this.preCondition = preCondition;
    }

    public PreConditionFunc getPreCondition() {
        return this.preCondition;
    }

    public void setPreConditionFailedCommand(String preConditionFailedCommand) {
        this.preConditionFailedCommand = preConditionFailedCommand;
    }

    public String getPreConditionFailedCommand() {
        return this.preConditionFailedCommand;
    }

    public static interface PreConditionFunc {
        public boolean runCheck() throws Exception;
    }
}

